/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.common.busi.api.UccGoodsHangSetBusiService;
import com.tydic.commodity.common.busi.bo.UccGoodsHangSetReqBO;
import com.tydic.commodity.common.busi.bo.UccGoodsHangSetRspBO;
import com.tydic.commodity.dao.UccSkuHangOnMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuHangOnPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccGoodsHangSetBusiServiceImpl
implements UccGoodsHangSetBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccGoodsHangSetBusiServiceImpl.class);
    public static final String OPER_TYPE_HANG_ON = "1";
    public static final String OPER_TYPE_CANCEL_HANG_ON = "2";
    @Autowired
    private UccSkuHangOnMapper uccSkuHangOnMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccGoodsHangSetRspBO goodsHangSet(UccGoodsHangSetReqBO reqBO) {
        UccSkuHangOnPO uccSkuHangOnPo;
        UccGoodsHangSetRspBO rspBO = new UccGoodsHangSetRspBO();
        if (OPER_TYPE_HANG_ON.equals(reqBO.getType())) {
            uccSkuHangOnPo = new UccSkuHangOnPO();
            uccSkuHangOnPo.setSkuId(reqBO.getSkuId());
            uccSkuHangOnPo.setCreateTime(new Date());
            this.uccSkuHangOnMapper.insert(uccSkuHangOnPo);
        } else if (OPER_TYPE_CANCEL_HANG_ON.equals(reqBO.getType())) {
            uccSkuHangOnPo = new UccSkuHangOnPO();
            uccSkuHangOnPo.setSkuId(reqBO.getSkuId());
            this.uccSkuHangOnMapper.deleteBy(uccSkuHangOnPo);
        } else {
            throw new ZTBusinessException(RspConstantEnums.NON_SPECIFICATIONS.message());
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBO.getSkuId());
        List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        ArrayList<Long> skuIds = new ArrayList<Long>();
        skuIds.add(reqBO.getSkuId());
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(skuIds);
        syncSceneCommodityToEsReqBO.setSupplierId(((UccSkuPo)uccSkuPoList.get(0)).getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

