/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCombSpuTheEditorAbilityService;
import com.tydic.commodity.common.ability.bo.UccCombSpuTheEditorAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCombSpuTheeditorAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuCombinedInfoBO;
import com.tydic.commodity.common.busi.api.UccCombSpuTheEditorBusiService;
import com.tydic.commodity.common.busi.bo.UccCombSpuTheEditorBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccCombSpuTheEditorBusiRspBO;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCombSpuTheEditorAbilityService"})
public class UccCombSpuTheEditorAbilityServiceImpl
implements UccCombSpuTheEditorAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCombSpuTheEditorAbilityServiceImpl.class);
    @Autowired
    private UccCombSpuTheEditorBusiService busiService;

    public String verify(UccCombSpuTheEditorAbilityReqBO reqBO) {
        if (reqBO.getCombinedId() == null) {
            return "\u7ec4\u5408\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSpuList())) {
            return "\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (UccSpuCombinedInfoBO infoBO : reqBO.getSpuList()) {
            if (infoBO.getCommodityId() != null && infoBO.getCount() != null && infoBO.getCombinedInfoType() != null && infoBO.getSupplierShopId() != null && infoBO.getSkuId() != null) continue;
            return "\u7ec4\u5408\u5546\u54c1\u6e05\u5355\u4fe1\u606f\u6709\u8bef";
        }
        if (reqBO.getSubmitType() == null) {
            return "\u63d0\u4ea4\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBO.getEffTimeStart() == null || reqBO.getEffTimeEnd() == null || reqBO.getEffTimeStart().after(reqBO.getEffTimeEnd())) {
            return "\u751f\u6548\u65f6\u95f4\u9519\u8bef";
        }
        if (reqBO.getEffTimeEnd().before(new Date(System.currentTimeMillis()))) {
            return "\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4";
        }
        return null;
    }

    @PostMapping(value={"dealUccCombSpuTheEditor"})
    public UccCombSpuTheeditorAbilityRspBO dealUccCombSpuTheEditor(@RequestBody UccCombSpuTheEditorAbilityReqBO reqBO) {
        UccCombSpuTheeditorAbilityRspBO rspBO = new UccCombSpuTheeditorAbilityRspBO();
        String checkStr = this.verify(reqBO);
        if (checkStr != null && !"".equals(checkStr)) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc(checkStr);
            return rspBO;
        }
        UccCombSpuTheEditorBusiReqBO busiReqBO = new UccCombSpuTheEditorBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        if (reqBO.getSubmitType() == 0) {
            busiReqBO.setCombinedStatus(0);
        } else {
            Date nowDay;
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String s = sdf.format(new Date());
                nowDay = sdf.parse(s);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u8f6c\u6362\u62a5\u9519");
            }
            busiReqBO.setCombinedStatus(1);
            if (busiReqBO.getEffTimeStart() != null && busiReqBO.getEffTimeStart().after(nowDay)) {
                busiReqBO.setCombinedStatus(3);
            } else if (busiReqBO.getEffTimeEnd() != null && busiReqBO.getEffTimeEnd().before(nowDay)) {
                busiReqBO.setCombinedStatus(2);
            }
        }
        busiReqBO.setUpdateOperName(reqBO.getUsername());
        UccCombSpuTheEditorBusiRspBO ucc = this.busiService.dealUccCombSpuTheEditor(busiReqBO);
        if (ucc == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            return rspBO;
        }
        BeanUtils.copyProperties((Object)((Object)ucc), (Object)rspBO);
        return rspBO;
    }
}

