/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.common.ability.api.UccQuoteValidityTimeUpdateAbilityService;
import com.tydic.commodity.common.ability.bo.TimeUpdateReqBo;
import com.tydic.commodity.common.ability.bo.TimeUpdateRspBo;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.Arrays;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccQuoteValidityTimeUpdateAbilityService"})
public class UccQuoteValidityTimeUpdateAbilityServiceImpl
implements UccQuoteValidityTimeUpdateAbilityService {
    private static final Logger log = LogManager.getLogger(UccQuoteValidityTimeUpdateAbilityServiceImpl.class);
    @Autowired
    UccSkuPriceMapper uccSkuPriceMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @PostMapping(value={"validityUpdate"})
    public TimeUpdateRspBo validityUpdate(@RequestBody TimeUpdateReqBo reqBo) {
        TimeUpdateRspBo rspBo = new TimeUpdateRspBo();
        if (reqBo.getSkuId() == null) {
            rspBo.setRespCode("0001");
            rspBo.setRespDesc("\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccSkuPricePo po = new UccSkuPricePo();
        po.setSkuId(reqBo.getSkuId());
        po.setEffTime(reqBo.getEffTime());
        try {
            this.uccSkuPriceMapper.updateSkuPrice(po);
        }
        catch (Exception e) {
            rspBo.setRespCode("0002");
            rspBo.setRespDesc(e.getMessage());
            return rspBo;
        }
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(Arrays.asList(reqBo.getSkuId()));
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            rspBo.setRespCode("0003");
            rspBo.setRespDesc(e.getMessage());
            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

