/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccSyncSpuBuyItemAbilityService;
import com.tydic.commodity.common.ability.bo.UccSyncSpuBuyItemAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSyncSpuBuyItemAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSyncSpuBuyItemBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSyncSpuBuyItemAbilityService"})
public class UccSyncSpuBuyItemAbilityServiceImpl
implements UccSyncSpuBuyItemAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSyncSpuBuyItemAbilityServiceImpl.class);
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;

    @PostMapping(value={"dealSyncSpuBuyItem"})
    public UccSyncSpuBuyItemAbilityRspBO dealSyncSpuBuyItem(@RequestBody UccSyncSpuBuyItemAbilityReqBO reqBO) {
        UccSyncSpuBuyItemAbilityRspBO rspBO = new UccSyncSpuBuyItemAbilityRspBO();
        if (reqBO.getCount() == 1) {
            StringBuilder sb = new StringBuilder("");
            String data = "ctx._source.item =0;ctx._source.itemName = null";
            JSONObject obj = new JSONObject();
            JSONObject script = new JSONObject();
            script.put("source", (Object)data);
            obj.put("script", (Object)script);
            JSONObject match = new JSONObject();
            match.put("match_all", (Object)new JSONObject());
            obj.put("query", (Object)match);
            String result = this.elasticsearchUtil.updateByQuery(this.esConfig.getIndexName(), this.esConfig.getEsType(), JSONObject.toJSONString((Object)obj));
            if (StringUtils.isEmpty((Object)result)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
                return rspBO;
            }
        }
        for (UccSyncSpuBuyItemBO each : reqBO.getItemList()) {
            this.updateSpecifyEs(each);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    void updateSpecifyEs(UccSyncSpuBuyItemBO itemBO) throws BusinessException {
        JSONObject object = new JSONObject();
        object.put("item", (Object)itemBO.getItem());
        object.put("itemName", (Object)itemBO.getItemName());
        try {
            this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), itemBO.getSkuId().toString(), object);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u66f4\u65b0\u5f02\u5e38: " + e.getMessage());
            throw new BusinessException("8888", "\u66f4\u65b0\u5546\u54c1ES\u5931\u8d25\uff1a " + e.getMessage());
        }
    }
}

