/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.bo.UccCombinedDetailInfoBo;
import com.tydic.commodity.common.busi.api.UccCombSpuDetailsQryBusiService;
import com.tydic.commodity.common.busi.bo.UccCombSpuDetailsQryBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccCombSpuDetailsQryBusiRspBO;
import com.tydic.commodity.dao.UccCombSpuMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccCombSpuCatalogPo;
import com.tydic.commodity.po.UccCombSpuDetailsQryPo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccCombSpuDetailsQryBusiServiceImpl
implements UccCombSpuDetailsQryBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccCombSpuDetailsQryBusiServiceImpl.class);
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    @Autowired
    private UccCombSpuMapper uccCombSpuMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;

    @Override
    public UccCombSpuDetailsQryBusiRspBO getCombSpuDetailsQry(UccCombSpuDetailsQryBusiReqBO reqBO) {
        UccCombSpuDetailsQryBusiRspBO rspBO = new UccCombSpuDetailsQryBusiRspBO();
        UccCombSpuDetailsQryPo qryPo = new UccCombSpuDetailsQryPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)qryPo);
        UccCombSpuDetailsQryPo rspPo = this.uccCombSpuMapper.queryCombSpuDetails(qryPo);
        if (rspPo == null || CollectionUtils.isEmpty((Collection)rspPo.getCombinedDetailInfo())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u8be6\u60c5\u5931\u8d25");
            return rspBO;
        }
        rspBO.setScope(rspPo.getScope());
        rspBO.setCombinedName(rspPo.getCombinedName());
        rspBO.setEffTimeEnd(rspPo.getEffTimeEnd());
        rspBO.setEffTimeStart(rspPo.getEffTimeStart());
        List<UccCombinedDetailInfoBo> collect = rspPo.getCombinedDetailInfo().stream().map(info -> {
            UccCombinedDetailInfoBo uccCombinedDetailInfoBo = new UccCombinedDetailInfoBo();
            BeanUtils.copyProperties((Object)info, (Object)uccCombinedDetailInfoBo);
            if (info.getStoreGetType() == 1) {
                SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
                List skus = Stream.of(info.getSkuId()).collect(Collectors.toList());
                smcsdkQryStockNumReqBO.setSkuIds(skus);
                log.info("\u67e5\u8be2\u5e93\u5b58\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)smcsdkQryStockNumReqBO));
                SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
                log.info("\u67e5\u8be2\u5e93\u5b58\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)smcsdkQryStockNumRspBO));
                if (smcsdkQryStockNumRspBO == null) {
                    throw new ZTBusinessException("\u5e93\u5b58\u67e5\u8be2\u5f02\u5e38");
                }
                Long totalNum = (Long)smcsdkQryStockNumRspBO.getSkuStockNumMap().get(info.getSkuId());
                if (totalNum != null && totalNum > 0L) {
                    uccCombinedDetailInfoBo.setTotalNum(MoneyUtils.haoToYuan((Long)totalNum));
                }
            }
            if (info.getSalePrice() != null) {
                uccCombinedDetailInfoBo.setSalePrice(MoneyUtils.haoToYuan((Long)info.getSalePrice()));
            }
            if (info.getCatalogId() != null) {
                String catalogCode = this.queryCatalogCode(info.getCatalogId(), "");
                uccCombinedDetailInfoBo.setCatalogCode(catalogCode);
            }
            if (info.getCombinedInfoType() == 1) {
                rspBO.setCommodityCode(info.getCommodityCode());
                rspBO.setCommodityName(info.getCommodityName());
            }
            return uccCombinedDetailInfoBo;
        }).collect(Collectors.toList());
        for (UccCombinedDetailInfoBo bo : collect) {
            if (StringUtils.isEmpty((Object)bo.getMaterialCode())) continue;
            Long l = 0L;
            try {
                l = Long.parseLong(bo.getMaterialCode());
            }
            catch (NumberFormatException e) {
                throw new ZTBusinessException("\u5546\u54c1\u8868\u7269\u6599\u7f16\u7801\u683c\u5f0f\u9519\u8bef");
            }
            UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByPrimaryKey(l);
            if (uccEMdmMaterialPO == null) continue;
            bo.setMaterialCode(uccEMdmMaterialPO.getMaterialCode());
        }
        rspBO.setCombinedDetailInfo(collect);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String queryCatalogCode(Long catalogId, String catalogCode) {
        UccCombSpuCatalogPo po = this.uccCombSpuMapper.queryCatalog(catalogId);
        if (po != null && po.getCatalogName() != null && po.getParentCatalogId() != null && po.getCatalogLevel() != null) {
            catalogCode = po.getCatalogName() + "-" + catalogCode;
            if (po.getParentCatalogId() == 0L || po.getCatalogLevel() == 1) {
                String substring = catalogCode.substring(0, catalogCode.length() - 1);
                return substring;
            }
            return this.queryCatalogCode(po.getParentCatalogId(), catalogCode);
        }
        return catalogCode;
    }
}

