/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.MaterialPropBO;
import com.tydic.commodity.common.ability.bo.UccEMdmMaterialPicBO;
import com.tydic.commodity.common.ability.bo.UccMaterialAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccMaterialAddAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccMaterialAddBusiService;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPicMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPropDefMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPropValueMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEMdmMaterialPicPO;
import com.tydic.commodity.po.UccEMdmMaterialPropDefPO;
import com.tydic.commodity.po.UccEMdmMaterialPropValuePO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMaterialAddBusiServiceImpl
implements UccMaterialAddBusiService {
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmMaterialPicMapper uccEMdmMaterialPicMapper;
    @Autowired
    private UccEMdmMaterialPropDefMapper uccEMdmMaterialPropDefMapper;
    @Autowired
    private UccEMdmMaterialPropValueMapper uccEMdmMaterialPropValueMapper;
    private Sequence sequenceUtil = Sequence.getInstance();

    @Override
    public UccMaterialAddAbilityRspBO dealUccMaterialAdd(UccMaterialAddAbilityReqBO reqBO) {
        String userIdString = reqBO.getUserId() == null ? null : reqBO.getUserId().toString();
        Long userIdLong = reqBO.getUserId() == null ? null : reqBO.getUserId();
        UccMaterialAddAbilityRspBO rspBO = new UccMaterialAddAbilityRspBO();
        UccEMdmCatalogPO eMdmCatalogPO = new UccEMdmCatalogPO();
        eMdmCatalogPO.setIsDelete(Integer.valueOf(0));
        eMdmCatalogPO.setCatalogId(reqBO.getCatalogId());
        List catalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(eMdmCatalogPO);
        if (CollectionUtils.isEmpty((Collection)catalogPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5206\u7c7b");
            return rspBO;
        }
        if (((UccEMdmCatalogPO)catalogPOS.get(0)).getLastLevel() == 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u5206\u7c7b\u4e0d\u662f\u672b\u7ea7\u5206\u7c7b\uff0c\u4e0d\u80fd\u5173\u8054\u7269\u6599\u6570\u636e");
            return rspBO;
        }
        StringBuilder longDesc = new StringBuilder("");
        if (!StringUtils.isEmpty((Object)reqBO.getSpec())) {
            if (!StringUtils.isEmpty((Object)longDesc.toString())) {
                longDesc.append("/");
            }
            longDesc.append(reqBO.getSpec());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getModel())) {
            if (!StringUtils.isEmpty((Object)longDesc.toString())) {
                longDesc.append("/");
            }
            longDesc.append(reqBO.getModel());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getBrandName())) {
            if (!StringUtils.isEmpty((Object)longDesc.toString())) {
                longDesc.append("/");
            }
            longDesc.append(reqBO.getBrandName());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getProps())) {
            for (MaterialPropBO each2 : reqBO.getProps()) {
                if (!StringUtils.isEmpty((Object)longDesc.toString())) {
                    longDesc.append("/");
                }
                longDesc.append(each2.getPropValue());
            }
        }
        UccEMdmMaterialPO uccEMdmMaterialPO = new UccEMdmMaterialPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccEMdmMaterialPO);
        long materialId = this.sequenceUtil.nextId();
        uccEMdmMaterialPO.setMaterialId(Long.valueOf(materialId));
        uccEMdmMaterialPO.setMaterialCode(reqBO.getMaterialCode());
        uccEMdmMaterialPO.setCatalogName(((UccEMdmCatalogPO)catalogPOS.get(0)).getCatalogName());
        uccEMdmMaterialPO.setCreateLoginId(userIdLong);
        uccEMdmMaterialPO.setSource(Integer.valueOf(1));
        uccEMdmMaterialPO.setLongDesc(longDesc.toString());
        this.uccEMdmMaterialMapper.insertSelective(uccEMdmMaterialPO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPicUrlList())) {
            Map materialPicMap = reqBO.getPicUrlList().stream().collect(Collectors.toMap(UccEMdmMaterialPicBO::getMaterialPicUrl, Function.identity(), (k1, k2) -> k2));
            Collection picUrlList = materialPicMap.values();
            picUrlList.stream().forEach(each -> {
                each.setMaterialId(Long.valueOf(materialId));
                each.setMaterialPicId(Long.valueOf(this.sequenceUtil.nextId()));
            });
            List list = JSONObject.parseArray((String)JSONObject.toJSONString(picUrlList), UccEMdmMaterialPicPO.class);
            this.uccEMdmMaterialPicMapper.insertBatch(list);
        }
        for (MaterialPropBO props : reqBO.getProps()) {
            if (props == null || StringUtils.isEmpty((Object)props.getPropName()) || StringUtils.isEmpty((Object)props.getPropValue())) continue;
            UccEMdmMaterialPropDefPO uccEMdmMaterialPropDefPO = new UccEMdmMaterialPropDefPO();
            uccEMdmMaterialPropDefPO.setPropDefId(Long.valueOf(this.sequenceUtil.nextId()));
            uccEMdmMaterialPropDefPO.setCatalogId(uccEMdmMaterialPO.getCatalogId());
            uccEMdmMaterialPropDefPO.setMaterialId(uccEMdmMaterialPO.getMaterialId());
            uccEMdmMaterialPropDefPO.setMaterialCode(uccEMdmMaterialPO.getMaterialCode());
            uccEMdmMaterialPropDefPO.setPropCode(uccEMdmMaterialPropDefPO.getPropDefId().toString());
            uccEMdmMaterialPropDefPO.setPropName(props.getPropName());
            uccEMdmMaterialPropDefPO.setCreateLoginId(userIdString);
            try {
                this.uccEMdmMaterialPropDefMapper.insertSelective(uccEMdmMaterialPropDefPO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.MATERIAL_DEFINITION_ADDED.code(), RspConstantEnums.MATERIAL_DEFINITION_ADDED.message());
            }
            UccEMdmMaterialPropValuePO propValuePO = new UccEMdmMaterialPropValuePO();
            propValuePO.setPropValueId(Long.valueOf(this.sequenceUtil.nextId()));
            propValuePO.setPropDefId(uccEMdmMaterialPropDefPO.getPropDefId());
            propValuePO.setMaterialId(uccEMdmMaterialPropDefPO.getMaterialId());
            propValuePO.setMaterialCode(uccEMdmMaterialPropDefPO.getMaterialCode());
            propValuePO.setPropValue(props.getPropValue());
            propValuePO.setPropCode(uccEMdmMaterialPropDefPO.getPropCode());
            propValuePO.setPropName(uccEMdmMaterialPropDefPO.getPropName());
            propValuePO.setCatalogId(uccEMdmMaterialPropDefPO.getCatalogId());
            propValuePO.setCreateLoginId(userIdString);
            try {
                this.uccEMdmMaterialPropValueMapper.insertSelective(propValuePO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.ADDED_ITEM_DEFINITION_VALUE.code(), RspConstantEnums.ADDED_ITEM_DEFINITION_VALUE.message());
            }
        }
        if (((UccEMdmCatalogPO)catalogPOS.get(0)).getLastLevel() == 2) {
            try {
                this.uccEMdmCatalogMapper.updateCatalogLastLevel(reqBO.getCatalogId(), Integer.valueOf(1), userIdLong);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.MATERIAL_CLASSIFICATION_UPDATE.code(), RspConstantEnums.MATERIAL_CLASSIFICATION_UPDATE.message());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

