/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.MaterialGrpRequestInfo;
import com.tydic.commodity.common.busi.api.UccSnySiMaterialGrpBusiService;
import com.tydic.commodity.common.busi.bo.UccSnySiMaterialGrpBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSnySiMaterialGrpBusiRspBO;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSnySiMaterialGrpBusiServiceImpl
implements UccSnySiMaterialGrpBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSnySiMaterialGrpBusiServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private CacheClient cacheClient;
    private Sequence sequence = Sequence.getInstance();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @Override
    public UccSnySiMaterialGrpBusiRspBO syncSiMaterialGrp(UccSnySiMaterialGrpBusiReqBO reqBo) {
        UccSnySiMaterialGrpBusiRspBO rspBO = new UccSnySiMaterialGrpBusiRspBO();
        List<MaterialGrpRequestInfo> requestinfos = reqBo.getREQUESTINFO();
        ArrayList<UccEMdmCatalogPO> list = new ArrayList<UccEMdmCatalogPO>();
        ArrayList<Long> catalogIds = new ArrayList<Long>();
        ArrayList<String> parentCatalogCodes = new ArrayList<String>();
        HashMap<String, Long> catalogCodeMap = new HashMap<String, Long>();
        int rows = 0;
        if (!CollectionUtils.isEmpty(requestinfos)) {
            try {
                int i;
                for (i = 0; i < requestinfos.size(); ++i) {
                    MaterialGrpRequestInfo info = requestinfos.get(i);
                    UccEMdmCatalogPO po = new UccEMdmCatalogPO();
                    List uccEMdmCatalogPOS = null;
                    if (StringUtils.isNotBlank((CharSequence)info.getZMATKL())) {
                        po.setCatalogCode(info.getZMATKL());
                        uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.qryUccEMdmCatalog(po);
                    }
                    if (!CollectionUtils.isEmpty(uccEMdmCatalogPOS)) continue;
                    long catalogId = this.sequence.nextId();
                    po.setCatalogId(Long.valueOf(catalogId));
                    po.setCatalogName(info.getZWGBEZ());
                    po.setCatalogDesc(info.getZWGBEZ());
                    String catalogCode = po.getCatalogCode();
                    if (StringUtils.isNotBlank((CharSequence)catalogCode)) {
                        if (catalogCode.length() == 2) {
                            po.setCatalogLevel(Integer.valueOf(1));
                        } else if (catalogCode.length() == 4) {
                            po.setCatalogLevel(Integer.valueOf(2));
                        } else if (catalogCode.length() == 7) {
                            po.setCatalogLevel(Integer.valueOf(3));
                        } else if (catalogCode.length() == 10) {
                            po.setCatalogLevel(Integer.valueOf(4));
                        }
                    }
                    po.setUuid(UUID.randomUUID().toString().replace("-", ""));
                    if (StringUtils.isNotBlank((CharSequence)info.getZSTATUS())) {
                        if (Objects.equals(info.getZSTATUS(), "1")) {
                            po.setFreezeFlag(Integer.valueOf(0));
                        } else if (Objects.equals(info.getZSTATUS(), "2")) {
                            po.setFreezeFlag(Integer.valueOf(1));
                        }
                    }
                    po.setCreateTime(StringUtils.isNotBlank((CharSequence)info.getZCREATE_TIME()) ? this.sdf.parse(info.getZCREATE_TIME()) : new Date());
                    po.setUpdateTime(StringUtils.isNotBlank((CharSequence)info.getZUPDATE_TIME()) ? this.sdf.parse(info.getZUPDATE_TIME()) : null);
                    po.setIsDelete(Integer.valueOf(StringUtils.isNotBlank((CharSequence)info.getZDELETE_TAG()) ? Integer.parseInt(info.getZDELETE_TAG()) : 0));
                    po.setRemark("\u6570\u636e\u4e2d\u53f0\u7269\u6599\u5206\u7c7b\u540c\u6b65: {ZPARENT_TYPE_CODE: " + info.getZPARENT_TYPE_CODE() + ",ZCREATE_USER: " + info.getZCREATE_USER() + ",ZUPDATE_USER: " + info.getZUPDATE_USER() + "}");
                    if (po.getCatalogLevel() != null) {
                        if (Objects.equals(po.getCatalogLevel(), 4)) {
                            if (po.getCatalogId() != null) {
                                UccEMdmMaterialPO materialPO = new UccEMdmMaterialPO();
                                materialPO.setCatalogId(po.getCatalogId());
                                List materialPOS = this.uccEMdmMaterialMapper.selectMaterial(materialPO);
                                if (!CollectionUtils.isEmpty((Collection)materialPOS)) {
                                    po.setLastLevel(Integer.valueOf(1));
                                }
                            }
                            po.setLastLevel(Integer.valueOf(2));
                        } else {
                            po.setLastLevel(Integer.valueOf(0));
                        }
                    }
                    po.setViewOrder(Integer.valueOf(0));
                    list.add(po);
                    catalogIds.add(po.getCatalogId());
                    parentCatalogCodes.add(info.getZPARENT_TYPE_CODE());
                    catalogCodeMap.put(po.getCatalogCode(), po.getCatalogId());
                }
                if (!CollectionUtils.isEmpty(list)) {
                    for (i = 0; i < list.size(); ++i) {
                        UccEMdmCatalogPO po = (UccEMdmCatalogPO)list.get(i);
                        String parentCatalogCode = (String)parentCatalogCodes.get(i);
                        if (catalogCodeMap.isEmpty() || !catalogCodeMap.containsKey(parentCatalogCode)) continue;
                        po.setParentCatalogId((Long)catalogCodeMap.get(parentCatalogCode));
                    }
                    rows = this.uccEMdmCatalogMapper.insertBatch(list);
                }
            }
            catch (Exception e) {
                log.error("UccSnySiMaterialSavedataBusiService , message : {}", (Object)e.getMessage());
                throw new ZTBusinessException("8888: \u540c\u6b65\u7269\u6599\u5206\u7c7b\u6570\u636e\u5f02\u5e38");
            }
        }
        if (rows == list.size()) {
            this.cacheClient.set("catalogIds", catalogIds);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }
}

