/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.common.ability.bo.MaterialMeasureRequestInfo;
import com.tydic.commodity.common.busi.api.UccSnySiMeasureBusiService;
import com.tydic.commodity.common.busi.bo.UccSnySiMeasureBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccSnySiMeasureBusiRspBO;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSnySiMeasureBusiServiceImpl
implements UccSnySiMeasureBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccSnySiMeasureBusiServiceImpl.class);
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccSnySiMeasureBusiRspBO snySiMeasure(UccSnySiMeasureBusiReqBO reqBo) {
        UccSnySiMeasureBusiRspBO rspBO = new UccSnySiMeasureBusiRspBO();
        List requestinfos = reqBo.getREQUESTINFO();
        ArrayList<UccCommodityMeasurePo> list = new ArrayList<UccCommodityMeasurePo>();
        int rows = 0;
        if (!CollectionUtils.isEmpty(requestinfos)) {
            String jsonStr = JSONObject.toJSONString(requestinfos.stream().filter(each -> each.getMSEHL() != null).collect(Collectors.toList()));
            requestinfos = JSONObject.parseArray((String)jsonStr, MaterialMeasureRequestInfo.class);
            try {
                for (int i = 0; i < requestinfos.size(); ++i) {
                    MaterialMeasureRequestInfo info = (MaterialMeasureRequestInfo)requestinfos.get(i);
                    UccCommodityMeasurePo po = new UccCommodityMeasurePo();
                    List uccCommodityMeasurePos = null;
                    if (StringUtils.isNotBlank((CharSequence)info.getMSEHL())) {
                        po.setMeasureName(info.getMSEHL());
                        uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByMeasureName(info.getMSEHL());
                    }
                    if (!CollectionUtils.isEmpty(uccCommodityMeasurePos)) continue;
                    long measureId = this.sequence.nextId();
                    po.setMeasureId(Long.valueOf(measureId));
                    po.setMeasureType(Integer.valueOf(0));
                    po.setCreateTime(new Date());
                    po.setIsDelete(Integer.valueOf(0));
                    po.setRemark("\u6570\u636e\u4e2d\u53f0\u8ba1\u91cf\u5355\u4f4d\u540c\u6b65");
                    po.setMeasureSource(Integer.valueOf(1));
                    po.setStatus(Integer.valueOf(1));
                    po.setBriefName(info.getMSEHI());
                    list.add(po);
                }
                if (!CollectionUtils.isEmpty(list)) {
                    rows = this.uccCommodityMeasureMapper.insertBatch(list);
                }
            }
            catch (Exception e) {
                log.error("UccSnySiMeasureBusiService , message : {}", (Object)e.getMessage());
                throw new ZTBusinessException("8888: \u540c\u6b65\u8ba1\u91cf\u5355\u4f4d\u6570\u636e\u5f02\u5e38");
            }
        }
        if (rows == list.size()) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }
}

