/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccSupplierSpuAbilityService;
import com.tydic.commodity.mall.ability.bo.UccSupplierSpuAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccSupplierSpuAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccSupplierSpuBO;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccSupplierSpuAbilityService"})
public class UccSupplierSpuAbilityServiceImpl
implements UccSupplierSpuAbilityService {
    private static final Logger log = LogManager.getLogger(UccSupplierSpuAbilityServiceImpl.class);
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;

    @PostMapping(value={"getSupplierSpu"})
    public UccSupplierSpuAbilityRspBO getSupplierSpu(@RequestBody UccSupplierSpuAbilityReqBO reqBO) {
        UccSupplierSpuAbilityRspBO rspBO = new UccSupplierSpuAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getVendorIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4f9b\u5e94\u5546Id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<UccSupplierSpuBO> rows = new ArrayList<UccSupplierSpuBO>();
        for (Long vendorId : reqBO.getVendorIds()) {
            BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO, vendorId);
            String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
            String result = this.searchInfo(queryString);
            UccSupplierSpuBO uccSupplierSpuBO = null;
            if (!StringUtils.isEmpty((Object)result)) {
                uccSupplierSpuBO = this.dealSearchData(result, reqBO);
            }
            rows.add(uccSupplierSpuBO);
        }
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSupplierSpuAbilityReqBO reqBo, Long vendorId) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)3));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)vendorId));
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSupplierSpuAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)10000);
        queryJson.put("from", (Object)0);
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        return queryJson.toString();
    }

    private UccSupplierSpuBO dealSearchData(String result, UccSupplierSpuAbilityReqBO reqBo) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccMallCommodityRspBo> commodityModels = new ArrayList<UccMallCommodityRspBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccMallCommodityRspBo commodity = new UccMallCommodityRspBo();
                try {
                    commodity = (UccMallCommodityRspBo)JSON.toJavaObject((JSON)data, UccMallCommodityRspBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        UccSupplierSpuBO rows = this.copyData(commodityModels, total, 1, 10000);
        return rows;
    }

    private UccSupplierSpuBO copyData(List<UccMallCommodityRspBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccSupplierSpuBO rows = new UccSupplierSpuBO();
        if (totalNum != null) {
            int size = pageSize;
            int totalPage = 0;
            boolean add = false;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size != 0;
            total = totalNum;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                rows.setCount(totalNum.intValue());
                rows.setVendorId(commodityModels.get(0).getVendor_id());
                rows.setVendorName(commodityModels.get(0).getVendor_name());
            }
        }
        return rows;
    }
}

