/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.busi.api.UccMallMsearchEsService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallMsearchEsBO;
import com.tydic.commodity.mall.busi.bo.UccMallMsearchEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallMsearchEsRspBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallMsearchEsServiceImpl
implements UccMallMsearchEsService {
    private static final Logger log = LoggerFactory.getLogger(UccMallMsearchEsServiceImpl.class);
    @Autowired
    private MallElasticsearchUtil elasticsearchUtil;
    @Autowired
    private MallEsConfig esConfig;

    @Override
    public UccMallMsearchEsRspBO mSearch(UccMallMsearchEsReqBO reqBO) {
        UccMallMsearchEsRspBO rspBO = new UccMallMsearchEsRspBO();
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_msearch";
        String queryString = this.getQueryString(reqBO);
        if (log.isDebugEnabled()) {
            log.debug("source---->" + queryString);
        }
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            rspBO = this.dealCatalogResult(result);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private UccMallMsearchEsRspBO dealCatalogResult(String result) {
        UccMallMsearchEsRspBO rspBO = new UccMallMsearchEsRspBO();
        JSONObject resultObj = JSON.parseObject((String)result);
        ArrayList<UccMallMsearchEsBO> matchResultBos = new ArrayList<UccMallMsearchEsBO>();
        JSONArray matchArray = resultObj.getJSONArray("responses");
        int index = 1;
        for (int i = 0; i < matchArray.size(); ++i) {
            Integer total;
            UccMallMsearchEsBO uccMsearchEsBO = new UccMallMsearchEsBO();
            uccMsearchEsBO.setIndex(index);
            JSONObject singleObject = (JSONObject)matchArray.get(i);
            JSONObject hitsObj = (JSONObject)singleObject.get((Object)"hits");
            JSONObject aggregations = (JSONObject)singleObject.get((Object)"aggregations");
            if (aggregations != null) {
                total = aggregations.getJSONObject("cardinality_count").getInteger("value");
                uccMsearchEsBO.setTotal(total);
            } else {
                total = singleObject.getInteger("total");
                uccMsearchEsBO.setTotal(total);
            }
            if (uccMsearchEsBO.getTotal() != null && uccMsearchEsBO.getTotal() > 0) {
                JSONArray listObject = hitsObj.getJSONArray("hits");
                ArrayList<UccMallCommodityRspBo> rspBos = new ArrayList<UccMallCommodityRspBo>();
                listObject.stream().forEach(a -> {
                    UccMallCommodityRspBo each = (UccMallCommodityRspBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((JSONObject)a).get((Object)"_source")), UccMallCommodityRspBo.class);
                    rspBos.add(each);
                });
                uccMsearchEsBO.setRows(rspBos);
            }
            matchResultBos.add(uccMsearchEsBO);
            ++index;
        }
        rspBO.setRows(matchResultBos);
        return rspBO;
    }

    private String getQueryString(UccMallMsearchEsReqBO reqBO) {
        StringBuffer querySb = new StringBuffer();
        JSONObject header = new JSONObject();
        for (String qry : reqBO.getQuery()) {
            JSONObject queryJson = JSONObject.parseObject((String)qry);
            String body = queryJson.toJSONString();
            querySb.append(header);
            querySb.append("\n");
            querySb.append(body);
            querySb.append("\n");
        }
        return querySb.toString();
    }
}

