/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMaterialcodelowestpriceQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCommdStockBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMaterialcodelowestpriceQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMaterialcodelowestpriceQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccSpuInformationQryListAbilityBO;
import com.tydic.commodity.mall.atom.api.UccMallCurrentStockQryAtomService;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryReqBO;
import com.tydic.commodity.mall.atom.bo.UccMallCurrentStockQryRspBO;
import com.tydic.commodity.mall.atom.bo.UccMallSkuNumBO_Atom;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.mall.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.mall.po.UccEMdmMaterialPO;
import com.tydic.commodity.mall.po.UccMallEMdmCatalogPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMaterialcodelowestpriceQryAbilityService"})
public class UccMaterialcodelowestpriceQryAbilityServiceImpl
implements UccMaterialcodelowestpriceQryAbilityService {
    private static final Logger log = LogManager.getLogger(UccMaterialcodelowestpriceQryAbilityServiceImpl.class);
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private UccMallCurrentStockQryAtomService uccMallCurrentStockQryAtomService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"getlowestpriceQry"})
    public UccMaterialcodelowestpriceQryAbilityRspBO getlowestpriceQry(@RequestBody UccMaterialcodelowestpriceQryAbilityReqBO reqBO) {
        UccMaterialcodelowestpriceQryAbilityRspBO rspBO = new UccMaterialcodelowestpriceQryAbilityRspBO();
        ArrayList<Object> finalRows = new ArrayList<Object>();
        if (CollectionUtils.isEmpty((Collection)reqBO.getMaterialCodeList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getProvince() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e00\u7ea7\u5730\u5740\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getCity() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e8c\u7ea7\u5730\u5740\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getCounty() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4e09\u7ea7\u5730\u5740\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getTown() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u56db\u7ea7\u5730\u5740\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        for (String materialCode : reqBO.getMaterialCodeList()) {
            UccMallEMdmCatalogPo uccMallEMdmCatalogPo;
            UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.selectByMaterialCode(materialCode);
            if (uccEMdmMaterialPO == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u6ca1\u6709\u7269\u6599\u7f16\u7801\u4e3a" + materialCode + "\u7684\u7269\u6599\u7f16\u7801");
                return rspBO;
            }
            BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO, materialCode);
            String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
            String result = this.searchInfo(queryString);
            if (StringUtils.isEmpty((Object)result)) continue;
            List<Object> rows = this.dealSearchData(result, reqBO);
            rows.sort(Comparator.comparing(UccSpuInformationQryListAbilityBO::getSalePrice));
            BigDecimal minPrice = null;
            block1: for (UccSpuInformationQryListAbilityBO uccSpuInformationQryListAbilityBO : rows) {
                if (uccSpuInformationQryListAbilityBO.getSalePrice() == null) continue;
                if (uccSpuInformationQryListAbilityBO.getSkuSource() != 2) {
                    if (uccSpuInformationQryListAbilityBO.getStock() == null || uccSpuInformationQryListAbilityBO.getStock().equals(new BigDecimal("0"))) continue;
                    minPrice = uccSpuInformationQryListAbilityBO.getSalePrice();
                    break;
                }
                UccMallCurrentStockQryReqBO uccMallCurrentStockQryReqBO = new UccMallCurrentStockQryReqBO();
                uccMallCurrentStockQryReqBO.setProvince(reqBO.getProvince());
                uccMallCurrentStockQryReqBO.setCity(reqBO.getCity());
                uccMallCurrentStockQryReqBO.setCounty(reqBO.getCounty());
                if (reqBO.getTown() != null) {
                    uccMallCurrentStockQryReqBO.setTown(reqBO.getTown());
                } else {
                    uccMallCurrentStockQryReqBO.setTown(0L);
                }
                uccMallCurrentStockQryReqBO.setSupplierId(uccSpuInformationQryListAbilityBO.getSupplierId());
                ArrayList<UccMallSkuNumBO_Atom> stock = new ArrayList<UccMallSkuNumBO_Atom>();
                UccMallSkuNumBO_Atom skuNumBO_atom = new UccMallSkuNumBO_Atom();
                skuNumBO_atom.setSkuId(uccSpuInformationQryListAbilityBO.getExtSkuId());
                skuNumBO_atom.setNum(uccSpuInformationQryListAbilityBO.getMoq() == null ? 1L : uccSpuInformationQryListAbilityBO.getMoq().longValue());
                stock.add(skuNumBO_atom);
                uccMallCurrentStockQryReqBO.setSkuNum(stock);
                UccMallCurrentStockQryRspBO uccMallCurrentStockQryRspBO = this.uccMallCurrentStockQryAtomService.qryCommdCurrentStock(uccMallCurrentStockQryReqBO);
                if ("0000".equals(uccMallCurrentStockQryRspBO.getRespCode())) {
                    for (UccMallCommdStockBO_busi stockBO_busi : uccMallCurrentStockQryRspBO.getCommdStockInfo()) {
                        if (!stockBO_busi.getSkuId().equals(uccSpuInformationQryListAbilityBO.getExtSkuId())) continue;
                        if (stockBO_busi.getStockStateId() != 34 && stockBO_busi.getStockStateId() != 0) {
                            uccSpuInformationQryListAbilityBO.setStock(stockBO_busi.getRemainNum());
                            continue block1;
                        }
                        minPrice = uccSpuInformationQryListAbilityBO.getSalePrice();
                        uccSpuInformationQryListAbilityBO.setStock(stockBO_busi.getRemainNum());
                        continue block1;
                    }
                    continue;
                }
                throw new ZTBusinessException("\u7535\u5546\u5546\u54c1\u5e93\u5b58\u67e5\u8be2\u5931\u8d25:" + uccMallCurrentStockQryRspBO.getRespDesc());
            }
            if (minPrice == null) continue;
            BigDecimal finalMinPrice = minPrice;
            rows = rows.stream().filter(e -> finalMinPrice.equals(e.getSalePrice())).collect(Collectors.toList());
            if (uccEMdmMaterialPO.getCatalogId() == null && (uccMallEMdmCatalogPo = this.uccEMdmCatalogMapper.queryByCatId(uccEMdmMaterialPO.getCatalogId())) != null) {
                void var13_16;
                StringBuilder catalogName = new StringBuilder(uccMallEMdmCatalogPo.getCatalogName());
                while (var13_16.getParentCatalogId() != 0L) {
                    UccMallEMdmCatalogPo uccMallEMdmCatalogPo2 = this.uccEMdmCatalogMapper.queryByCatId(var13_16.getParentCatalogId());
                    catalogName.insert(0, uccMallEMdmCatalogPo2.getCatalogName() + "-");
                }
                rows.forEach(each -> each.setCatalogName(catalogName.toString()));
            }
            finalRows.addAll(rows);
        }
        rspBO.setRows(finalRows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.mallEsConfig.getIndexName() + "/" + this.mallEsConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.mallElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccMaterialcodelowestpriceQryAbilityReqBO reqBo, String materialCode) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_code", (String)materialCode));
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)3));
        ArrayList<Long> orgs = new ArrayList<Long>();
        orgs.add(reqBo.getOrgIdIn());
        String[] orgPath = reqBo.getOrgPath().split("-");
        for (int i = 0; i < orgPath.length; ++i) {
            orgs.add(Long.parseLong(orgPath[i]));
        }
        orgs.add(reqBo.getOrgId());
        BoolQueryBuilder whitelist = QueryBuilders.boolQuery();
        whitelist.should((QueryBuilder)QueryBuilders.termsQuery((String)"whitelist", orgs));
        whitelist.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"whitelist"));
        boolQueryBuilder.must((QueryBuilder)whitelist);
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccMaterialcodelowestpriceQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)10000);
        queryJson.put("from", (Object)0);
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        return queryJson.toString();
    }

    private List<UccSpuInformationQryListAbilityBO> dealSearchData(String result, UccMaterialcodelowestpriceQryAbilityReqBO reqBo) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccMallCommodityRspBo> commodityModels = new ArrayList<UccMallCommodityRspBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccMallCommodityRspBo commodity = new UccMallCommodityRspBo();
                try {
                    commodity = (UccMallCommodityRspBo)JSON.toJavaObject((JSON)data, UccMallCommodityRspBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        List<UccSpuInformationQryListAbilityBO> rows = this.copyData(commodityModels, total, 1, 10000);
        return rows;
    }

    private List<UccSpuInformationQryListAbilityBO> copyData(List<UccMallCommodityRspBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        ArrayList<UccSpuInformationQryListAbilityBO> rows = new ArrayList<UccSpuInformationQryListAbilityBO>();
        if (totalNum != null) {
            int size = pageSize;
            int totalPage = 0;
            boolean add = false;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size != 0;
            total = totalNum;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccMallCommodityRspBo cnncEsCommodityBo : commodityModels) {
                    UccSpuInformationQryListAbilityBO uccSpuInformationQryListAbilityBO = new UccSpuInformationQryListAbilityBO();
                    uccSpuInformationQryListAbilityBO.setCommodityId(Long.valueOf(cnncEsCommodityBo.getCommodity_id()));
                    uccSpuInformationQryListAbilityBO.setSkuId(Long.valueOf(cnncEsCommodityBo.getSku_id()));
                    uccSpuInformationQryListAbilityBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
                    uccSpuInformationQryListAbilityBO.setExtSkuId(cnncEsCommodityBo.getExt_sku_id());
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
                        uccSpuInformationQryListAbilityBO.setPriPicUrl(cnncEsCommodityBo.getPicture_url());
                    } else {
                        uccSpuInformationQryListAbilityBO.setPriPicUrl(cnncEsCommodityBo.getCommd_pic_url());
                    }
                    uccSpuInformationQryListAbilityBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
                    uccSpuInformationQryListAbilityBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
                    uccSpuInformationQryListAbilityBO.setUnTaxPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getUn_tax_price()));
                    uccSpuInformationQryListAbilityBO.setSkuName(cnncEsCommodityBo.getSku_name());
                    uccSpuInformationQryListAbilityBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccSpuInformationQryListAbilityBO.setSupplierShopName(cnncEsCommodityBo.getSupplier_shop_name());
                    uccSpuInformationQryListAbilityBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSpuInformationQryListAbilityBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
                    uccSpuInformationQryListAbilityBO.setSkuSource(Integer.valueOf(cnncEsCommodityBo.getSku_source()));
                    uccSpuInformationQryListAbilityBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
                    uccSpuInformationQryListAbilityBO.setCommdPicUrl(cnncEsCommodityBo.getCommd_pic_url());
                    uccSpuInformationQryListAbilityBO.setAgreementId(String.valueOf(cnncEsCommodityBo.getAgreement_id()));
                    uccSpuInformationQryListAbilityBO.setBrandName(cnncEsCommodityBo.getBrand_name());
                    uccSpuInformationQryListAbilityBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
                    uccSpuInformationQryListAbilityBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
                    uccSpuInformationQryListAbilityBO.setCatalogName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSpuInformationQryListAbilityBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
                    uccSpuInformationQryListAbilityBO.setStock(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
                    uccSpuInformationQryListAbilityBO.setMoq(cnncEsCommodityBo.getMoq());
                    rows.add(uccSpuInformationQryListAbilityBO);
                }
            }
        }
        return rows;
    }
}

