/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccSkuInformationQryListAbilityService;
import com.tydic.commodity.mall.ability.bo.UccSkuInformationQryListAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccSkuInformationQryListAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccSpuInformationQryListAbilityBO;
import com.tydic.commodity.mall.busi.api.UccMallSearchCommodityService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsRspBo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccSkuInformationQryListAbilityService"})
public class UccSkuInformationQryListAbilityServiceImpl
implements UccSkuInformationQryListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuInformationQryListAbilityServiceImpl.class);
    @Autowired
    private UccMallSearchCommodityService uccMallSearchCommodityService;

    @PostMapping(value={"getSkuInformationQryList"})
    public UccSkuInformationQryListAbilityRspBO getSkuInformationQryList(@RequestBody UccSkuInformationQryListAbilityReqBO reqBO) {
        UccSkuInformationQryListAbilityRspBO rspBO = new UccSkuInformationQryListAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("0000");
            return rspBO;
        }
        UccMallSearchEsReqBO uccMallSearchEsReqBO = new UccMallSearchEsReqBO();
        uccMallSearchEsReqBO.setSkuList(reqBO.getSkuIds());
        UccMallSearchEsRspBo uccMallSearchEsRspBo = this.uccMallSearchCommodityService.queryByMatch(uccMallSearchEsReqBO);
        List<UccSpuInformationQryListAbilityBO> result = this.convertRspBo(uccMallSearchEsRspBo.getUccMallCommodityRspBos());
        rspBO.setRows(result);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccSpuInformationQryListAbilityBO> convertRspBo(List<UccMallCommodityRspBo> commodityRspBos) {
        ArrayList<UccSpuInformationQryListAbilityBO> searchBarEsRspInfos = new ArrayList<UccSpuInformationQryListAbilityBO>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (UccMallCommodityRspBo commodityRspBo : commodityRspBos) {
                UccSpuInformationQryListAbilityBO searchBarEsRspInfo = new UccSpuInformationQryListAbilityBO();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(commodityRspBo.getSupplier_id());
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setMaterialCode(commodityRspBo.getMaterial_code());
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                searchBarEsRspInfo.setCommodityTypeName(commodityRspBo.getType_name());
                searchBarEsRspInfo.setCommodityTypeId(commodityRspBo.getType_id());
                searchBarEsRspInfo.setModel(commodityRspBo.getModel());
                searchBarEsRspInfo.setSpec(commodityRspBo.getSpec());
                searchBarEsRspInfo.setTaxRate(commodityRspBo.getTaxRate());
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        return searchBarEsRspInfos;
    }
}

