/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.tydic.commodity.mall.ability.api.UccSpuCosttypeQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccBatchShopQryMsgBo;
import com.tydic.commodity.mall.ability.bo.UccSpuCosttypeQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccSpuCosttypeQryAbilityRspBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.RelCatalogTypeFeeMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMaterialCostTypeMapper;
import com.tydic.commodity.mall.po.UccMaterialCostTypePO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccSpuCosttypeQryAbilityService"})
public class UccSpuCosttypeQryAbilityServiceImpl
implements UccSpuCosttypeQryAbilityService {
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private RelCatalogTypeFeeMapper relCatalogTypeFeeMapper;
    @Autowired
    private UccMaterialCostTypeMapper uccMaterialCostTypeMapper;

    @PostMapping(value={"getSpuCosttypeQry"})
    public UccSpuCosttypeQryAbilityRspBO getSpuCosttypeQry(@RequestBody UccSpuCosttypeQryAbilityReqBO reqBO) {
        UccSpuCosttypeQryAbilityRspBO rspBO = this.validateParam(reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        rspBO = new UccSpuCosttypeQryAbilityRspBO();
        List<UccBatchShopQryMsgBo> uccBatchShopQryMsgBos = this.uccMallSkuMapper.selectMaterialCatalogBySkuIds(reqBO.getSkus());
        List<Long> catalogIds = uccBatchShopQryMsgBos.stream().map(UccBatchShopQryMsgBo::getCatalogId).collect(Collectors.toList());
        List<UccMaterialCostTypePO> uccMaterialCostTypePOs = this.uccMaterialCostTypeMapper.getListByCatalogIds(catalogIds);
        if (CollectionUtils.isNotEmpty(uccMaterialCostTypePOs)) {
            List costs = uccMaterialCostTypePOs.stream().map(UccMaterialCostTypePO::getCost).collect(Collectors.toList());
            rspBO.setCostType(costs);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u672c\u7c7b\u578b\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        return rspBO;
    }

    private UccSpuCosttypeQryAbilityRspBO validateParam(UccSpuCosttypeQryAbilityReqBO reqBO) {
        UccSpuCosttypeQryAbilityRspBO rspBO = new UccSpuCosttypeQryAbilityRspBO();
        if (reqBO == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkus())) {
            rspBO.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBO.setRespDesc(UccMallConstantsEnums.REQUIRED_NON_EMPTY.message());
            return rspBO;
        }
        return null;
    }
}

