/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccTheshoppingcartSpuTheimportAbilityService;
import com.tydic.commodity.mall.ability.bo.UccShopCatImportBO;
import com.tydic.commodity.mall.ability.bo.UccShopartSpuTheimportBO;
import com.tydic.commodity.mall.ability.bo.UccTheshoppingcartSpuTheimportAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccTheshoppingcartSpuTheimportAbilityRspBO;
import com.tydic.commodity.mall.busi.api.UccMallMsearchEsService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallMsearchEsBO;
import com.tydic.commodity.mall.busi.bo.UccMallMsearchEsReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallMsearchEsRspBO;
import com.tydic.commodity.mall.busi.bo.UccShopCartMesParsBO;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccTheshoppingcartSpuTheimportAbilityService"})
public class UccTheshoppingcartSpuTheimportAbilityServiceImpl
implements UccTheshoppingcartSpuTheimportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccTheshoppingcartSpuTheimportAbilityServiceImpl.class);
    @Autowired
    private MallElasticsearchUtil mallElasticsearchUtil;
    @Autowired
    private MallEsConfig mallEsConfig;
    @Autowired
    private UccMallMsearchEsService uccMallMsearchEsService;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;

    @PostMapping(value={"dealshoppingcartSpuTheimport"})
    public UccTheshoppingcartSpuTheimportAbilityRspBO dealshoppingcartSpuTheimport(@RequestBody UccTheshoppingcartSpuTheimportAbilityReqBO reqBO) {
        UccTheshoppingcartSpuTheimportAbilityRspBO rspBO = new UccTheshoppingcartSpuTheimportAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getImportData())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getImportData().size() > 3000) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u6570\u636e\u91cf\u4e0d\u80fd\u8d85\u8fc7 3000\u6761");
            return rspBO;
        }
        ArrayList<Long> orgs = new ArrayList<Long>();
        orgs.add(reqBO.getOrgIdIn());
        String[] orgPath = reqBO.getOrgPath().split("-");
        for (int i = 0; i < orgPath.length; ++i) {
            orgs.add(Long.parseLong(orgPath[i]));
        }
        ArrayList<String> skuCode = new ArrayList<String>();
        ArrayList<String> materialCode = new ArrayList<String>();
        for (UccShopCatImportBO each : reqBO.getImportData()) {
            if (StringUtils.isEmpty((Object)each.getSkuCode()) && StringUtils.isEmpty((Object)each.getMaterialCode())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7269\u6599\u7f16\u7801\u548c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u540c\u6b65\u65f6\u4e3a\u7a7a");
                return rspBO;
            }
            if (!StringUtils.isEmpty((Object)each.getSkuCode())) {
                skuCode.add(each.getSkuCode());
                continue;
            }
            if (StringUtils.isEmpty((Object)each.getMaterialCode())) continue;
            materialCode.add(each.getMaterialCode());
        }
        List<String> mEsSql = this.buildmEsSql(materialCode, orgs, skuCode);
        UccMallMsearchEsReqBO uccMsearchEsDayReqBO = new UccMallMsearchEsReqBO();
        uccMsearchEsDayReqBO.setTotal(false);
        uccMsearchEsDayReqBO.setQuery(mEsSql);
        UccMallMsearchEsRspBO uccMallMsearchEsRspBO = this.uccMallMsearchEsService.mSearch(uccMsearchEsDayReqBO);
        if (!"0000".equals(uccMallMsearchEsRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)uccMallMsearchEsRspBO), (Object)rspBO);
            return rspBO;
        }
        if (CollectionUtils.isEmpty(uccMallMsearchEsRspBO.getRows())) {
            throw new ZTBusinessException("\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a");
        }
        List<UccShopCartMesParsBO> parsBOList = this.parsData(materialCode, uccMallMsearchEsRspBO.getRows());
        rspBO.setRows(new ArrayList());
        ArrayList<String> indevalCode = new ArrayList<String>();
        for (UccShopCartMesParsBO each : parsBOList) {
            UccShopartSpuTheimportBO bo;
            if (!CollectionUtils.isEmpty(each.getData())) {
                if (!StringUtils.isEmpty((Object)each.getSkuCode())) {
                    bo = new UccShopartSpuTheimportBO();
                    bo.setSkuCode(each.getSkuCode());
                    bo.setStatus(Integer.valueOf(0));
                    bo.setStock(new BigDecimal("0"));
                    bo.setRemak("\u5546\u54c1\u4e0d\u5b58\u5728");
                    bo.setCatalogue(Integer.valueOf(1));
                    rspBO.getRows().add(bo);
                    continue;
                }
                indevalCode.add(each.getMaterialCode());
                continue;
            }
            bo = this.dealdata(reqBO, each);
            rspBO.getRows().add(bo);
        }
        if (!CollectionUtils.isEmpty(indevalCode)) {
            List<String> qryCode = this.uccEMdmMaterialMapper.quryRelSkuMaterial(indevalCode);
            if (!CollectionUtils.isEmpty(qryCode)) {
                UccShopartSpuTheimportBO bo;
                for (String code : qryCode) {
                    bo = new UccShopartSpuTheimportBO();
                    bo.setMaterialCode(code);
                    bo.setStatus(Integer.valueOf(0));
                    bo.setStock(new BigDecimal("0"));
                    bo.setRemak("\u5546\u54c1\u672a\u4e0a\u67b6");
                    bo.setCatalogue(Integer.valueOf(1));
                    rspBO.getRows().add(bo);
                }
                indevalCode.removeAll(qryCode);
                if (CollectionUtils.isEmpty(indevalCode)) {
                    for (String code : indevalCode) {
                        bo = new UccShopartSpuTheimportBO();
                        bo.setMaterialCode(code);
                        bo.setStatus(Integer.valueOf(0));
                        bo.setStock(new BigDecimal("0"));
                        bo.setRemak("\u76ee\u5f55\u5916\u7269\u6599");
                        bo.setCatalogue(Integer.valueOf(0));
                        rspBO.getRows().add(bo);
                    }
                }
            } else if (CollectionUtils.isEmpty(indevalCode)) {
                for (String code : indevalCode) {
                    UccShopartSpuTheimportBO bo = new UccShopartSpuTheimportBO();
                    bo.setMaterialCode(code);
                    bo.setStatus(Integer.valueOf(0));
                    bo.setStock(new BigDecimal("0"));
                    bo.setRemak("\u76ee\u5f55\u5916\u7269\u6599");
                    bo.setCatalogue(Integer.valueOf(0));
                    rspBO.getRows().add(bo);
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    List<String> buildmEsSql(List<String> qryStr, List<Long> orgIn, List<String> skus) {
        ArrayList<String> query = new ArrayList<String>();
        if (CollectionUtils.isEmpty(qryStr) && CollectionUtils.isEmpty(skus)) {
            return query;
        }
        BoolQueryBuilder whitelist = QueryBuilders.boolQuery();
        for (Long org : orgIn) {
            whitelist.should((QueryBuilder)QueryBuilders.termsQuery((String)"whitelist", orgIn));
        }
        whitelist.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"whitelist"));
        for (String each : qryStr) {
            BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_code", (String)each));
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)3));
            extBoolQueryBuilder.must((QueryBuilder)whitelist);
            JSONObject queryJson = new JSONObject();
            queryJson.put("query", (Object)JSONObject.parseObject((String)extBoolQueryBuilder.toString().replace("\\n", "").replace(" ", "")));
            queryJson.put("size", (Object)20);
            queryJson.put("from", (Object)1);
            ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
            FieldSortBuilder sortPriceQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"sale_price").order(SortOrder.ASC);
            FieldSortBuilder sortShelfQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"on_shelve_time").order(SortOrder.DESC);
            fieldSortBuilders.add(sortPriceQuery);
            fieldSortBuilders.add(sortShelfQuery);
            queryJson.put("sort", (Object)JSONObject.parseArray((String)((Object)fieldSortBuilders).toString()));
            query.add(queryJson.toString());
        }
        if (!CollectionUtils.isEmpty(skus)) {
            BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_code", skus));
            extBoolQueryBuilder.must((QueryBuilder)whitelist);
            JSONObject queryJson = new JSONObject();
            queryJson.put("query", (Object)JSONObject.parseObject((String)extBoolQueryBuilder.toString().replace("\\n", "").replace(" ", "")));
            queryJson.put("size", (Object)skus.size());
            queryJson.put("from", (Object)1);
            query.add(queryJson.toString());
        }
        return query;
    }

    List<UccShopCartMesParsBO> parsData(List<String> materialCode, List<UccMallMsearchEsBO> rows) {
        ArrayList<UccShopCartMesParsBO> retunList;
        block7: {
            block6: {
                retunList = new ArrayList<UccShopCartMesParsBO>();
                if (CollectionUtils.isEmpty(materialCode)) break block6;
                for (int i = 0; i < materialCode.size(); ++i) {
                    UccShopCartMesParsBO parsBO = new UccShopCartMesParsBO();
                    parsBO.setMaterialCode(materialCode.get(i));
                    if (rows.get(i) != null) {
                        if (rows.get(i).getTotal() < 1) {
                            parsBO.setData(rows.get(i).getRows());
                        } else {
                            parsBO.setTotal(rows.get(i).getTotal());
                        }
                    }
                    retunList.add(parsBO);
                }
                if (rows.size() <= materialCode.size() || rows.get(rows.size() - 1).getTotal() <= 1) break block7;
                for (UccMallCommodityRspBo each : rows.get(rows.size() - 1).getRows()) {
                    UccShopCartMesParsBO parsBO = new UccShopCartMesParsBO();
                    parsBO.setSkuCode(each.getSku_code());
                    parsBO.setData(new ArrayList<UccMallCommodityRspBo>(Arrays.asList(each)));
                    retunList.add(parsBO);
                }
                break block7;
            }
            for (UccMallCommodityRspBo each : rows.get(0).getRows()) {
                UccShopCartMesParsBO parsBO = new UccShopCartMesParsBO();
                parsBO.setSkuCode(each.getSku_code());
                parsBO.setData(new ArrayList<UccMallCommodityRspBo>(Arrays.asList(each)));
                retunList.add(parsBO);
            }
        }
        return retunList;
    }

    UccShopartSpuTheimportBO dealdata(UccTheshoppingcartSpuTheimportAbilityReqBO reqBO, UccShopCartMesParsBO parsBO) {
        if (parsBO.getTotal() < 1) {
            return null;
        }
        Long id = null;
        for (UccShopCatImportBO count : reqBO.getImportData()) {
            if (!StringUtils.isEmpty((Object)parsBO.getSkuCode()) && parsBO.getSkuCode().equals(count.getSkuCode())) {
                id = count.getId();
                break;
            }
            if (StringUtils.isEmpty((Object)parsBO.getMaterialCode()) || !parsBO.getMaterialCode().equals(count.getMaterialCode())) continue;
            id = count.getId();
            break;
        }
        UccShopartSpuTheimportBO bo = null;
        for (UccMallCommodityRspBo each : parsBO.getData()) {
            if (each.getSku_source() != 2 && each.getComment_number().compareTo(new BigDecimal("0")) < 0) continue;
            bo = new UccShopartSpuTheimportBO();
            bo.setId(id);
            bo.setMaterialCode(parsBO.getMaterialCode());
            bo.setAgreementId(Long.valueOf(each.getAgreement_id()));
            bo.setBrandName(each.getBrand_name());
            bo.setCommodityId(Long.valueOf(each.getCommodity_id()));
            bo.setCommodityName(each.getCommodity_name());
            bo.setCatalogue(Integer.valueOf(1));
            if (each.getSku_status() != 3) {
                bo.setStatus(Integer.valueOf(0));
                bo.setRemak("\u5546\u54c1\u672a\u4e0a\u67b6");
            } else {
                bo.setStatus(Integer.valueOf(1));
            }
            bo.setCommodityTypeId(each.getType_id());
            bo.setCommodityTypeName(each.getType_name());
            bo.setExtSkuId(each.getExt_sku_id());
            bo.setImage(each.getPicture_url());
            bo.setPrice(MoneyUtils.haoToYuan(each.getSale_price()));
            bo.setSalePrice(MoneyUtils.haoToYuan(each.getSale_price()));
            bo.setSkuId(Long.valueOf(each.getSku_id()));
            bo.setSkuCode(each.getSku_code());
            bo.setSkuSource(Integer.valueOf(each.getSku_source()));
            bo.setSupplierShopId(each.getSupplier_shop_id());
            bo.setStock(each.getComment_number());
            break;
        }
        if (bo == null) {
            bo.setMaterialCode(parsBO.getMaterialCode());
            bo.setId(id);
            bo.setStatus(Integer.valueOf(0));
            bo.setStock(new BigDecimal("0"));
            bo.setRemak("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
            bo.setCatalogue(Integer.valueOf(1));
        }
        return bo;
    }
}

