/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.comb.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.mall.ability.bo.UccMallCommdDetailsBO_busi;
import com.tydic.commodity.mall.ability.bo.UccMallCommdDetailsQryAbilityReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallCommdDetailsQryAbilityRspBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuBo;
import com.tydic.commodity.mall.ability.bo.UccMallSkuInfoSaleNumBo;
import com.tydic.commodity.mall.ability.bo.UccMallSupplierShopBO;
import com.tydic.commodity.mall.busi.api.UccMallAgreementProduceCommdQryBusiService;
import com.tydic.commodity.mall.busi.api.UccMallCommdDetailsQryBusiService;
import com.tydic.commodity.mall.busi.bo.UccMallCommdDetailsQryBusiReqBO;
import com.tydic.commodity.mall.busi.bo.UccMallCommdDetailsQryBusiRspBo;
import com.tydic.commodity.mall.comb.api.UccMallCommdDetailQryCombService;
import com.tydic.commodity.mall.comb.bo.UccMallCommdDetailQryCombReqBO;
import com.tydic.commodity.mall.comb.bo.UccMallCommdDetailQryCombRspBO;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.constants.SkuSourceEnum;
import com.tydic.commodity.mall.constants.SkuStatusEnum;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallSaleNumMapper;
import com.tydic.commodity.mall.dao.UccMallSkuMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierMapper;
import com.tydic.commodity.mall.dao.UccMallSupplierShopMapper;
import com.tydic.commodity.mall.dao.UccMallVendorMapper;
import com.tydic.commodity.mall.po.SupplierBusiPo;
import com.tydic.commodity.mall.po.SupplierShopPo;
import com.tydic.commodity.mall.po.UccCommodityTypePo;
import com.tydic.commodity.mall.po.UccSaleNumPo;
import com.tydic.commodity.mall.po.UccSkuPo;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallCommdDetailQryCombServiceImpl
implements UccMallCommdDetailQryCombService {
    private static final Logger log = LoggerFactory.getLogger(UccMallCommdDetailQryCombServiceImpl.class);
    @Autowired
    private UccMallCommdDetailsQryBusiService uccMallCommdDetailsQryBusiService;
    @Autowired
    private UccMallAgreementProduceCommdQryBusiService uccMallAgreementProduceCommdQryBusiService;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;
    @Autowired
    private UccMallSkuMapper uccMallSkuMapper;
    @Autowired
    private UccMallSupplierMapper uccMallSupplierMapper;
    @Autowired
    private UccMallSupplierShopMapper uccMallSupplierShopMapper;
    @Autowired
    private UccMallSaleNumMapper uccMallSaleNumMapper;

    @Override
    public UccMallCommdDetailQryCombRspBO qryCommdDetail(UccMallCommdDetailQryCombReqBO reqBo) {
        UccCommodityTypePo uccCommodityTypePo;
        UccMallCommdDetailQryCombRspBO rspBo = new UccMallCommdDetailQryCombRspBO();
        if (null == reqBo || null == reqBo.getSkuId() || null == reqBo.getSupplierShopId()) {
            rspBo.setRespCode(UccMallConstantsEnums.REQUIRED_NON_EMPTY.code());
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccMallCommdDetailsBO_busi commdDetailsBOBusi = new UccMallCommdDetailsBO_busi();
        UccSkuPo uccSkuPo1 = new UccSkuPo();
        uccSkuPo1.setSkuId(reqBo.getSkuId());
        uccSkuPo1.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccSkuPo> uccSkuPos = this.uccMallSkuMapper.qerySku(uccSkuPo1);
        if (CollectionUtils.isEmpty(uccSkuPos)) {
            rspBo.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
            rspBo.setRespDesc("sku_id =" + reqBo.getSkuId() + "\u5355\u54c1\u4e0d\u5b58\u5728");
            return rspBo;
        }
        if (uccSkuPos.get(0).getSkuSource().equals(SkuSourceEnum.AGREEMENT_SOURCE.getSource())) {
            UccMallCommdDetailsQryAbilityReqBo detailsQryReqBo = new UccMallCommdDetailsQryAbilityReqBo();
            detailsQryReqBo.setSkuId(reqBo.getSkuId());
            detailsQryReqBo.setSupplierShopId(reqBo.getSupplierShopId());
            UccMallCommdDetailsQryAbilityRspBo uccMallCommdDetailsQryAbilityRspBo = this.uccMallAgreementProduceCommdQryBusiService.getAgreementProduceCommd(detailsQryReqBo);
            rspBo.setRespCode(uccMallCommdDetailsQryAbilityRspBo.getRespCode());
            rspBo.setRespDesc(uccMallCommdDetailsQryAbilityRspBo.getRespDesc());
            rspBo.setCommdDetailsInfo(uccMallCommdDetailsQryAbilityRspBo.getCommdDetailsInfo());
            rspBo.setSkuInfoSaleNumBO(uccMallCommdDetailsQryAbilityRspBo.getUccMallSkuInfoSaleNumBo());
            return rspBo;
        }
        SupplierShopPo supplierShopPo = this.uccMallSupplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.STORE_QUERY_FAILED.code());
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        UccMallSupplierShopBO uccMallSupplierShopBO = new UccMallSupplierShopBO();
        BeanUtils.copyProperties((Object)supplierShopPo, (Object)uccMallSupplierShopBO);
        commdDetailsBOBusi.setSupplierShopInfo(uccMallSupplierShopBO);
        SupplierBusiPo supplierBusiPo = this.uccMallSupplierMapper.selectSupplierById(supplierId);
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode(UccMallConstantsEnums.SUPPLIER_CODE_QUERY_FAIL.code());
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
        uccSkuPo.setSkuId(reqBo.getSkuId());
        List<UccSkuPo> uccSkuPoList = this.uccMallSkuMapper.qerySku(uccSkuPo);
        if (uccSkuPoList == null) {
            commdDetailsBOBusi.setStatus("3");
            rspBo.setCommdDetailsInfo(commdDetailsBOBusi);
            rspBo.setRespCode(UccMallConstantsEnums.SKU_INVALID.code());
            rspBo.setRespDesc("\u5355\u54c1\u5931\u6548");
            return rspBo;
        }
        if (uccSkuPoList.size() != 1) {
            rspBo.setRespDesc("\u5355\u54c1\u4e0d\u552f\u4e00");
            rspBo.setRespCode(UccMallConstantsEnums.SKU_NOT_UNIQUE.code());
            return rspBo;
        }
        String extSkuId = uccSkuPoList.get(0).getExtSkuId();
        if (StringUtils.isEmpty((CharSequence)extSkuId)) {
            rspBo.setRespDesc("\u5916\u90e8\u5355\u54c1ID\u4e3a\u7a7a");
            rspBo.setRespCode(UccMallConstantsEnums.EXTERNAL_SKU_ID_ISNULL.code());
            return rspBo;
        }
        if (!uccSkuPoList.get(0).getSkuStatus().equals(ModelRuleConstant.SKU_STATUS_ON_SHELF)) {
            commdDetailsBOBusi.setStatus("2");
        } else {
            commdDetailsBOBusi.setStatus("1");
        }
        UccMallSkuBo uccMallSkuBo = new UccMallSkuBo();
        BeanUtils.copyProperties((Object)uccSkuPoList.get(0), (Object)uccMallSkuBo);
        if (uccMallSkuBo.getSkuStatus().equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())) {
            uccMallSkuBo.setSkuStatus(Integer.valueOf(1));
        } else {
            uccMallSkuBo.setSkuStatus(Integer.valueOf(2));
        }
        if (uccMallSkuBo.getSkuSource() != null) {
            uccMallSkuBo.setSkuSourceDesc(SkuSourceEnum.getSourceDesc(uccMallSkuBo.getSkuSource()).getSourceDesc());
        }
        if (uccMallSkuBo.getCommodityTypeId() != null && (uccCommodityTypePo = this.uccMallCommodityTypeMapper.queryPoByCommodityTypeId(uccMallSkuBo.getCommodityTypeId())) != null) {
            uccMallSkuBo.setCommodityTypeName(uccCommodityTypePo.getCommodityTypeName());
        }
        commdDetailsBOBusi.setSkuInfo(uccMallSkuBo);
        commdDetailsBOBusi.setSupplierId(supplierId);
        commdDetailsBOBusi.setSupplierCode(supplierCode);
        UccMallCommdDetailsQryBusiReqBO uccMallCommdDetailsQryReqBO = new UccMallCommdDetailsQryBusiReqBO();
        uccMallCommdDetailsQryReqBO.setSkuId(reqBo.getSkuId());
        uccMallCommdDetailsQryReqBO.setSupplierShopId(reqBo.getSupplierShopId());
        UccMallCommdDetailsQryBusiRspBo uccMallCommdDetailsQryRspBO = this.uccMallCommdDetailsQryBusiService.qryCommdDetails(uccMallCommdDetailsQryReqBO);
        if (!"0000".equals(uccMallCommdDetailsQryRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)uccMallCommdDetailsQryRspBO), (Object)((Object)rspBo));
            return rspBo;
        }
        if (uccMallCommdDetailsQryRspBO.getCommdInfo() != null) {
            commdDetailsBOBusi.setCommdInfo(uccMallCommdDetailsQryRspBO.getCommdInfo());
        }
        String catalogCode = this.uccMallSkuMapper.qryMdmCodeBySkuId(reqBo.getSkuId());
        commdDetailsBOBusi.setCatalogCode(catalogCode);
        List<UccSaleNumPo> uccSaleNumPos = this.uccMallSaleNumMapper.qryBySkuIds(Lists.newArrayList((Object[])new Long[]{reqBo.getSkuId()}));
        UccMallSkuInfoSaleNumBo uccMallSkuInfoSaleNumBo = new UccMallSkuInfoSaleNumBo();
        if (CollectionUtils.isNotEmpty(uccSaleNumPos)) {
            if (uccSaleNumPos.get(0).getSoldNumber() == null) {
                uccMallSkuInfoSaleNumBo.setSoldNumber(new BigDecimal(0));
            } else {
                uccMallSkuInfoSaleNumBo.setSoldNumber(uccSaleNumPos.get(0).getSoldNumber());
            }
            if (uccSaleNumPos.get(0).getEcommerceSale() == null) {
                uccMallSkuInfoSaleNumBo.setEcommerceSale(new BigDecimal(0));
            } else {
                uccMallSkuInfoSaleNumBo.setEcommerceSale(uccSaleNumPos.get(0).getEcommerceSale());
            }
        } else {
            uccMallSkuInfoSaleNumBo.setEcommerceSale(new BigDecimal(0));
            uccMallSkuInfoSaleNumBo.setSoldNumber(new BigDecimal(0));
        }
        rspBo.setSkuInfoSaleNumBO(uccMallSkuInfoSaleNumBo);
        rspBo.setCommdDetailsInfo(commdDetailsBOBusi);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

