/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccEMdmMaterialPicMapper;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccEMdmMaterialPicPO;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.commodity.zone.ability.api.UccMaterialSpuPushAbilityService;
import com.tydic.commodity.zone.ability.bo.UccMaterialSpuPushAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccMaterialSpuPushAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccZoneWhilteRestrictBO;
import com.tydic.commodity.zone.busi.api.UccMaterialSpuPushBusiService;
import com.tydic.commodity.zone.busi.bo.UccEMdmMaterialPicBO;
import com.tydic.commodity.zone.busi.bo.UccMaterialSpuPushBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccMaterialSpuPushBusiRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.zone.ability.api.UccMaterialSpuPushAbilityService"})
public class UccMaterialSpuPushAbilityServiceImpl
implements UccMaterialSpuPushAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMaterialSpuPushAbilityServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmMaterialPicMapper uccEMdmMaterialPicMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccMaterialSpuPushBusiService uccMaterialSpuPushBusiService;
    @Autowired
    private UccOrgAgrWhiteRestrictionBusiService uccOrgAgrWhiteRestrictionBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    private Sequence sequence = Sequence.getInstance();

    @PostMapping(value={"dealMaterialSpuPush"})
    public UccMaterialSpuPushAbilityRspBO dealMaterialSpuPush(@RequestBody UccMaterialSpuPushAbilityReqBO reqBO) {
        List bos;
        UccMaterialSpuPushAbilityRspBO rspBO = new UccMaterialSpuPushAbilityRspBO();
        if (reqBO.getMaterialId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u4e0a\u67b6\u5931\u8d25\uff1a\u7269\u6599\u4fe1\u606f\u4e0d\u5b58\u5728");
            return rspBO;
        }
        UccEMdmMaterialPO uccEMdmMaterialPO = this.uccEMdmMaterialMapper.queryById(reqBO.getMaterialId());
        if (uccEMdmMaterialPO == null || uccEMdmMaterialPO.getIsDelete() != null && uccEMdmMaterialPO.getIsDelete() == 1) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u4e0a\u67b6\u5931\u8d25\uff1a\u7269\u6599\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528");
            return rspBO;
        }
        UccCommodityTypePo uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId());
        if (uccCommodityTypePo == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1\u4e0a\u67b6\u5931\u8d25\uff1a\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728");
            return rspBO;
        }
        UccMaterialSpuPushBusiReqBO busiReqBO = new UccMaterialSpuPushBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        busiReqBO.setMaterialName(uccEMdmMaterialPO.getMaterialName());
        busiReqBO.setModel(uccEMdmMaterialPO.getModel());
        busiReqBO.setSpec(uccEMdmMaterialPO.getSpec());
        busiReqBO.setLongDesc(uccEMdmMaterialPO.getLongDesc());
        if (!StringUtils.isEmpty((Object)uccCommodityTypePo.getTaxCatCode())) {
            busiReqBO.setTaxCatCode(uccCommodityTypePo.getTaxCatCode());
        }
        UccEMdmMaterialPicPO uccEMdmMaterialPicPO = new UccEMdmMaterialPicPO();
        uccEMdmMaterialPicPO.setMaterialId(reqBO.getMaterialId());
        List picPOList = this.uccEMdmMaterialPicMapper.getList(uccEMdmMaterialPicPO);
        if (!CollectionUtils.isEmpty((Collection)picPOList)) {
            bos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)picPOList), UccEMdmMaterialPicBO.class);
            List collect = bos.stream().map(UccEMdmMaterialPicBO::getMaterialPicType).collect(Collectors.toList());
            if (!collect.contains(1)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8be5\u7269\u6599\u6ca1\u6709\u4e3b\u56fe\uff0c\u65e0\u6cd5\u76f4\u63a5\u4e0a\u67b6");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u7269\u6599\u6ca1\u6709\u56fe\u7247\uff0c\u65e0\u6cd5\u76f4\u63a5\u4e0a\u67b6");
            return rspBO;
        }
        busiReqBO.setPic(bos);
        UccMaterialSpuPushBusiRspBO bsuiRsp = this.uccMaterialSpuPushBusiService.dealMaterialSpuPush(busiReqBO);
        if (!"0000".equals(bsuiRsp.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)rspBO);
            return rspBO;
        }
        try {
            this.insertWhiteList(reqBO.getWhilteRestrict(), bsuiRsp, reqBO.getAgreementId(), reqBO.getUsername());
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), "\u534f\u8bae\u660e\u7ec6\u65b0\u589e\u5e94\u7528\u8303\u56f4\u5931\u8d25\uff1a" + e.getMessage());
        }
        UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
        try {
            notifyMessageBO.setAuditStatus("0");
            notifyMessageBO.setStationCode("0");
            notifyMessageBO.setAgreementId(reqBO.getAgreementId().toString());
            notifyMessageBO.setAgreementSkuIds((List)Lists.newArrayList((Object[])new String[]{reqBO.getAgreementDetailsId().toString()}));
            notifyMessageBO.setAgreementSkuStatus("3");
            notifyMessageBO.setMemIdIn(reqBO.getUserId());
            notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
            log.info("\u521b\u5efa\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
            this.zoneGoodsAuditMQ.send(new ProxyMessage(PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TOPIC"), PropertiesUtil.getProperty((String)"UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
        }
        catch (Exception var16) {
            log.error("\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
            throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
        }
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setCommodityIds(Arrays.asList(bsuiRsp.getCommodityId()));
        syncSceneCommodityToEsReqBO.setSupplierId(bsuiRsp.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
        }
        return (UccMaterialSpuPushAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)bsuiRsp)), UccMaterialSpuPushAbilityRspBO.class);
    }

    private void insertWhiteList(List<UccZoneWhilteRestrictBO> whilteRestrict, UccMaterialSpuPushBusiRspBO bsuiRsp, Long agreementId, String userName) {
        if (!CollectionUtils.isEmpty(whilteRestrict)) {
            ArrayList<UccOrgSkuWhiteRestrictionBo> uccOrgSkuWhiteRestrictionBos = new ArrayList<UccOrgSkuWhiteRestrictionBo>();
            for (UccZoneWhilteRestrictBO each : whilteRestrict) {
                UccOrgSkuWhiteRestrictionBo uccOrgSkuWhiteRestrictionPo = new UccOrgSkuWhiteRestrictionBo();
                uccOrgSkuWhiteRestrictionPo.setAgreementId(agreementId);
                uccOrgSkuWhiteRestrictionPo.setSupplierShopId(bsuiRsp.getSupplierShopId());
                uccOrgSkuWhiteRestrictionPo.setSkuSource(3);
                uccOrgSkuWhiteRestrictionPo.setCreateOperId(userName);
                uccOrgSkuWhiteRestrictionPo.setId(Long.valueOf(this.sequence.nextId()));
                uccOrgSkuWhiteRestrictionPo.setOrgId(each.getOrgId());
                uccOrgSkuWhiteRestrictionPo.setOrgTreePath(each.getOrgId().toString());
                uccOrgSkuWhiteRestrictionPo.setOrgName(each.getOrgName());
                uccOrgSkuWhiteRestrictionPo.setStatus(1);
                uccOrgSkuWhiteRestrictionPo.setCommodityId(bsuiRsp.getCommodityId());
                uccOrgSkuWhiteRestrictionBos.add(uccOrgSkuWhiteRestrictionPo);
            }
            if (CollectionUtils.isEmpty(uccOrgSkuWhiteRestrictionBos)) {
                return;
            }
            UccOrgSkuWhiteRestrictionBusiReqBo uccOrgSkuWhiteRestrictionBusiReqBo = new UccOrgSkuWhiteRestrictionBusiReqBo();
            uccOrgSkuWhiteRestrictionBusiReqBo.setWhites(uccOrgSkuWhiteRestrictionBos);
            try {
                this.uccOrgAgrWhiteRestrictionBusiService.dealWhite(uccOrgSkuWhiteRestrictionBusiReqBo);
            }
            catch (Exception e) {
                log.error("\u534f\u8bae\u53d1\u5e03\u8303\u56f4\u65b0\u589e\u5931\u8d25" + e.getMessage());
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
    }
}

