/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.busi.impl;

import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSpuEditRecordMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSpuEditRecordPO;
import com.tydic.commodity.zone.busi.api.UccAgrItemBatchBackonApplyBusiService;
import com.tydic.commodity.zone.busi.bo.UccAgrItemBatchBackonApplyBusiReqBO;
import com.tydic.commodity.zone.busi.bo.UccAgrItemBatchBackonApplyBusiRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccAgrItemBatchBackonApplyBusiServiceImpl
implements UccAgrItemBatchBackonApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrItemBatchBackonApplyBusiServiceImpl.class);
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccUpAndOffApplyBusiService uccUpAndOffApplyBusiService;
    @Value(value="${ARG_ON_SHELF_PROCESS}")
    private String process;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSpuEditRecordMapper uccSpuEditRecordMapper;

    @Override
    public UccAgrItemBatchBackonApplyBusiRspBO dealAgrBackonApply(UccAgrItemBatchBackonApplyBusiReqBO reqBO) {
        UccAgrItemBatchBackonApplyBusiRspBO rspBO = new UccAgrItemBatchBackonApplyBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u6062\u590d\u4e0a\u67b6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSameLevel() == 1) {
            List skus = reqBO.getBatchSkuList().stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            ArrayList<Integer> skuStatus = new ArrayList<Integer>();
            skuStatus.add(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
            skuStatus.add(SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus());
            ArrayList<Integer> excludeApprovalStatus = new ArrayList<Integer>();
            excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO);
            excludeApprovalStatus.add(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO);
            List sameLevelOtrherSku = this.uccSkuMapper.queySameLevelOtrherSku(skus, null, skuStatus, null, excludeApprovalStatus);
            if (!CollectionUtils.isEmpty((Collection)sameLevelOtrherSku)) {
                sameLevelOtrherSku.stream().forEach(a -> {
                    UccBatchSkuBO bo = new UccBatchSkuBO();
                    bo.setSkuId(a.getSkuId());
                    bo.setSupplierShopId(a.getSupplierShopId());
                    reqBO.getBatchSkuList().add(bo);
                });
            }
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        ArrayList<UccBatchSkuBO> SkuNoJudgeList = new ArrayList<UccBatchSkuBO>();
        for (Long supplierShopId : mapSku.keySet()) {
            for (UccBatchSkuBO each : mapSku.get(supplierShopId)) {
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setSkuId(each.getSkuId());
                uccSkuPo.setSupplierShopId(supplierShopId);
                List uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
                UccSpuEditRecordPO uccSpuEditRecordPO = new UccSpuEditRecordPO();
                uccSpuEditRecordPO.setCommodityId(((UccSkuPo)uccSkuPos.get(0)).getCommodityId());
                List list = this.uccSpuEditRecordMapper.getList(uccSpuEditRecordPO);
                if (!CollectionUtils.isEmpty((Collection)list)) continue;
                reqBO.getBatchSkuList().removeIf(e -> e.getSkuId().equals(each.getSkuId()));
                SkuNoJudgeList.add(each);
            }
        }
        UccStatusChangeUpdateSpuAtomReqBO changeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        Map<Long, List<UccBatchSkuBO>> mapSkuNoJudge = SkuNoJudgeList.stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        ArrayList<UccSkuUpdateStatusBO> skuStatusList = new ArrayList<UccSkuUpdateStatusBO>();
        for (Long aLong : mapSkuNoJudge.keySet()) {
            UccSkuUpdateStatusBO bo = null;
            Long supplierShopId = aLong;
            for (UccBatchSkuBO each : mapSkuNoJudge.get(supplierShopId)) {
                bo = new UccSkuUpdateStatusBO();
                bo.setSkuId(each.getSkuId());
                bo.setSkuStatus(ModelRuleConstant.SKU_STATUS_ON_SHELF);
                skuStatusList.add(bo);
            }
            changeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
            changeUpdateSpuAtomReqBO.setSkuStatusList(skuStatusList);
            UccStatusChangeUpdateSpuAtomRspBO changeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(changeUpdateSpuAtomReqBO);
            if ("0000".equals(changeUpdateSpuAtomRspBO.getRespCode())) continue;
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), changeUpdateSpuAtomRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            UccUpAndOffApplyAbilityReqBO busiReqBO = new UccUpAndOffApplyAbilityReqBO();
            UccUpAndOffApplyAbilityRspBO busiRspBO = new UccUpAndOffApplyAbilityRspBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)busiReqBO);
            busiReqBO.setBatchSkuList(reqBO.getBatchSkuList());
            busiReqBO.setFormUrl("http://10.10.178.47");
            busiReqBO.setAuditAdvice("\u5355\u54c1\u6062\u590d\u4e0a\u67b6\u5ba1\u6279");
            ExtReqBO extReqBO = new ExtReqBO();
            extReqBO.setProcess(this.process);
            extReqBO.setAuditObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_RECOVER);
            ArrayList<Integer> oldStatus = new ArrayList<Integer>();
            oldStatus.add(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
            oldStatus.add(SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus());
            extReqBO.setStatusOld(oldStatus);
            extReqBO.setStatusApproval(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
            extReqBO.setStatusApply(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus());
            extReqBO.setAuditStatusApply(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.toString());
            extReqBO.setRemark("\u6062\u590d\u4e0a\u67b6");
            try {
                busiRspBO = this.uccUpAndOffApplyBusiService.dealUpAndOffApply(busiReqBO, extReqBO);
                BeanUtils.copyProperties((Object)busiRspBO, (Object)((Object)rspBO));
            }
            catch (Exception e2) {
                throw new BusinessException("8888", e2.getMessage());
            }
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new BusinessException("8888", rspBO.getRespDesc());
            }
        }
        return rspBO;
    }
}

