/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.log;

import com.alibaba.fastjson.JSON;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import com.tydic.umc.security.log.BussinessLog;
import com.tydic.umc.security.log.HttpKit;
import com.tydic.umc.security.log.IPUtils;
import com.tydic.umc.security.log.LogManager;
import com.tydic.umc.security.log.LogObjectHolder;
import com.tydic.umc.security.log.LogTaskFactory;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAop {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Pointcut(value="@annotation(com.tydic.umc.security.log.BussinessLog)")
    public void cutService() {
    }

    @Around(value="cutService()")
    public Object recordSysLog(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        try {
            this.handle(point);
        }
        catch (Exception var4) {
            this.log.error("\u65e5\u5fd7\u8bb0\u5f55\u51fa\u9519!", (Throwable)var4);
        }
        return result;
    }

    private void handle(ProceedingJoinPoint point) throws Exception {
        Signature sig = point.getSignature();
        if (!(sig instanceof MethodSignature)) {
            throw new IllegalArgumentException("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
        }
        MethodSignature msig = (MethodSignature)sig;
        Object target = point.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        UmcMemInfoBO user = UmcMemInfoHelper.getCurrentUser();
        if (null != user) {
            String className = point.getTarget().getClass().getName();
            Object[] params = point.getArgs();
            BussinessLog annotation = currentMethod.getAnnotation(BussinessLog.class);
            String bussinessName = annotation.operat();
            String module = annotation.module();
            HttpServletRequest request = HttpKit.getRequest();
            String ip = IPUtils.getIp(request);
            StringBuilder sb = new StringBuilder();
            Object[] var16 = params;
            int var17 = params.length;
            for (int var18 = 0; var18 < var17; ++var18) {
                Object param = var16[var18];
                sb.append(param);
                sb.append(" & ");
            }
            String preData = null;
            Object obj = LogObjectHolder.me().get();
            if (obj != null) {
                preData = JSON.toJSONString((Object)obj);
            }
            LogManager.me().executeLog(LogTaskFactory.bussinessLog(user.getUserId(), user.getTenantId(), module, bussinessName, className, ip, preData, sb.toString()));
        }
    }
}

