/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.CommonConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.OrderPropertiesUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HSNHttpHeader;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.busibase.busi.api.PebExecuteOrderRemindAbilityService;
import com.tydic.uoc.busibase.busi.bo.PebExecuteOrderRemindAbilityServiceReqBO;
import com.tydic.uoc.busibase.busi.bo.PebExecuteOrderRemindAbilityServiceRspBO;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="uocExecuteOrderRemindAbilityService")
public class PebExecuteOrderRemindAbilityServiceImpl
implements PebExecuteOrderRemindAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebExecuteOrderRemindAbilityServiceImpl.class);

    @Override
    public PebExecuteOrderRemindAbilityServiceRspBO executeRemind(PebExecuteOrderRemindAbilityServiceReqBO reqBO) {
        PebExecuteOrderRemindAbilityServiceRspBO retBo = new PebExecuteOrderRemindAbilityServiceRspBO();
        String returnStr = null;
        if (CommonConstant.ORDER_SEND_EMIL.equals(reqBO.getSendType())) {
            String url = OrderPropertiesUtil.getProperty((String)"NOTIFY_SEND_MAIL_URL");
            String requestJsonStr = this.initEmailReqStr(reqBO);
            returnStr = PebExecuteOrderRemindAbilityServiceImpl.dealPost(requestJsonStr, url, reqBO.getToken());
        }
        this.dealReturnStr(retBo, returnStr);
        return retBo;
    }

    private static String dealPost(String requestJsonStr, String url, String token) {
        String returnString;
        try {
            HttpRetBean httpRetBean;
            Header[] headers = HSNHttpHeader.getRequestHeaders((String)"json");
            if (!StringUtils.isEmpty((CharSequence)token)) {
                Header[] header = new Header[headers.length + 1];
                System.arraycopy(headers, 0, header, 0, headers.length);
                header[headers.length] = new BasicHeader("auth-token", token);
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(url), (Header[])header, (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            } else {
                httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(url), (Header[])headers, (byte[])requestJsonStr.getBytes(StandardCharsets.UTF_8), (String)"UTF-8", (Boolean)false);
            }
            if (httpRetBean.getStatus() != 200) {
                throw new RuntimeException("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + url + "]");
            }
            returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new UocProBusinessException("102001", "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("102000", "\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
        }
        return returnString;
    }

    private void dealReturnStr(PebExecuteOrderRemindAbilityServiceRspBO retBo, String returnString) {
        JSONObject jsonObjectReturn;
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)returnString);
        }
        if (!"0".equals((jsonObjectReturn = JSONObject.parseObject((String)returnString)).getString("code"))) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u63a5\u53e3\u5931\u8d25!" + jsonObjectReturn.getString("message"));
            return;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u8ba2\u5355\u63d0\u9192\u6210\u529f!");
    }

    private String initEmailReqStr(PebExecuteOrderRemindAbilityServiceReqBO reqBO) {
        JSONObject reqJsonObject = new JSONObject();
        reqJsonObject.put("content", (Object)reqBO.getContent());
        reqJsonObject.put("to", (Object)reqBO.getEmail());
        reqJsonObject.put("subject", (Object)reqBO.getSubject());
        if (log.isDebugEnabled()) {
            log.debug("\u901a\u77e5\u4e2d\u5fc3EMS\u901a\u77e5\u5165\u53c2\u4e3a\uff1a{}", (Object)reqJsonObject.toJSONString());
        }
        return reqJsonObject.toJSONString();
    }

    private String initSmsReqStr(PebExecuteOrderRemindAbilityServiceReqBO reqBO) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("mobile", (Object)reqBO.getMobile());
        reqJson.put("content", (Object)reqBO.getContent());
        if (log.isDebugEnabled()) {
            log.debug("\u77ed\u4fe1\u901a\u77e5\u5185\u5bb9\uff1a{}", (Object)reqJson.toJSONString());
        }
        return reqJson.toJSONString();
    }
}

