/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.BgyApprovalprocessListAbilityService;
import com.tydic.uoc.common.ability.bo.BgyApprovalprocessListReq;
import com.tydic.uoc.common.ability.bo.BgyApprovalprocessListRsp;
import com.tydic.uoc.common.ability.bo.BgyGetProcessInfo;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.PageInfo;
import com.tydic.uoc.common.atom.api.BgyGetProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyGetProcessAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyGetProcessAtomRspBO;
import com.tydic.uoc.common.atom.bo.BgyProcessInfoBO;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyApprovalprocessListAbilityService"})
public class BgyApprovalprocessListAbilityServiceImpl
implements BgyApprovalprocessListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyApprovalprocessListAbilityServiceImpl.class);
    @Value(value="${k2_request_order_source_id}")
    private String sourceId;
    @Autowired
    private BgyGetProcessAtomService bgyGetProcessAtomService;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;

    @PostMapping(value={"getBgyApprovalprocessList"})
    public BgyApprovalprocessListRsp getBgyApprovalprocessList(@RequestBody BgyApprovalprocessListReq reqBo) {
        this.validataArg(reqBo);
        BgyApprovalprocessListRsp rsp = new BgyApprovalprocessListRsp();
        rsp.setRespCode("0000");
        rsp.setRespDesc("0000");
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestId())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8bf7\u8d2d\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long requestId = reqBo.getRequestId();
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        if (uocOrdRequestPo == null) {
            throw new UocProBusinessException("100002", "\u8bf7\u8d2d\u5355id\u9519\u8bef");
        }
        Date requestTime = uocOrdRequestPo.getRequestTime();
        BgyGetProcessAtomReqBO atomReqBO = this.buildParam(reqBo, uocOrdRequestPo);
        Integer ktFlag = atomReqBO.getRequestInfo().getKtFlag();
        if (ktFlag != null && ktFlag.equals(UocConstant.CHECK_FLAG.YES)) {
            BgyGetProcessAtomRspBO atomRspBO = this.bgyGetProcessAtomService.getProcess(atomReqBO);
            if (!"A0001".equalsIgnoreCase(atomRspBO.getReturnCode())) {
                throw new UocProBusinessException("101030", "k2\u67e5\u770b\u5ba1\u6279\u60c5\u51b5\u5931\u8d25\uff1a!" + atomRspBO.getReturnMsg());
            }
            List<BgyGetProcessInfo> processInfoList = atomRspBO.getProcessInfoList();
            this.resoveData(processInfoList, requestTime);
            rsp.setProcessInfoList(processInfoList);
        }
        rsp.setKtFormUrl(atomReqBO.getRequestInfo().getKtFormUrl());
        return rsp;
    }

    private void resoveData(List<BgyGetProcessInfo> processInfoList, Date requestTime) {
        int i;
        Collections.reverse(processInfoList);
        HashMap<Integer, BgyGetProcessInfo> tempMap = new HashMap<Integer, BgyGetProcessInfo>();
        for (i = 0; i < processInfoList.size(); ++i) {
            tempMap.put(i, processInfoList.get(i));
        }
        for (i = 0; i < processInfoList.size(); ++i) {
            BgyGetProcessInfo bgyGetProcessInfo = processInfoList.get(i);
            bgyGetProcessInfo.setApproveComment(bgyGetProcessInfo.getActionName());
            if (i == 0) {
                bgyGetProcessInfo.setReceiveTime(requestTime);
            } else {
                bgyGetProcessInfo.setReceiveTime(((BgyGetProcessInfo)tempMap.get(i - 1)).getApproveTime());
            }
            bgyGetProcessInfo.setProcessTime(bgyGetProcessInfo.getApproveTime());
        }
    }

    private void validataArg(BgyApprovalprocessListReq reqBO) {
        if (reqBO == null) {
            throw new UocProBusinessException("100001", "\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private BgyGetProcessAtomReqBO buildParam(BgyApprovalprocessListReq req, UocOrdRequestPo uocOrdRequestPo) {
        BgyGetProcessAtomReqBO atomReqBO = new BgyGetProcessAtomReqBO();
        BgyProcessInfoBO requestInfo = new BgyProcessInfoBO();
        requestInfo.setK2Id(uocOrdRequestPo.getKtId());
        requestInfo.setSourceId(this.sourceId);
        requestInfo.setKtFlag(uocOrdRequestPo.getKtFlag());
        requestInfo.setKtFormUrl(uocOrdRequestPo.getKtFormUrl());
        PageInfo queryInfo = new PageInfo();
        queryInfo.setCurrentPage(String.valueOf(req.getPageNo()));
        queryInfo.setPageSize(String.valueOf(req.getPageSize()));
        atomReqBO.setRequestInfo(requestInfo);
        atomReqBO.setQueryInfo(queryInfo);
        atomReqBO.setEsbInfo(new EsbInfoBO());
        return atomReqBO;
    }
}

