/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.umc.general.ability.api.UmcMasterDutyOrgListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcMasterDutyOrgListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMasterDutyOrgListQryAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcOrgBO;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.bo.BgyDataKanbanQueryDaoReqBo;
import com.tydic.uoc.bo.BgyDataKanbanQueryDaoRspBo;
import com.tydic.uoc.common.ability.api.BgyBuyerDataKanbanQueryAbilityService;
import com.tydic.uoc.common.ability.bo.BgyBuyerDataKanbanQueryAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyBuyerDataKanbanQueryAbilityRspBo;
import com.tydic.uoc.common.ability.bo.BgyBuyerDataKanbanQueryCategoryTopBo;
import com.tydic.uoc.common.ability.bo.BgyBuyerDataKanbanQueryCommodityTopBo;
import com.tydic.uoc.common.ability.bo.BgyBuyerDataKanbanQuerySupplierTopBo;
import com.tydic.uoc.dao.OrderMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyBuyerDataKanbanQueryAbilityService"})
public class BgyBuyerDataKanbanQueryAbilityServiceImpl
implements BgyBuyerDataKanbanQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyBuyerDataKanbanQueryAbilityServiceImpl.class);
    @Autowired
    private UmcMasterDutyOrgListQryAbilityService umcMasterDutyOrgListQryAbilityService;
    @Autowired
    private OrderMapper orderMapper;

    @PostMapping(value={"queryBuyerDataKanban"})
    public BgyBuyerDataKanbanQueryAbilityRspBo queryBuyerDataKanban(@RequestBody BgyBuyerDataKanbanQueryAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        UmcMasterDutyOrgListQryAbilityReqBO umcMasterDutyOrgListQryAbilityReqBO = (UmcMasterDutyOrgListQryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UmcMasterDutyOrgListQryAbilityReqBO.class);
        umcMasterDutyOrgListQryAbilityReqBO.setOperType(Integer.valueOf(2));
        umcMasterDutyOrgListQryAbilityReqBO.setCompanyIdExt(reqBo.getCompanyId());
        log.info("\u67e5\u8be2\u4f1a\u5458 \u4e3b\u8d23\u8303\u56f4\u67e5\u8be2API \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcMasterDutyOrgListQryAbilityReqBO));
        UmcMasterDutyOrgListQryAbilityRspBO umcMasterDutyOrgListQryAbilityRspBO = this.umcMasterDutyOrgListQryAbilityService.qryMasterDutyOrgList(umcMasterDutyOrgListQryAbilityReqBO);
        log.info("\u67e5\u8be2\u4f1a\u5458 \u4e3b\u8d23\u8303\u56f4\u67e5\u8be2API \u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcMasterDutyOrgListQryAbilityRspBO));
        if (!"0000".equals(umcMasterDutyOrgListQryAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException(umcMasterDutyOrgListQryAbilityRspBO.getRespCode(), umcMasterDutyOrgListQryAbilityRspBO.getRespDesc());
        }
        BgyBuyerDataKanbanQueryAbilityRspBo rspBo = new BgyBuyerDataKanbanQueryAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)umcMasterDutyOrgListQryAbilityRspBO.getRows())) {
            this.dealNullRspBo(rspBo, true);
        } else {
            UmcOrgBO umcOrgBO = (UmcOrgBO)umcMasterDutyOrgListQryAbilityRspBO.getRows().get(0);
            if (null != umcOrgBO.getOrgId() && 0L != umcOrgBO.getOrgId()) {
                this.normalProcessRspBo(reqBo, rspBo, umcOrgBO);
            } else {
                this.dealNullRspBo(rspBo, true);
            }
        }
        return rspBo;
    }

    private void normalProcessRspBo(BgyBuyerDataKanbanQueryAbilityReqBo reqBo, BgyBuyerDataKanbanQueryAbilityRspBo rspBo, UmcOrgBO umcOrgBO) {
        BgyDataKanbanQueryDaoReqBo dataKanbanQueryDaoReqBo = new BgyDataKanbanQueryDaoReqBo();
        dataKanbanQueryDaoReqBo.setCreateTimeEff(reqBo.getCreateTimeEff());
        dataKanbanQueryDaoReqBo.setCreateTimeExp(reqBo.getCreateTimeExp());
        dataKanbanQueryDaoReqBo.setSaleState(UocConstant.SALE_ORDER_STATUS.RECEIVED);
        dataKanbanQueryDaoReqBo.setOrgId(String.valueOf(umcOrgBO.getOrgId()));
        BgyDataKanbanQueryDaoRspBo dataKanbanQueryDaoRspBo = this.orderMapper.queryTotalBuyerDataKanban(dataKanbanQueryDaoReqBo);
        if (dataKanbanQueryDaoRspBo.getPurchaseOrderQuantity() > 0) {
            rspBo.setTotalSaleMoney(UocMoneyUtil.long2BigDecimal((Long)dataKanbanQueryDaoRspBo.getTotalSaleFee()));
            rspBo.setOrderQuantity(dataKanbanQueryDaoRspBo.getPurchaseOrderQuantity());
            rspBo.setGoodsQuantity(dataKanbanQueryDaoRspBo.getPurchaseGoodsQuantity());
            dataKanbanQueryDaoReqBo.setTopQuantity(reqBo.getTopQuantity());
            List commodityTopDataKanbanQueryDaoRspBos = this.orderMapper.queryCommodityTopBuyerDataKanban(dataKanbanQueryDaoReqBo);
            if (!CollectionUtils.isEmpty((Collection)commodityTopDataKanbanQueryDaoRspBos)) {
                BgyBuyerDataKanbanQueryCommodityTopBo commodityTopBo;
                ArrayList<BgyBuyerDataKanbanQueryCommodityTopBo> commodityTopBoList = new ArrayList<BgyBuyerDataKanbanQueryCommodityTopBo>(commodityTopDataKanbanQueryDaoRspBos.size());
                BigDecimal commoditySaleMoney = BigDecimal.ZERO;
                for (BgyDataKanbanQueryDaoRspBo commodityTopDataKanbanQueryDaoRspBo : commodityTopDataKanbanQueryDaoRspBos) {
                    commodityTopBo = new BgyBuyerDataKanbanQueryCommodityTopBo();
                    commodityTopBo.setSaleMoney(UocMoneyUtil.long2BigDecimal((Long)commodityTopDataKanbanQueryDaoRspBo.getTotalSaleFee()));
                    commodityTopBo.setSkuName(commodityTopDataKanbanQueryDaoRspBo.getSkuName());
                    commodityTopBoList.add(commodityTopBo);
                    commoditySaleMoney = commoditySaleMoney.add(commodityTopBo.getSaleMoney());
                }
                BigDecimal commodityTopPercentRemaining = new BigDecimal(100);
                for (int i = 0; i < commodityTopBoList.size(); ++i) {
                    commodityTopBo = (BgyBuyerDataKanbanQueryCommodityTopBo)commodityTopBoList.get(i);
                    if (i == commodityTopBoList.size() - 1) {
                        commodityTopBo.setPercentage(commodityTopPercentRemaining);
                        continue;
                    }
                    commodityTopBo.setPercentage(commodityTopBo.getSaleMoney().multiply(new BigDecimal(100)).divide(commoditySaleMoney, 2, RoundingMode.HALF_UP));
                    commodityTopPercentRemaining = commodityTopPercentRemaining.subtract(commodityTopBo.getPercentage());
                }
                rspBo.setCommodityTopBoList(commodityTopBoList);
                rspBo.setCommoditySaleMoney(commoditySaleMoney);
                this.dealCategoryTopInfo(rspBo, dataKanbanQueryDaoReqBo);
                this.dealSupplierTopInfo(rspBo, dataKanbanQueryDaoReqBo);
            } else {
                this.dealNullRspBo(rspBo, false);
            }
        } else {
            this.dealNullRspBo(rspBo, true);
        }
    }

    private void dealSupplierTopInfo(BgyBuyerDataKanbanQueryAbilityRspBo rspBo, BgyDataKanbanQueryDaoReqBo dataKanbanQueryDaoReqBo) {
        BgyBuyerDataKanbanQuerySupplierTopBo supplierTopBo;
        List supplierTopDataKanbanQueryDaoRspBos = this.orderMapper.querySupplierTopBuyerDataKanban(dataKanbanQueryDaoReqBo);
        ArrayList<BgyBuyerDataKanbanQuerySupplierTopBo> supplierTopBoList = new ArrayList<BgyBuyerDataKanbanQuerySupplierTopBo>(supplierTopDataKanbanQueryDaoRspBos.size());
        BigDecimal supplierSaleMoney = BigDecimal.ZERO;
        for (BgyDataKanbanQueryDaoRspBo supplierTopDataKanbanQueryDaoRspBo : supplierTopDataKanbanQueryDaoRspBos) {
            supplierTopBo = new BgyBuyerDataKanbanQuerySupplierTopBo();
            supplierTopBo.setSaleMoney(UocMoneyUtil.long2BigDecimal((Long)supplierTopDataKanbanQueryDaoRspBo.getTotalSaleFee()));
            supplierTopBo.setSupName(supplierTopDataKanbanQueryDaoRspBo.getSupName());
            supplierTopBoList.add(supplierTopBo);
            supplierSaleMoney = supplierSaleMoney.add(supplierTopBo.getSaleMoney());
        }
        BigDecimal supplierTopPercentRemaining = new BigDecimal(100);
        for (int i = 0; i < supplierTopBoList.size(); ++i) {
            supplierTopBo = (BgyBuyerDataKanbanQuerySupplierTopBo)supplierTopBoList.get(i);
            if (i == supplierTopBoList.size() - 1) {
                supplierTopBo.setPercentage(supplierTopPercentRemaining);
                continue;
            }
            supplierTopBo.setPercentage(supplierTopBo.getSaleMoney().multiply(new BigDecimal(100)).divide(supplierSaleMoney, 2, RoundingMode.HALF_UP));
            supplierTopPercentRemaining = supplierTopPercentRemaining.subtract(supplierTopBo.getPercentage());
        }
        rspBo.setSupplierSaleMoney(supplierSaleMoney);
        rspBo.setSupplierTopBoList(supplierTopBoList);
    }

    private void dealCategoryTopInfo(BgyBuyerDataKanbanQueryAbilityRspBo rspBo, BgyDataKanbanQueryDaoReqBo dataKanbanQueryDaoReqBo) {
        BgyBuyerDataKanbanQueryCategoryTopBo categoryTopBo;
        List categoryTopDataKanbanQueryDaoRspBos = this.orderMapper.queryCategoryTopBuyerDataKanban(dataKanbanQueryDaoReqBo);
        ArrayList<BgyBuyerDataKanbanQueryCategoryTopBo> categoryTopBoList = new ArrayList<BgyBuyerDataKanbanQueryCategoryTopBo>(categoryTopDataKanbanQueryDaoRspBos.size());
        BigDecimal categorySaleMoney = BigDecimal.ZERO;
        for (BgyDataKanbanQueryDaoRspBo categoryTopDataKanbanQueryDaoRspBo : categoryTopDataKanbanQueryDaoRspBos) {
            categoryTopBo = new BgyBuyerDataKanbanQueryCategoryTopBo();
            categoryTopBo.setSaleMoney(UocMoneyUtil.long2BigDecimal((Long)categoryTopDataKanbanQueryDaoRspBo.getTotalSaleFee()));
            categoryTopBo.setL3catalogName(categoryTopDataKanbanQueryDaoRspBo.getL3catalogName());
            categoryTopBoList.add(categoryTopBo);
            categorySaleMoney = categorySaleMoney.add(categoryTopBo.getSaleMoney());
        }
        BigDecimal categoryTopPercentRemaining = new BigDecimal(100);
        for (int i = 0; i < categoryTopBoList.size(); ++i) {
            categoryTopBo = (BgyBuyerDataKanbanQueryCategoryTopBo)categoryTopBoList.get(i);
            if (i == categoryTopBoList.size() - 1) {
                categoryTopBo.setPercentage(categoryTopPercentRemaining);
                continue;
            }
            categoryTopBo.setPercentage(categoryTopBo.getSaleMoney().multiply(new BigDecimal(100)).divide(categorySaleMoney, 2, RoundingMode.HALF_UP));
            categoryTopPercentRemaining = categoryTopPercentRemaining.subtract(categoryTopBo.getPercentage());
        }
        rspBo.setCategorySaleMoney(categorySaleMoney);
        rspBo.setCategoryTopBoList(categoryTopBoList);
    }

    private void dealNullRspBo(BgyBuyerDataKanbanQueryAbilityRspBo rspBo, Boolean isSetTotalInfo) {
        if (isSetTotalInfo.booleanValue()) {
            rspBo.setTotalSaleMoney(BigDecimal.ZERO);
            rspBo.setOrderQuantity(Integer.valueOf(0));
            rspBo.setGoodsQuantity(BigDecimal.ZERO);
        }
        rspBo.setCommoditySaleMoney(BigDecimal.ZERO);
        rspBo.setCategorySaleMoney(BigDecimal.ZERO);
        rspBo.setSupplierSaleMoney(BigDecimal.ZERO);
        rspBo.setCommodityTopBoList(new ArrayList(0));
        rspBo.setCategoryTopBoList(new ArrayList(0));
        rspBo.setSupplierTopBoList(new ArrayList(0));
    }

    private void validateArgs(BgyBuyerDataKanbanQueryAbilityReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getCreateTimeEff())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0b\u5355\u65f6\u95f4 \u5f00\u59cb[createTimeEff]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getCreateTimeExp())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0b\u5355\u65f6\u95f4 \u7ed3\u675f[createTimeExp]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getTopQuantity() || reqBo.getTopQuantity() <= 0) {
            reqBo.setTopQuantity(Integer.valueOf(10));
        }
    }
}

