/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.annotation.OrderFlowLog;
import com.tydic.uoc.common.ability.annotation.OrderLogRecord;
import com.tydic.uoc.common.ability.api.BgyCatalogInCancelOrderAbilityService;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelOrderAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.PebExtCancelBusiService;
import com.tydic.uoc.common.busi.api.UocPebOrderCancelBusiService;
import com.tydic.uoc.common.busi.api.UocProCancelBusiService;
import com.tydic.uoc.common.comb.api.UocPebOrderCancelCombService;
import com.tydic.uoc.dao.OrdSaleMapper;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyCatalogInCancelOrderAbilityService"})
public class BgyCatalogInCancelOrderAbilityServiceImpl
implements BgyCatalogInCancelOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogInCancelOrderAbilityServiceImpl.class);
    @Autowired
    private PebExtCancelBusiService pebExtCancelBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocPebOrderCancelCombService uocPebOrderCancelCombService;
    @Autowired
    private UocPebOrderCancelBusiService uocPebOrderCancelBusiService;
    @Autowired
    private UocProCancelBusiService uocProCancelBusiService;

    @OrderLogRecord(description="\u53d6\u6d88")
    @OrderFlowLog(operationLink="\u53d6\u6d88\u8ba2\u5355", description="\u53d6\u6d88\u8ba2\u5355")
    @PostMapping(value={"cancelOrder"})
    public BgyCatalogInCancelOrderAbilityRspBo cancelOrder(@RequestBody BgyCatalogInCancelOrderAbilityReqBo reqBo) {
        BgyCatalogInCancelOrderAbilityRspBo rspBo = (BgyCatalogInCancelOrderAbilityRspBo)UocProRspBoUtil.success(BgyCatalogInCancelOrderAbilityRspBo.class);
        this.validateArg(reqBo);
        BgyCatalogInCancelOrderAbilityRspBo busiRspBo = this.uocProCancelBusiService.dealOrderCancelled(reqBo);
        if (!"0000".equals(busiRspBo.getRespCode())) {
            throw new UocProBusinessException(busiRspBo.getRespCode(), busiRspBo.getRespDesc());
        }
        UocPebOrdIdxSyncReqBO syncReqBO = new UocPebOrdIdxSyncReqBO();
        syncReqBO.setObjId(reqBo.getSaleVoucherId());
        syncReqBO.setOrderId(reqBo.getOrderId());
        syncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)syncReqBO)));
        return rspBo;
    }

    private void validateArg(BgyCatalogInCancelOrderAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCancelReason())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[cancelReason]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleVoucherId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getName())) {
            reqBo.setUsername(reqBo.getName());
        }
    }
}

