/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProJsonUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.BgyCatalogInCancelRequestOrderAbilityService;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelRequestOrderAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCancelRequestOrderAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.BgyCancelRequestOrderAtomService;
import com.tydic.uoc.common.atom.api.UocQrySupIdAtomService;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.busi.api.BgyCatalogInCancelRequestOrderBusiService;
import com.tydic.uoc.common.busi.bo.BgyCatalogInCancelRequestOrderBusiOrderRspBo;
import com.tydic.uoc.common.busi.bo.BgyCatalogInCancelRequestOrderBusiReqBo;
import com.tydic.uoc.common.busi.bo.BgyCatalogInCancelRequestOrderBusiRspBo;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyCatalogInCancelRequestOrderAbilityService"})
public class BgyCatalogInCancelRequestOrderAbilityServiceImpl
implements BgyCatalogInCancelRequestOrderAbilityService {
    @Autowired
    private BgyCatalogInCancelRequestOrderBusiService bgyCatalogInCancelRequestOrderBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Autowired
    private BgyCancelRequestOrderAtomService bgyCancelRequestOrderAtomService;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${USER_REQUEST_CANCEL_REASON:\u7528\u6237\u53d6\u6d88}")
    private String userCancelReason;
    @Value(value="${isKtCancel:false}")
    private boolean isKtCancel;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Autowired
    private UocQrySupIdAtomService uocQrySupIdAtomService;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    @PostMapping(value={"cancelRequestOrder"})
    public BgyCatalogInCancelRequestOrderAbilityRspBo cancelRequestOrder(@RequestBody BgyCatalogInCancelRequestOrderAbilityReqBo reqBo) {
        BgyCatalogInCancelRequestOrderAbilityRspBo rspBo = (BgyCatalogInCancelRequestOrderAbilityRspBo)UocProRspBoUtil.success(BgyCatalogInCancelRequestOrderAbilityRspBo.class);
        BgyCatalogInCancelRequestOrderBusiReqBo cancelReqBo = (BgyCatalogInCancelRequestOrderBusiReqBo)UocProJsonUtil.convertReq((Object)reqBo, BgyCatalogInCancelRequestOrderBusiReqBo.class);
        Long requestId = reqBo.getRequestId();
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        cancelReqBo.setCancelOperName(reqBo.getUsername());
        cancelReqBo.setCancelOperId(reqBo.getUserId());
        cancelReqBo.setCancelDesc(this.userCancelReason);
        BgyCatalogInCancelRequestOrderBusiRspBo bgyCatalogInCancelRequestOrderBusiRspBo = this.bgyCatalogInCancelRequestOrderBusiService.cancelRequestOrder(cancelReqBo);
        if (!"0000".equals(bgyCatalogInCancelRequestOrderBusiRspBo.getRespCode())) {
            throw new UocProBusinessException(bgyCatalogInCancelRequestOrderBusiRspBo.getRespCode(), bgyCatalogInCancelRequestOrderBusiRspBo.getRespDesc());
        }
        UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
        combReqBO.setOrderId(reqBo.getRequestId());
        combReqBO.setObjId(reqBo.getRequestId());
        combReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
        combReqBO.setIsStatistics(Boolean.valueOf(false));
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        if (UocConstant.REQUEST_ORDER_STATUS.CONFIRM.equals(uocOrdRequestPo.getRequestStatus())) {
            this.sendMessageBeforeSureTo(uocOrdRequestPo);
        }
        List<BgyCatalogInCancelRequestOrderBusiOrderRspBo> orderList = bgyCatalogInCancelRequestOrderBusiRspBo.getOrderList();
        for (BgyCatalogInCancelRequestOrderBusiOrderRspBo bgyCatalogInCancelRequestOrderBusiOrderRspBo : orderList) {
            UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            uocPebOrdIdxSyncReqBO.setOrderId(bgyCatalogInCancelRequestOrderBusiOrderRspBo.getOrderId());
            uocPebOrdIdxSyncReqBO.setObjId(bgyCatalogInCancelRequestOrderBusiOrderRspBo.getSaleVoucherId());
            uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            uocPebOrdIdxSyncReqBO.setIsStatistics(Boolean.valueOf(false));
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
        }
        return rspBo;
    }

    private void sendMessageBeforeSureTo(UocOrdRequestPo requestPo) {
        OrdSalePO qrySalePo = new OrdSalePO();
        qrySalePo.setRequestId(requestPo.getRequestId());
        List list = this.ordSaleMapper.getList(qrySalePo);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return;
        }
        for (OrdSalePO ordSalePO : list) {
            OrdStakeholderPO stakeholderPO = this.ordStakeholderMapper.getModelById(ordSalePO.getOrderId().longValue());
            UocQrySupIdAtomReqBo uocQrySupIdAtomReqBo = new UocQrySupIdAtomReqBo();
            uocQrySupIdAtomReqBo.setSupNo(stakeholderPO.getSupNo());
            UocQrySupIdAtomRspBo uocQrySupIdAtomRspBo = this.uocQrySupIdAtomService.getSupIds(uocQrySupIdAtomReqBo);
            List<Long> supUserIds = uocQrySupIdAtomRspBo.getSupUserIds();
            for (Long supUserId : supUserIds) {
                UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
                sendMessageBo.setSendId(supUserId);
                sendMessageBo.setRecId(supUserId);
                sendMessageBo.setNoticeNodeCode("20024");
                sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9500\u552e\u8ba2\u5355\u7f16\u53f7#}", ordSalePO.getSaleVoucherNo()));
                this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
            }
        }
        Long requestId = requestPo.getRequestId();
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
        UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
        sendMessageBo.setSendId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setRecId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setNoticeNodeCode("20009");
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9500\u552e\u8ba2\u5355\u7f16\u53f7#}", list.stream().map(OrdSalePO::getSaleVoucherNo).collect(Collectors.joining(","))));
        sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u8bf7\u8d2d\u5355\u53f7#}", uocOrdRequestPo.getRequestCode()));
        this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
    }
}

