/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.BgyCatalogInSupplierConfirmAbilityService;
import com.tydic.uoc.common.ability.api.UocGeneralCirculationAbilityService;
import com.tydic.uoc.common.ability.bo.BgyCatalogInSupplierConfirmAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInSupplierConfirmAbilityRspBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInSupplierConfirmReqOrderBo;
import com.tydic.uoc.common.ability.bo.UocGeneralCirculationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocGeneralCirculationAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyCatalogInSupplierConfirmAbilityService"})
public class BgyCatalogInSupplierConfirmAbilityServiceImpl
implements BgyCatalogInSupplierConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogInSupplierConfirmAbilityServiceImpl.class);
    @Autowired
    private UocGeneralCirculationAbilityService uocGeneralCirculationAbilityService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;

    @PostMapping(value={"orderConfirm"})
    public BgyCatalogInSupplierConfirmAbilityRspBo orderConfirm(@RequestBody BgyCatalogInSupplierConfirmAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        BgyCatalogInSupplierConfirmAbilityRspBo rspBo = (BgyCatalogInSupplierConfirmAbilityRspBo)UocProRspBoUtil.success(BgyCatalogInSupplierConfirmAbilityRspBo.class);
        List orderList = reqBo.getOrderList();
        for (BgyCatalogInSupplierConfirmReqOrderBo bgyCatalogInSupplierConfirmReqOrderBo : orderList) {
            UocGeneralCirculationAbilityReqBO uocGeneralCirculationAbilityReqBO = new UocGeneralCirculationAbilityReqBO();
            uocGeneralCirculationAbilityReqBO.setOrderId(bgyCatalogInSupplierConfirmReqOrderBo.getOrderId());
            uocGeneralCirculationAbilityReqBO.setObjId(bgyCatalogInSupplierConfirmReqOrderBo.getSaleOrderId());
            uocGeneralCirculationAbilityReqBO.setObjType(UocConstant.ORDER_TYPE.SALE_ORDER);
            uocGeneralCirculationAbilityReqBO.setActionCode("ACTPEB001");
            UocGeneralCirculationAbilityRspBO uocGeneralCirculationAbilityRspBO = this.uocGeneralCirculationAbilityService.dealGeneralCirculation(uocGeneralCirculationAbilityReqBO);
            if (!"0000".equals(uocGeneralCirculationAbilityRspBO.getRespCode())) {
                throw new UocProBusinessException(uocGeneralCirculationAbilityRspBO.getRespCode(), uocGeneralCirculationAbilityRspBO.getRespDesc());
            }
            this.senMessage(bgyCatalogInSupplierConfirmReqOrderBo);
            UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
            combReqBO.setOrderId(bgyCatalogInSupplierConfirmReqOrderBo.getRequestId());
            combReqBO.setObjId(bgyCatalogInSupplierConfirmReqOrderBo.getRequestId());
            combReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
            combReqBO.setIsStatistics(Boolean.valueOf(false));
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        }
        return rspBo;
    }

    private void validateArg(BgyCatalogInSupplierConfirmAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List orderList = reqBo.getOrderList();
        if (ObjectUtil.isEmpty((Object)orderList)) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (BgyCatalogInSupplierConfirmReqOrderBo bgyCatalogInSupplierConfirmReqOrderBo : orderList) {
            this.validateOrder(bgyCatalogInSupplierConfirmReqOrderBo);
        }
    }

    private void validateOrder(BgyCatalogInSupplierConfirmReqOrderBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void senMessage(BgyCatalogInSupplierConfirmReqOrderBo reqOrderBo) {
        Long saleOrderId = reqOrderBo.getSaleOrderId();
        OrdSalePO qryAllSalePo = new OrdSalePO();
        qryAllSalePo.setSaleVoucherId(saleOrderId);
        OrdSalePO modelBy = this.ordSaleMapper.getModelBy(qryAllSalePo);
        UocOrdRequestPo uocOrdRequestPo = this.uocOrdRequestMapper.selectByPrimaryKey(reqOrderBo.getRequestId());
        UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
        sendMessageBo.setSendId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setRecId(Long.valueOf(uocOrdRequestPo.getRequestManId()));
        sendMessageBo.setNoticeNodeCode("20008");
        ArrayList<UocSendMessageAtomReqDataBo> params = new ArrayList<UocSendMessageAtomReqDataBo>();
        params.add(new UocSendMessageAtomReqDataBo("{#\u8bf7\u8d2d\u5355\u7f16\u53f7#}", modelBy.getRequestCode()));
        params.add(new UocSendMessageAtomReqDataBo("{#\u9500\u552e\u8ba2\u5355\u7f16\u53f7#}", modelBy.getSaleVoucherNo()));
        sendMessageBo.setReplaceDataList(params);
        this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
    }
}

