/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.BgyCatalogInUpdateOrderResultQryAbilityService;
import com.tydic.uoc.common.ability.bo.BgyCatalogInCreateRequestOrderResultQryAbilityOrderDataBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInUpdateOrderResultQryAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogInUpdateOrderResultQryAbilityRspBo;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyCatalogInUpdateOrderResultQryAbilityService"})
public class BgyCatalogInUpdateOrderResultQryAbilityServiceImpl
implements BgyCatalogInUpdateOrderResultQryAbilityService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;

    @PostMapping(value={"qryUpdateOrderResult"})
    public BgyCatalogInUpdateOrderResultQryAbilityRspBo qryUpdateOrderResult(@RequestBody BgyCatalogInUpdateOrderResultQryAbilityReqBo reqBo) {
        this.val(reqBo);
        OrdSalePO qryRequestOrdPo = new OrdSalePO();
        qryRequestOrdPo.setOrderIdList(reqBo.getOrderIds());
        List requestOrderList = this.ordSaleMapper.getList(qryRequestOrdPo);
        BgyCatalogInUpdateOrderResultQryAbilityRspBo rspBo = (BgyCatalogInUpdateOrderResultQryAbilityRspBo)UocProRspBoUtil.success(BgyCatalogInUpdateOrderResultQryAbilityRspBo.class);
        if (ObjectUtil.isEmpty((Object)requestOrderList)) {
            throw new UocProBusinessException("104049", "\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u8ba2\u5355");
        }
        boolean processResult = true;
        boolean allSuccess = true;
        ArrayList<Long> failedList = new ArrayList<Long>();
        ArrayList<Long> allOrderList = new ArrayList<Long>();
        for (OrdSalePO ordSalePo : requestOrderList) {
            String orderSource = ordSalePo.getOrderSource();
            Integer saleState = ordSalePo.getSaleState();
            allOrderList.add(ordSalePo.getOrderId());
            if (UocConstant.SALE_ORDER_STATUS.CREATE.equals(saleState)) {
                processResult = false;
            }
            BgyCatalogInCreateRequestOrderResultQryAbilityOrderDataBo uocData = new BgyCatalogInCreateRequestOrderResultQryAbilityOrderDataBo();
            uocData.setSaleVoucherNo(ordSalePo.getSaleVoucherNo());
            uocData.setSaleVoucherId(ordSalePo.getSaleVoucherId());
            uocData.setOrderId(ordSalePo.getOrderId());
            if ("1".equals(orderSource)) {
                if (UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER.equals(saleState)) {
                    rspBo.getSuccessList().add(uocData);
                    continue;
                }
                failedList.add(ordSalePo.getOrderId());
                allSuccess = false;
                rspBo.getFailedList().add(uocData);
                continue;
            }
            if ("2".equals(orderSource)) {
                if (UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(saleState)) {
                    rspBo.getSuccessList().add(uocData);
                    continue;
                }
                if (UocConstant.SALE_ORDER_STATUS.PRE_ORDER_FAILED.equals(saleState)) {
                    failedList.add(ordSalePo.getOrderId());
                    allSuccess = false;
                    uocData.setMsg("\u9884\u8ba2\u5355\u5931\u8d25");
                    rspBo.getFailedList().add(uocData);
                    continue;
                }
                failedList.add(ordSalePo.getOrderId());
                allSuccess = false;
                rspBo.getFailedList().add(uocData);
                continue;
            }
            throw new UocProBusinessException("104049", "\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u6765\u6e90[" + orderSource + "]");
        }
        rspBo.setAllSuccess(Boolean.valueOf(allSuccess));
        rspBo.setProcessResult(Boolean.valueOf(processResult));
        this.qryFailedReasonAndPush2DataBo(rspBo, failedList);
        this.qrySupplierInfoAndPush2DataBo(rspBo, allOrderList);
        rspBo.setTotalMoney(UocMoneyUtil.long2BigDecimal((Long)requestOrderList.stream().mapToLong(OrdSalePO::getSaleFee).sum()));
        return rspBo;
    }

    private void qryFailedReasonAndPush2DataBo(BgyCatalogInUpdateOrderResultQryAbilityRspBo rspBo, List<Long> failedList) {
        OrderPO qryFailedPo = new OrderPO();
        qryFailedPo.setOrderIdList(failedList);
        List qryFailedList = this.orderMapper.getList(qryFailedPo);
        Map<Long, OrderPO> failedMap = qryFailedList.stream().collect(Collectors.toMap(OrderPO::getOrderId, item -> item));
        for (BgyCatalogInCreateRequestOrderResultQryAbilityOrderDataBo dataBo : rspBo.getFailedList()) {
            String cancelReason = failedMap.get(dataBo.getOrderId()).getCancelReason();
            if (!ObjectUtil.isEmpty((Object)dataBo.getMsg())) continue;
            dataBo.setMsg(ObjectUtil.isEmpty((Object)cancelReason) ? "\u8ba2\u5355\u5904\u7406\u4e2d" : cancelReason);
        }
    }

    public void qrySupplierInfoAndPush2DataBo(BgyCatalogInUpdateOrderResultQryAbilityRspBo rspBo, List<Long> allOrderList) {
        OrdStakeholderPO qryOrdStakePo = new OrdStakeholderPO();
        qryOrdStakePo.setOrderIdList(allOrderList);
        List allOrderSatkeList = this.ordStakeholderMapper.getList(qryOrdStakePo);
        Map<Long, OrdStakeholderPO> allOrderStakeholderMap = allOrderSatkeList.stream().collect(Collectors.toMap(OrdStakeholderPO::getOrderId, item -> item));
        List failedRspList = rspBo.getFailedList();
        List successRspList = rspBo.getSuccessList();
        for (BgyCatalogInCreateRequestOrderResultQryAbilityOrderDataBo dataBo : failedRspList) {
            dataBo.setSupplierId(allOrderStakeholderMap.get(dataBo.getOrderId()).getSupNo());
            dataBo.setSupplierName(allOrderStakeholderMap.get(dataBo.getOrderId()).getSupName());
        }
        for (BgyCatalogInCreateRequestOrderResultQryAbilityOrderDataBo dataBo : successRspList) {
            dataBo.setSupplierId(allOrderStakeholderMap.get(dataBo.getOrderId()).getSupNo());
            dataBo.setSupplierName(allOrderStakeholderMap.get(dataBo.getOrderId()).getSupName());
        }
    }

    private void val(BgyCatalogInUpdateOrderResultQryAbilityReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getOrderIds())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

