/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProJsonUtil;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.BgyCatalogOutNoCostModRequestOrderAbilityService;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCostCreateOrderCompanyInfoCostReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCreateOrderCompanyInfoNoCostReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCreateRequestOrderAddressReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutCreateRequestOrderNoCostItemReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutNoCostCreateOrderAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutNoCostCreateOrderCommodityTypeInfoReqBo;
import com.tydic.uoc.common.ability.bo.BgyCatalogOutNoCostModRequestOrderRspBO;
import com.tydic.uoc.common.comb.api.BgyCatalogOutModRequestCostCombService;
import com.tydic.uoc.common.comb.bo.BgyCatalogOutModRequestCostAbilityRspBO;
import com.tydic.uoc.common.comb.bo.BgyCatalogOutModRequestCostCombReqBO;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombCommodityTypeReqBo;
import com.tydic.uoc.common.comb.bo.UocProCreateOrderCombOrderItemReqBo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyCatalogOutNoCostModRequestOrderAbilityService"})
public class BgyCatalogOutNoCostModRequestOrderAbilityServiceImpl
implements BgyCatalogOutNoCostModRequestOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyCatalogOutNoCostModRequestOrderAbilityServiceImpl.class);
    @Autowired
    BgyCatalogOutModRequestCostCombService bgyCatalogOutModRequestCostCombService;

    @PostMapping(value={"modRequest"})
    public BgyCatalogOutNoCostModRequestOrderRspBO modRequest(@RequestBody BgyCatalogOutNoCostCreateOrderAbilityReqBo reqBo) {
        BgyCatalogOutNoCostModRequestOrderRspBO rspBo = (BgyCatalogOutNoCostModRequestOrderRspBO)UocProRspBoUtil.success(BgyCatalogOutNoCostModRequestOrderRspBO.class);
        this.validateArg(reqBo);
        BgyCatalogOutModRequestCostAbilityRspBO combRspBO = this.bgyCatalogOutModRequestCostCombService.modRequest(this.createCombReqBo(reqBo));
        if (!"0000".equals(combRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", combRspBO.getRespDesc());
        }
        BeanUtils.copyProperties((Object)((Object)combRspBO), (Object)rspBo);
        rspBo.setRequestCode(reqBo.getRequestCode());
        return rspBo;
    }

    private BgyCatalogOutModRequestCostCombReqBO createCombReqBo(BgyCatalogOutNoCostCreateOrderAbilityReqBo reqBo) {
        BgyCatalogOutModRequestCostCombReqBO createOrderComReq = new BgyCatalogOutModRequestCostCombReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)createOrderComReq));
        createOrderComReq.setRequestType(UocConstant.RequestType.CATALOG_OUT);
        createOrderComReq.setOrderItemList(new ArrayList<UocProCreateOrderCombOrderItemReqBo>());
        List commodityTypeList = reqBo.getCommodityTypeList();
        for (BgyCatalogOutNoCostCreateOrderCommodityTypeInfoReqBo commType : commodityTypeList) {
            List ordItemList = commType.getOrdItemList();
            UocProCreateOrderCombCommodityTypeReqBo combCommTypeBo = new UocProCreateOrderCombCommodityTypeReqBo();
            BeanUtils.copyProperties((Object)commType, (Object)combCommTypeBo);
            for (BgyCatalogOutCreateRequestOrderNoCostItemReqBo reqOrderItem : ordItemList) {
                UocProCreateOrderCombOrderItemReqBo comReqItem = new UocProCreateOrderCombOrderItemReqBo();
                BeanUtils.copyProperties((Object)reqOrderItem, (Object)comReqItem);
                comReqItem.setCommodityTypeReqBo(combCommTypeBo);
                createOrderComReq.getOrderItemList().add(comReqItem);
            }
        }
        createOrderComReq.setAddressBo((BgyCatalogOutCreateRequestOrderAddressReqBo)UocProJsonUtil.convertReq((Object)reqBo.getAddressBo(), BgyCatalogOutCreateRequestOrderAddressReqBo.class));
        createOrderComReq.setCompanyInfoBo((BgyCatalogOutCostCreateOrderCompanyInfoCostReqBo)UocProJsonUtil.convertReq((Object)reqBo.getCompanyInfoBo(), BgyCatalogOutCostCreateOrderCompanyInfoCostReqBo.class));
        createOrderComReq.getCompanyInfoBo().setProjectId(createOrderComReq.getAddressBo().getStockOrgId());
        createOrderComReq.getCompanyInfoBo().setProjectName(createOrderComReq.getAddressBo().getStockOrgName());
        return createOrderComReq;
    }

    private void validateArg(BgyCatalogOutNoCostCreateOrderAbilityReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new UocProBusinessException("104001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCostType())) {
            throw new UocProBusinessException("104001", "\u6210\u672c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getGiveTime())) {
            throw new UocProBusinessException("104001", "\u9001\u8fbe\u65f6\u95f4\u8981\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestReason())) {
            throw new UocProBusinessException("104001", "\u8bf7\u8d2d\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUsername())) {
            throw new UocProBusinessException("104001", "\u8bf7\u8d2d\u4eba\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPurchaserAccount())) {
            throw new UocProBusinessException("104001", "\u8d26\u5957\u7f16\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestId())) {
            throw new UocProBusinessException("104001", "\u8bf7\u8d2d\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestCode())) {
            throw new UocProBusinessException("104001", "\u8bf7\u8d2d\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validateAddressBo(reqBo.getAddressBo());
        this.validateCompany(reqBo.getCompanyInfoBo());
        for (BgyCatalogOutNoCostCreateOrderCommodityTypeInfoReqBo requestOrderCommodityTypeNoCostReqBo : reqBo.getCommodityTypeList()) {
            this.validateCommodity(requestOrderCommodityTypeNoCostReqBo);
        }
    }

    private void validateCommodity(BgyCatalogOutNoCostCreateOrderCommodityTypeInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getComTypeId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[comTypeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getComTypeName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[comTypeName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getYsResourceName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[ysResourceName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getYsResourceId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[ysResourceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List ordItemList = reqBo.getOrdItemList();
        this.validateOrderItem(ordItemList);
    }

    private void validateOrderItem(List<BgyCatalogOutCreateRequestOrderNoCostItemReqBo> ordItemList) {
        if (ObjectUtil.isEmpty(ordItemList)) {
            throw new UocProBusinessException("104047", "ordItemList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (BgyCatalogOutCreateRequestOrderNoCostItemReqBo reqBo : ordItemList) {
            if (ObjectUtil.isEmpty((Object)reqBo)) {
                throw new UocProBusinessException("104047", "\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getPurchaseCount())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[purchaseCount]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getFeeTypeName())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[feeTypeName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getFeeTypeId())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[feeTypeId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getRequestUsedName())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestUsedName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getRequestUsedId())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestUsedId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getYsResourceId())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[ysResourceId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getYsResourceName())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[ysResourceName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getPurchaseTypeId())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[purchaseTypeId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)reqBo.getPurchaseTypeName())) continue;
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[purchaseTypeName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateCompany(BgyCatalogOutCreateOrderCompanyInfoNoCostReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestDeptId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestDeptId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getStockOrgId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[stockOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getStockOrgName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[stockOrgName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getNeedStockName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[needStockName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getHsCompanyName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[hsCompanyName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestDeptName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestDeptName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getNeedStockId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[needStockId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getHsCompanyId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[hsCompanyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFundCenterId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[fundCenterId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFundCenterName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[fundCenterName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProfitName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[profitName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProfitId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[profitId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getYsDeptId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[ysDeptId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getYsDeptName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[ysDeptName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestOrgId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestOrgName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestOrgName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAccountId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[accountId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAccountName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[accountName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getHsDeptCode())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[hsDeptCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getHsDeptName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[hsDeptName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateAddressBo(BgyCatalogOutCreateRequestOrderAddressReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestAddressId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestAddressId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUmcContactId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[umcContactId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverCityId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverCityId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverProvinceId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverProvinceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getHsCompanyId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[hsCompanyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverCountyId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverCountyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverAddress())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverAddress]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverCityName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverCityName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getStockOrgId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[stockOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getStockOrgName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[stockOrgName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getHsCompanyName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[hsCompanyName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverProvinceName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverProvinceName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverEmail())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverEmail]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getReceiverCountyName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[receiverCountyName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCertName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[certName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrgType())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orgType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

