/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.BipConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.BgyExpediteAbilityService;
import com.tydic.uoc.common.ability.bo.BgyExpediteAbilityReqBO;
import com.tydic.uoc.common.ability.bo.BgyExpediteAbilityRspBO;
import com.tydic.uoc.common.atom.api.UocQrySupIdAtomService;
import com.tydic.uoc.common.atom.bo.BgySetTodoAsDoneAtomArgReqBo;
import com.tydic.uoc.common.atom.bo.BgySetTodoAsDoneAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.busi.api.BgyExpediteBusiService;
import com.tydic.uoc.common.busi.bo.BgyExpediteBusiReqBO;
import com.tydic.uoc.common.busi.bo.BgyExpediteBusiRspBO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyExpediteAbilityService"})
public class BgyExpediteAbilityServiceImpl
implements BgyExpediteAbilityService {
    @Autowired
    private BgyExpediteBusiService bgyExpediteBusiService;
    @Autowired
    private UocQrySupIdAtomService uocQrySupIdAtomService;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Value(value="${UOC_PRO_BIP_DONE_NOTICE_ORDER_TOPIC:UOC_PRO_BIP_DONE_NOTICE_ORDER_TOPIC}")
    private String noticeBipDoneTopic;
    @Value(value="${UOC_PRO_BIP_DONE_NOTICE_ORDER_TAG:UOC_PRO_BIP_DONE_NOTICE_ORDER_TOPIC}")
    private String noticeBipDoneTag;
    @Resource(name="uocProBipDoneNoticeMsgProvider")
    private ProxyMessageProducer uocProBipDoneNoticeMsgProvider;
    @Value(value="${BIP_APP_NAME:BU00149}")
    private String appName;

    @PostMapping(value={"sendMessage"})
    public BgyExpediteAbilityRspBO sendMessage(@RequestBody BgyExpediteAbilityReqBO reqBO) {
        this.validate(reqBO);
        BgyExpediteBusiReqBO busiReqBO = (BgyExpediteBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), BgyExpediteBusiReqBO.class);
        BgyExpediteBusiRspBO busiRspBO = this.bgyExpediteBusiService.getInfo(busiReqBO);
        this.sendMessage(busiRspBO, reqBO);
        this.sendBipDoneMessage(busiRspBO);
        BgyExpediteAbilityRspBO rspBO = new BgyExpediteAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendBipDoneMessage(BgyExpediteBusiRspBO busiRspBO) {
        BgySetTodoAsDoneAtomReqBo sendInfoBo = new BgySetTodoAsDoneAtomReqBo();
        BgySetTodoAsDoneAtomArgReqBo arg0 = new BgySetTodoAsDoneAtomArgReqBo();
        arg0.setModelId(BipConstant.EXPEDITE_PREFIX + busiRspBO.getPurVouncherNo());
        arg0.setAppName(this.appName);
        arg0.setType(BipConstant.APPROVAL_TYPE);
        arg0.setOptType(BipConstant.SET_DONE_OPT_TYPE);
        sendInfoBo.setArg0(arg0);
        this.uocProBipDoneNoticeMsgProvider.send(new ProxyMessage(this.noticeBipDoneTopic, this.noticeBipDoneTag, JSON.toJSONString((Object)sendInfoBo)));
    }

    private void sendMessage(BgyExpediteBusiRspBO busiRspBO, BgyExpediteAbilityReqBO reqBO) {
        UocQrySupIdAtomReqBo uocQrySupIdAtomReqBo = new UocQrySupIdAtomReqBo();
        uocQrySupIdAtomReqBo.setSupNo(busiRspBO.getSupNo());
        UocQrySupIdAtomRspBo supIds = this.uocQrySupIdAtomService.getSupIds(uocQrySupIdAtomReqBo);
        List<Long> supUserIds = supIds.getSupUserIds();
        for (Long supUserId : supUserIds) {
            UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
            sendMessageBo.setSendId(reqBO.getUserId());
            sendMessageBo.setRecId(supUserId);
            sendMessageBo.setNoticeNodeCode("20013");
            sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9700\u65b9\u5355\u4f4d#}", busiRspBO.getPurName()));
            sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7#}", busiRspBO.getPurVouncherNo()));
            this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
        }
    }

    private void validate(BgyExpediteAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getSaleVoucherId())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355ID\u3010saleVoucherId\u3011\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderId())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUserId())) {
            throw new UocProBusinessException("100001", "\u767b\u5f55\u5b58\u5728\u95ee\u9898\uff0c\u672a\u6210\u529f\u83b7\u53d6userId");
        }
    }
}

