/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.common.ability.api.BgyGetStorageFromNCAbilityService;
import com.tydic.uoc.common.ability.bo.BgyGetStorageFromNCAbilityReqBO;
import com.tydic.uoc.common.ability.bo.BgyGetStorageFromNCAbilityRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.BgyGetStorageFromNCBusiService;
import com.tydic.uoc.common.busi.bo.BgyGetStorageFromNCBusiReqBO;
import com.tydic.uoc.common.busi.bo.BgyGetStorageFromNCBusiRspBO;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdInspectionMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdInspectionPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyGetStorageFromNCAbilityService"})
public class BgyGetStorageFromNCAbilityServiceImpl
implements BgyGetStorageFromNCAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyGetStorageFromNCAbilityServiceImpl.class);
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private OrdGoodsMapper ordGoodsMapper;
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdInspectionMapper ordInspectionMapper;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private BgyGetStorageFromNCBusiService bgyGetStorageFromNCBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    public static final Integer FSC_GET_STORAGE = 1;

    @PostMapping(value={"getStorageFromNc"})
    public BgyGetStorageFromNCAbilityRspBO getStorageFromNc(@RequestBody BgyGetStorageFromNCAbilityReqBO reqBO) {
        List ordSalePOS = null != reqBO.getIsGetStorage() && FSC_GET_STORAGE.equals(reqBO.getIsGetStorage()) ? this.ordSaleMapper.getListByPurNo(reqBO) : this.ordSaleMapper.getToBeDelivered();
        if (!CollectionUtils.isEmpty((Collection)ordSalePOS)) {
            OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
            ordInspectionPO.setOrderIds(ordSalePOS.stream().map(OrdSalePO::getOrderId).collect(Collectors.toList()));
            List ordInspectionPOS = this.ordInspectionMapper.getList(ordInspectionPO);
            HashMap<Long, List<OrdInspectionPO>> ordInspectionPOMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)ordInspectionPOS)) {
                ordInspectionPOMap = ordInspectionPOS.stream().collect(Collectors.groupingBy(OrdInspectionPO::getOrderId));
            }
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderIds(ordSalePOS.stream().map(OrdSalePO::getOrderId).collect(Collectors.toList()));
            List ordItemPOS = this.ordItemMapper.getList(ordItemPO);
            Map<Long, OrdItemPO> orderItemMap = ordItemPOS.stream().collect(Collectors.toMap(OrdItemPO::getOrdItemId, o -> o));
            Map<Long, List<OrdItemPO>> orderItemListMap = ordItemPOS.stream().collect(Collectors.groupingBy(OrdItemPO::getOrderId));
            List orderItemIdList = ordItemPOS.stream().map(OrdItemPO::getOrdItemId).collect(Collectors.toList());
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrdItemIdList(orderItemIdList);
            List ordGoodsPOList = this.ordGoodsMapper.getExtSkuId(ordGoodsPO);
            Map<Long, OrdGoodsPO> ordGoodsPOMap = ordGoodsPOList.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, o -> o));
            OrdShipPO ordShipPO = new OrdShipPO();
            ordShipPO.setOrderIds(ordSalePOS.stream().map(OrdSalePO::getOrderId).collect(Collectors.toList()));
            List shipPOS = this.ordShipMapper.getList(ordShipPO);
            Map<String, OrdShipPO> shipPOMap = shipPOS.stream().filter(ordShipPO1 -> null != ordShipPO1.getPackageId()).collect(Collectors.toMap(OrdShipPO::getShipVoucherCode, o -> o));
            BgyGetStorageFromNCBusiReqBO bgyGetStorageFromNCBusiReqBO = new BgyGetStorageFromNCBusiReqBO();
            bgyGetStorageFromNCBusiReqBO.setOrderItemListMap(orderItemListMap);
            bgyGetStorageFromNCBusiReqBO.setOrdGoodsPOMap(ordGoodsPOMap);
            bgyGetStorageFromNCBusiReqBO.setOrderItemMap(orderItemMap);
            bgyGetStorageFromNCBusiReqBO.setOrdInspectionPOMap(ordInspectionPOMap);
            bgyGetStorageFromNCBusiReqBO.setShipPOMap(shipPOMap);
            for (OrdSalePO ordSalePO : ordSalePOS) {
                bgyGetStorageFromNCBusiReqBO.setOrdSalePO(ordSalePO);
                try {
                    BgyGetStorageFromNCBusiRspBO bgyGetStorageFromNCBusiRspBO = this.bgyGetStorageFromNCBusiService.dealGetStorageFromNc(bgyGetStorageFromNCBusiReqBO);
                    if (!"0000".equals(bgyGetStorageFromNCBusiRspBO.getRespCode()) && log.isDebugEnabled()) {
                        log.debug("\u83b7\u53d6\u5165\u5e93\u5355\u5f02\u5e38\uff1a{}", (Object)bgyGetStorageFromNCBusiRspBO.getRespDesc());
                    }
                    this.sendMq(ordSalePO, bgyGetStorageFromNCBusiRspBO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.debug("\u83b7\u53d6\u5165\u5e93\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
            }
        }
        BgyGetStorageFromNCAbilityRspBO rspBO = new BgyGetStorageFromNCAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void sendMq(OrdSalePO ordSalePO, BgyGetStorageFromNCBusiRspBO bgyGetStorageFromNCBusiRspBO) {
        if (!CollectionUtils.isEmpty(bgyGetStorageFromNCBusiRspBO.getInspectionVoucherIdList())) {
            UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            uocPebOrdIdxSyncReqBO.setOrderId(ordSalePO.getOrderId());
            uocPebOrdIdxSyncReqBO.setObjId(ordSalePO.getSaleVoucherId());
            uocPebOrdIdxSyncReqBO.setObjType(PecConstant.OBJ_TYPE.SALE);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReqBO)));
            for (Long inspectionVoucherId : bgyGetStorageFromNCBusiRspBO.getInspectionVoucherIdList()) {
                UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReq = new UocPebOrdIdxSyncReqBO();
                uocPebOrdIdxSyncReq.setOrderId(ordSalePO.getOrderId());
                uocPebOrdIdxSyncReq.setObjId(inspectionVoucherId);
                uocPebOrdIdxSyncReq.setObjType(PecConstant.OBJ_TYPE.INSPECTION);
                this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReq)));
            }
        }
    }

    @PostMapping(value={"syncAllInsp"})
    public BgyGetStorageFromNCAbilityRspBO syncAllInsp(@RequestBody BgyGetStorageFromNCAbilityReqBO reqBO) {
        OrdInspectionPO ordInspectionPO = new OrdInspectionPO();
        ordInspectionPO.setInspectionVoucherId(reqBO.getInspectionVoucherId());
        ordInspectionPO.setOrderIds(reqBO.getOrderId());
        List ordInspectionPOS = this.ordInspectionMapper.getList(ordInspectionPO);
        for (OrdInspectionPO ordInspection : ordInspectionPOS) {
            UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReq = new UocPebOrdIdxSyncReqBO();
            uocPebOrdIdxSyncReq.setOrderId(ordInspection.getOrderId());
            uocPebOrdIdxSyncReq.setObjId(ordInspection.getInspectionVoucherId());
            uocPebOrdIdxSyncReq.setObjType(PecConstant.OBJ_TYPE.INSPECTION);
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)uocPebOrdIdxSyncReq)));
        }
        return new BgyGetStorageFromNCAbilityRspBO();
    }
}

