/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.BgyLogisticQueryAbilityService;
import com.tydic.uoc.common.ability.bo.BgyLogisticQueryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.BgyLogisticQueryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.BgyShipperRspBO;
import com.tydic.uoc.common.ability.bo.BgyShippersRspBO;
import com.tydic.uoc.common.ability.bo.BgyTracesRspBO;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyLogisticQueryAbilityService"})
public class BgyLogisticQueryAbilityServiceImpl
implements BgyLogisticQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyLogisticQueryAbilityServiceImpl.class);
    @Value(value="${kdApi.eBusinessId:1740154}")
    private String eBusinessId;
    @Value(value="${kdApi.apiKey:8ba81846-94db-4d31-be8c-9e29711ffb79}")
    private String apiKey;
    @Value(value="${kdApi.url:http://10.10.178.49:8001/json/kdniao/v1}")
    private String kdUrl;

    @PostMapping(value={"queryLogistic"})
    public BgyLogisticQueryAbilityRspBO queryLogistic(@RequestBody BgyLogisticQueryAbilityReqBO reqBO) {
        this.validate(reqBO);
        BgyLogisticQueryAbilityRspBO rspBo = (BgyLogisticQueryAbilityRspBO)UocProRspBoUtil.success(BgyLogisticQueryAbilityRspBO.class);
        BgyShippersRspBO bgyShippersRspBO = null;
        String reqDataGetShipperCode = "{'LogisticCode': '" + reqBO.getLogisticCode() + "'}";
        try {
            String req = this.buildJsonReqGetShipperCode(reqDataGetShipperCode);
            log.info("\u67e5\u8be2\u7269\u6d41\u5355\u53f7\u7269\u6d41\u516c\u53f8\u5165\u53c2\uff1a" + req);
            String rsp = HttpUtil.post((String)this.kdUrl, (String)req);
            bgyShippersRspBO = (BgyShippersRspBO)JSON.parseObject((String)rsp, BgyShippersRspBO.class);
            log.info("\u67e5\u8be2\u7269\u6d41\u5355\u53f7\u7269\u6d41\u516c\u53f8\u51fa\u53c2\uff1a" + rsp);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u53d1\u9001http\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        if (!bgyShippersRspBO.getSuccess().booleanValue()) {
            throw new UocProBusinessException("100001", "\u83b7\u53d6\u5bf9\u5e94\u7269\u6d41\u516c\u53f8code\u5931\u8d25\uff01");
        }
        if (StringUtils.isNotEmpty((CharSequence)((BgyShipperRspBO)bgyShippersRspBO.getShippers().get(0)).getShipperCode())) {
            reqBO.setShipperCode(((BgyShipperRspBO)bgyShippersRspBO.getShippers().get(0)).getShipperCode());
        }
        String requestData = "{'CustomerName': '','OrderCode': '','ShipperCode': '" + reqBO.getShipperCode() + "','LogisticCode': '" + reqBO.getLogisticCode() + "'}";
        String rspJson = null;
        try {
            log.info("\u67e5\u8be2\u7269\u6d41\u8ddf\u8e2a\u4fe1\u606f\u5165\u53c2\uff1a" + requestData);
            String reqJson = this.buildJsonReq(requestData);
            rspJson = HttpUtil.post((String)this.kdUrl, (String)reqJson);
            log.info("\u67e5\u8be2\u7269\u6d41\u8ddf\u8e2a\u4fe1\u606f\u51fa\u53c2\uff1a" + rspJson);
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u53d1\u9001http\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        if (rspJson == null) {
            throw new UocProBusinessException("100001", "\u6ca1\u6709\u5f97\u5230\u6b63\u786e\u56de\u5e94\u4fe1\u606f");
        }
        BgyTracesRspBO rspTraceBO = (BgyTracesRspBO)JSON.parseObject((String)rspJson, BgyTracesRspBO.class);
        if (rspTraceBO.getSuccess().booleanValue()) {
            rspBo = (BgyLogisticQueryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)rspTraceBO), BgyLogisticQueryAbilityRspBO.class);
        }
        rspBo.setShipperName(((BgyShipperRspBO)bgyShippersRspBO.getShippers().get(0)).getShipperName());
        rspBo.setShipperCode(((BgyShipperRspBO)bgyShippersRspBO.getShippers().get(0)).getShipperCode());
        return rspBo;
    }

    private void validate(BgyLogisticQueryAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getLogisticCode())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u7269\u6d41\u53f7\u3010logisticCode\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String buildJsonReq(String requestData) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RequestData", this.urlEncoder(requestData, "UTF-8"));
        params.put("EBusinessID", this.eBusinessId);
        params.put("RequestType", "8001");
        String dataSign = this.encrypt(requestData, this.apiKey, "UTF-8");
        params.put("DataSign", this.urlEncoder(dataSign, "UTF-8"));
        params.put("DataType", "2");
        return JSON.toJSONString(params);
    }

    private String buildJsonReqGetShipperCode(String requestData) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        String encodeStr = this.urlEncoder(requestData, "UTF-8");
        params.put("RequestData", encodeStr);
        params.put("EBusinessID", this.eBusinessId);
        params.put("RequestType", "2002");
        String dataSign = this.encrypt(requestData, this.apiKey, "UTF-8");
        params.put("DataSign", this.urlEncoder(dataSign, "UTF-8"));
        params.put("DataType", "2");
        return JSON.toJSONString(params);
    }

    private String MD5(String str, String charset) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes(charset));
        byte[] result = md.digest();
        StringBuffer sb = new StringBuffer(32);
        for (int i = 0; i < result.length; ++i) {
            int val = result[i] & 0xFF;
            if (val <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString().toLowerCase();
    }

    private String base64(String str, String charset) throws UnsupportedEncodingException {
        String encoded = Base64.encode(str.getBytes(charset));
        return encoded;
    }

    private String urlEncoder(String str, String charset) throws UnsupportedEncodingException {
        String result = URLEncoder.encode(str, charset);
        return result;
    }

    private String encrypt(String content, String keyValue, String charset) throws UnsupportedEncodingException, Exception {
        if (keyValue != null) {
            return this.base64(this.MD5(content + keyValue, charset), charset);
        }
        return this.base64(this.MD5(content, charset), charset);
    }
}

