/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.bo.BgyDataKanbanQueryDaoReqBo;
import com.tydic.uoc.bo.BgyDataKanbanQueryDaoRspBo;
import com.tydic.uoc.common.ability.api.BgyMyBillboardQueryAbilityService;
import com.tydic.uoc.common.ability.bo.BgyMyBillboardQueryAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyMyBillboardQueryAbilityRspBo;
import com.tydic.uoc.common.ability.bo.BgyMyBillboardQueryPurchaseOrderProgressBo;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.dao.OrderMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyMyBillboardQueryAbilityService"})
public class BgyMyBillboardQueryAbilityServiceImpl
implements BgyMyBillboardQueryAbilityService {
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    @PostMapping(value={"queryMyBillboard"})
    public BgyMyBillboardQueryAbilityRspBo queryMyBillboard(@RequestBody BgyMyBillboardQueryAbilityReqBo reqBo) {
        this.validateArgs(reqBo);
        BgyMyBillboardQueryAbilityRspBo rspBo = new BgyMyBillboardQueryAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        BgyDataKanbanQueryDaoReqBo myBillboardQueryDaoReqBo = new BgyDataKanbanQueryDaoReqBo();
        myBillboardQueryDaoReqBo.setCreateTimeEff(reqBo.getCreateTimeEff());
        myBillboardQueryDaoReqBo.setCreateTimeExp(reqBo.getCreateTimeExp());
        myBillboardQueryDaoReqBo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        ArrayList<Integer> saleStateList = new ArrayList<Integer>(4);
        saleStateList.add(UocConstant.SALE_ORDER_STATUS.PRE_ORDER);
        saleStateList.add(UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP);
        saleStateList.add(UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED);
        saleStateList.add(UocConstant.SALE_ORDER_STATUS.RECEIVED);
        myBillboardQueryDaoReqBo.setSaleStateList(saleStateList);
        List myBillboardQueryDaoRspBos = this.orderMapper.queryMyBillboard(myBillboardQueryDaoReqBo);
        BigDecimal totalSaleMoney = BigDecimal.ZERO;
        int purchaseOrderQuantity = 0;
        BigDecimal purchaseGoodsQuantity = BigDecimal.ZERO;
        BgyDataKanbanQueryDaoRspBo hasBeenStoredMyBillboardQueryDaoRspBo = null;
        ArrayList<BgyMyBillboardQueryPurchaseOrderProgressBo> purchaseOrderProgress = new ArrayList<BgyMyBillboardQueryPurchaseOrderProgressBo>();
        if (CollectionUtils.isNotEmpty((Collection)myBillboardQueryDaoRspBos)) {
            Map<Integer, BgyDataKanbanQueryDaoRspBo> dataKanbanQueryDaoRspBoMap = myBillboardQueryDaoRspBos.stream().collect(Collectors.toMap(BgyDataKanbanQueryDaoRspBo::getSaleState, bgyDataKanbanQueryDaoRspBo -> bgyDataKanbanQueryDaoRspBo));
            Iterator saleStateIterator = saleStateList.iterator();
            while (saleStateIterator.hasNext()) {
                Integer saleState = (Integer)saleStateIterator.next();
                BgyDataKanbanQueryDaoRspBo myBillboardQueryDaoRspBo = dataKanbanQueryDaoRspBoMap.get(saleState);
                if (null == myBillboardQueryDaoRspBo) continue;
                totalSaleMoney = totalSaleMoney.add(UocMoneyUtil.long2BigDecimal((Long)myBillboardQueryDaoRspBo.getTotalSaleFee()));
                purchaseOrderQuantity += myBillboardQueryDaoRspBo.getPurchaseOrderQuantity().intValue();
                purchaseGoodsQuantity = purchaseGoodsQuantity.add(myBillboardQueryDaoRspBo.getPurchaseGoodsQuantity());
                saleStateIterator.remove();
                if (UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(saleState)) {
                    if (myBillboardQueryDaoRspBo.getPurchaseOrderQuantity() <= 0) continue;
                    hasBeenStoredMyBillboardQueryDaoRspBo = myBillboardQueryDaoRspBo;
                    continue;
                }
                BgyMyBillboardQueryPurchaseOrderProgressBo myBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                myBillboardQueryPurchaseOrderProgressBo.setSaleState(myBillboardQueryDaoRspBo.getSaleState());
                myBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(myBillboardQueryDaoRspBo.getSaleState())));
                myBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(myBillboardQueryDaoRspBo.getPurchaseOrderQuantity());
                purchaseOrderProgress.add(myBillboardQueryPurchaseOrderProgressBo);
            }
        }
        rspBo.setTotalSaleMoney(totalSaleMoney);
        rspBo.setPurchaseOrderQuantity(Integer.valueOf(purchaseOrderQuantity));
        rspBo.setPurchaseGoodsQuantity(purchaseGoodsQuantity);
        this.dealStateWithoutData(saleStateList, purchaseOrderProgress);
        this.dealBeEvaluated(myBillboardQueryDaoReqBo, hasBeenStoredMyBillboardQueryDaoRspBo, purchaseOrderProgress);
        rspBo.setPurchaseOrderProgress(purchaseOrderProgress);
        return rspBo;
    }

    private void dealStateWithoutData(List<Integer> saleStateList, List<BgyMyBillboardQueryPurchaseOrderProgressBo> purchaseOrderProgress) {
        if (CollectionUtils.isNotEmpty(saleStateList)) {
            for (Integer saleState : saleStateList) {
                BgyMyBillboardQueryPurchaseOrderProgressBo myBillboardQueryPurchaseOrderProgressBo;
                if (UocConstant.SALE_ORDER_STATUS.PRE_ORDER.equals(saleState)) {
                    myBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                    myBillboardQueryPurchaseOrderProgressBo.setSaleState(saleState);
                    myBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(saleState)));
                    myBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(Integer.valueOf(0));
                    purchaseOrderProgress.add(0, myBillboardQueryPurchaseOrderProgressBo);
                    continue;
                }
                if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIP.equals(saleState)) {
                    myBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                    myBillboardQueryPurchaseOrderProgressBo.setSaleState(saleState);
                    myBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(saleState)));
                    myBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(Integer.valueOf(0));
                    purchaseOrderProgress.add(1, myBillboardQueryPurchaseOrderProgressBo);
                    continue;
                }
                if (UocConstant.SALE_ORDER_STATUS.TO_BE_SHIPPED.equals(saleState)) {
                    myBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                    myBillboardQueryPurchaseOrderProgressBo.setSaleState(saleState);
                    myBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(saleState)));
                    myBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(Integer.valueOf(0));
                    purchaseOrderProgress.add(2, myBillboardQueryPurchaseOrderProgressBo);
                    continue;
                }
                if (!UocConstant.SALE_ORDER_STATUS.RECEIVED.equals(saleState)) continue;
                Integer beEvaluatedSaleState = saleState + 1;
                BgyMyBillboardQueryPurchaseOrderProgressBo beEvaluatedMyBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setSaleState(beEvaluatedSaleState);
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(beEvaluatedSaleState)));
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(Integer.valueOf(0));
                purchaseOrderProgress.add(3, beEvaluatedMyBillboardQueryPurchaseOrderProgressBo);
                BgyMyBillboardQueryPurchaseOrderProgressBo completedMyBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                completedMyBillboardQueryPurchaseOrderProgressBo.setSaleState(saleState);
                completedMyBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(saleState)));
                completedMyBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(Integer.valueOf(0));
                purchaseOrderProgress.add(4, completedMyBillboardQueryPurchaseOrderProgressBo);
            }
        }
    }

    private void dealBeEvaluated(BgyDataKanbanQueryDaoReqBo myBillboardQueryDaoReqBo, BgyDataKanbanQueryDaoRspBo hasBeenStoredMyBillboardQueryDaoRspBo, List<BgyMyBillboardQueryPurchaseOrderProgressBo> purchaseOrderProgress) {
        if (null != hasBeenStoredMyBillboardQueryDaoRspBo) {
            myBillboardQueryDaoReqBo.setSaleStateList(null);
            myBillboardQueryDaoReqBo.setSaleState(hasBeenStoredMyBillboardQueryDaoRspBo.getSaleState());
            myBillboardQueryDaoReqBo.setFieldCode("evaluateState");
            myBillboardQueryDaoReqBo.setFieldValue("0");
            List beEvaluatedMyBillboardQueryDaoRspBos = this.orderMapper.queryMyBillboard(myBillboardQueryDaoReqBo);
            Integer beEvaluatedSaleState = hasBeenStoredMyBillboardQueryDaoRspBo.getSaleState() + 1;
            if (CollectionUtils.isNotEmpty((Collection)beEvaluatedMyBillboardQueryDaoRspBos)) {
                BgyDataKanbanQueryDaoRspBo beEvaluatedMyBillboardQueryDaoRspBo = (BgyDataKanbanQueryDaoRspBo)beEvaluatedMyBillboardQueryDaoRspBos.get(0);
                BgyMyBillboardQueryPurchaseOrderProgressBo beEvaluatedMyBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setSaleState(beEvaluatedSaleState);
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(beEvaluatedSaleState)));
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(beEvaluatedMyBillboardQueryDaoRspBo.getPurchaseOrderQuantity());
                purchaseOrderProgress.add(3, beEvaluatedMyBillboardQueryPurchaseOrderProgressBo);
                BgyMyBillboardQueryPurchaseOrderProgressBo completedMyBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                completedMyBillboardQueryPurchaseOrderProgressBo.setSaleState(hasBeenStoredMyBillboardQueryDaoRspBo.getSaleState());
                completedMyBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(hasBeenStoredMyBillboardQueryDaoRspBo.getSaleState())));
                completedMyBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(Integer.valueOf(hasBeenStoredMyBillboardQueryDaoRspBo.getPurchaseOrderQuantity() - beEvaluatedMyBillboardQueryDaoRspBo.getPurchaseOrderQuantity()));
                purchaseOrderProgress.add(4, completedMyBillboardQueryPurchaseOrderProgressBo);
            } else {
                BgyMyBillboardQueryPurchaseOrderProgressBo beEvaluatedMyBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setSaleState(beEvaluatedSaleState);
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(beEvaluatedSaleState)));
                beEvaluatedMyBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(Integer.valueOf(0));
                purchaseOrderProgress.add(3, beEvaluatedMyBillboardQueryPurchaseOrderProgressBo);
                BgyMyBillboardQueryPurchaseOrderProgressBo completedMyBillboardQueryPurchaseOrderProgressBo = new BgyMyBillboardQueryPurchaseOrderProgressBo();
                completedMyBillboardQueryPurchaseOrderProgressBo.setSaleState(hasBeenStoredMyBillboardQueryDaoRspBo.getSaleState());
                completedMyBillboardQueryPurchaseOrderProgressBo.setSaleStateStr(this.dicTranslation(String.valueOf(hasBeenStoredMyBillboardQueryDaoRspBo.getSaleState())));
                completedMyBillboardQueryPurchaseOrderProgressBo.setPurchaseOrderQuantity(hasBeenStoredMyBillboardQueryDaoRspBo.getPurchaseOrderQuantity());
                purchaseOrderProgress.add(4, completedMyBillboardQueryPurchaseOrderProgressBo);
            }
        }
    }

    private void validateArgs(BgyMyBillboardQueryAbilityReqBo reqBo) {
        if (null == reqBo) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getCreateTimeEff())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0b\u5355\u65f6\u95f4 \u5f00\u59cb[createTimeEff]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBo.getCreateTimeExp())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4e0b\u5355\u65f6\u95f4 \u7ed3\u675f[createTimeExp]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String dicTranslation(String code) {
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(code);
        dictReqBO.setPcode("SALE_ORDER_STATUS_MY_BILLBOARD");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            return dictRspBO.getDicDictionarys().getDescrip();
        }
        return null;
    }
}

