/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.common.ability.api.BgyOrderListExportAilityService;
import com.tydic.uoc.common.ability.bo.PebExtExportSaleSingleDetailListQueryReqBo;
import com.tydic.uoc.common.ability.bo.PebExtExportSaleSingleDetailListQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocExpansionConditionsMapBO;
import com.tydic.uoc.common.busi.api.BgyExportEsQryRequisitionListBusiService;
import com.tydic.uoc.common.comb.api.UocExportOrderCombService;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyOrderListExportAilityService"})
public class BgyOrderListExportAbilityServiceImpl
implements BgyOrderListExportAilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyOrderListExportAbilityServiceImpl.class);
    @Autowired
    private UocExportOrderCombService uocExportOrderCombService;
    @Autowired
    private BgyExportEsQryRequisitionListBusiService bgyExportEsQryRequisitionListBusiService;

    @PostMapping(value={"getOrderListQuery"})
    public PebExtExportSaleSingleDetailListQueryRspBO getOrderListQuery(@RequestBody PebExtExportSaleSingleDetailListQueryReqBo reqBO) {
        log.info("BgyOrderListExportAbilityServiceImpl \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        Integer exportType = reqBO.getExportType();
        if (exportType == null) {
            throw new BusinessException("8888", "\u5fc5\u4f20\u53c2\u6570[exportType]\u4e0d\u80fd\u4e3anull");
        }
        PebExtExportSaleSingleDetailListQueryRspBO rspBO = new PebExtExportSaleSingleDetailListQueryRspBO();
        if (reqBO.getExportType().equals(UocConstant.OrderExportType.MYREQUESTORDERCATALOGIN)) {
            try {
                reqBO.setRequestType(UocConstant.RequestType.CATALOG_IN);
                rspBO = this.bgyExportEsQryRequisitionListBusiService.qryEsRequisitionInfo(reqBO);
            }
            catch (Exception e) {
                log.info("MYREQUESTORDERCATALOGIN-EXPORT \u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)e.getMessage()));
                e.printStackTrace();
            }
            return rspBO;
        }
        if (reqBO.getExportType().equals(UocConstant.OrderExportType.MYREQUESTORDERCATALOGOUT)) {
            try {
                reqBO.setRequestType(UocConstant.RequestType.CATALOG_OUT);
                rspBO = this.bgyExportEsQryRequisitionListBusiService.qryEsRequisitionInfo(reqBO);
            }
            catch (Exception e) {
                log.info("MYREQUESTORDERCATALOGOUT-EXPORT \u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)e.getMessage()));
                e.printStackTrace();
            }
            return rspBO;
        }
        if (reqBO.getExportType().equals(UocConstant.OrderExportType.MYORDERCATALOGIN)) {
            try {
                reqBO.setRequestType(UocConstant.RequestType.CATALOG_IN);
                rspBO = this.uocExportOrderCombService.getOrderListQuery(reqBO);
            }
            catch (Exception e) {
                log.info("CATALOG_OUT-EXPORT \u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)e.getMessage()));
                e.printStackTrace();
            }
            return rspBO;
        }
        if (reqBO.getExportType().equals(UocConstant.OrderExportType.MYORDERCATALOGOUT)) {
            try {
                reqBO.setRequestType(UocConstant.RequestType.CATALOG_OUT);
                rspBO = this.uocExportOrderCombService.getOrderListQuery(reqBO);
            }
            catch (Exception e) {
                log.info("CATALOG_OUT-EXPORT \u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)e.getMessage()));
                e.printStackTrace();
            }
            return rspBO;
        }
        return rspBO;
    }

    private void buildQryEextendField(PebExtSalesSingleDetailsListQueryReqBO reqBO, Map<String, UocExpansionConditionsMapBO> extConditionsAllMap) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnChannel())) {
            UocExpansionConditionsMapBO ownChannelExtConditionMapBO = new UocExpansionConditionsMapBO();
            ownChannelExtConditionMapBO.setIsExpansionConditions(Boolean.valueOf(false));
            ownChannelExtConditionMapBO.setExpansionConditions(Collections.singletonList(reqBO.getOwnChannel()));
            extConditionsAllMap.put("channel", ownChannelExtConditionMapBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlanItemNo())) {
            UocExpansionConditionsMapBO planItemNoExtConditionMapBO = new UocExpansionConditionsMapBO();
            planItemNoExtConditionMapBO.setIsExpansionConditions(Boolean.valueOf(false));
            planItemNoExtConditionMapBO.setExpansionConditions(Collections.singletonList(reqBO.getPlanItemNo()));
            extConditionsAllMap.put("planItemNo", planItemNoExtConditionMapBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProcurementModel())) {
            UocExpansionConditionsMapBO procurementModelExtConditionMapBO = new UocExpansionConditionsMapBO();
            procurementModelExtConditionMapBO.setIsExpansionConditions(Boolean.valueOf(false));
            procurementModelExtConditionMapBO.setExpansionConditions(Collections.singletonList(reqBO.getProcurementModel()));
            extConditionsAllMap.put("purType", procurementModelExtConditionMapBO);
        }
        if (null != reqBO.getIsContracted()) {
            UocExpansionConditionsMapBO isContractedExtConditionMapBO = new UocExpansionConditionsMapBO();
            isContractedExtConditionMapBO.setIsExpansionConditions(Boolean.valueOf(false));
            isContractedExtConditionMapBO.setExpansionConditions(Collections.singletonList(String.valueOf(reqBO.getIsContracted())));
            extConditionsAllMap.put("isContracted", isContractedExtConditionMapBO);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCouponNo())) {
            UocExpansionConditionsMapBO orderCategoryExtConditionMapBO = new UocExpansionConditionsMapBO();
            orderCategoryExtConditionMapBO.setIsExpansionConditions(Boolean.valueOf(false));
            orderCategoryExtConditionMapBO.setExpansionConditions(Collections.singletonList(reqBO.getCouponNo()));
            extConditionsAllMap.put("couponNo", orderCategoryExtConditionMapBO);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getAfterServiceCodeList())) {
            UocExpansionConditionsMapBO afterServiceCodeExtConditionMapBO = new UocExpansionConditionsMapBO();
            afterServiceCodeExtConditionMapBO.setIsExpansionConditions(Boolean.valueOf(false));
            afterServiceCodeExtConditionMapBO.setExpansionConditions(reqBO.getAfterServiceCodeList());
            extConditionsAllMap.put("afterServiceCodeList", afterServiceCodeExtConditionMapBO);
        }
    }
}

