/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.api.BgyPrintArrivalOrderAbilityService;
import com.tydic.uoc.common.ability.bo.BgyPrintArrivalOrderAbilityReqBO;
import com.tydic.uoc.common.ability.bo.BgyPrintArrivalOrderAbilityRspBO;
import com.tydic.uoc.common.busi.api.BgyGetPrintArrivalOrderBusiService;
import com.tydic.uoc.common.busi.bo.BgyPrintArrivalGoodBusiRspBO;
import com.tydic.uoc.common.busi.bo.BgyPrintArrivalOrderBusiReqBO;
import com.tydic.uoc.common.busi.bo.BgyPrintArrivalOrderBusiRspBO;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyPrintArrivalOrderAbilityService"})
public class BgyPrintArrivalOrderAbilityServiceImpl
implements BgyPrintArrivalOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyPrintArrivalOrderAbilityServiceImpl.class);
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "uoc";
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    @Autowired
    private BgyGetPrintArrivalOrderBusiService bgyGetPrintArrivalOrderBusiService;

    @PostMapping(value={"printArrivalOrder"})
    public BgyPrintArrivalOrderAbilityRspBO printArrivalOrder(@RequestBody BgyPrintArrivalOrderAbilityReqBO reqBO) {
        this.validateParam(reqBO);
        BgyPrintArrivalOrderBusiReqBO busiReqBO = new BgyPrintArrivalOrderBusiReqBO();
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setShipVoucherId(reqBO.getShipVoucherId());
        BgyPrintArrivalOrderBusiRspBO busiRspBO = this.bgyGetPrintArrivalOrderBusiService.getArrivalOrder(busiReqBO);
        BgyPrintArrivalOrderAbilityRspBO rspBO = new BgyPrintArrivalOrderAbilityRspBO();
        this.printPdf(busiRspBO, rspBO, reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private BufferedImage createImage(String content) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf8");
        hints.put(EncodeHintType.MARGIN, 0);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 100, 100, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
            }
        }
        return image;
    }

    private void null2Empty(BgyPrintArrivalOrderBusiRspBO busiRspBO) {
        if (null == busiRspBO.getContactAddress()) {
            busiRspBO.setContactAddress("");
        }
        if (null == busiRspBO.getContactName()) {
            busiRspBO.setContactName("");
        }
        if (null == busiRspBO.getContactMobile()) {
            busiRspBO.setContactMobile("");
        }
        if (null == busiRspBO.getPurName()) {
            busiRspBO.setPurName("");
        }
        if (null == busiRspBO.getContactCountyName()) {
            busiRspBO.setContactCountyName("");
        }
        if (null == busiRspBO.getProjectName()) {
            busiRspBO.setProjectName("");
        }
        if (null == busiRspBO.getNeedStockName()) {
            busiRspBO.setNeedStockName("");
        }
        if (null == busiRspBO.getRequestCode()) {
            busiRspBO.setRequestCode("");
        }
        if (null == busiRspBO.getRequestDeptName()) {
            busiRspBO.setRequestDeptName("");
        }
        if (null == busiRspBO.getNcRequestCode()) {
            busiRspBO.setNcRequestCode("");
        }
        if (null == busiRspBO.getRequestManName()) {
            busiRspBO.setRequestManName("");
        }
        if (null == busiRspBO.getSaleVoucherNo()) {
            busiRspBO.setSaleVoucherNo("");
        }
        if (null == busiRspBO.getShipVoucherCode()) {
            busiRspBO.setShipVoucherCode("");
        }
        if (null == busiRspBO.getSupName()) {
            busiRspBO.setSupName("");
        }
        if (null == busiRspBO.getSupRelaName()) {
            busiRspBO.setSupRelaName("");
        }
        if (null == busiRspBO.getSupRelaMobile()) {
            busiRspBO.setSupRelaMobile("");
        }
        if (null == busiRspBO.getBuyerName()) {
            busiRspBO.setBuyerName("");
        }
        if (null == busiRspBO.getInvoiceNo()) {
            busiRspBO.setInvoiceNo("");
        }
        if (null == busiRspBO.getDepositBank()) {
            busiRspBO.setDepositBank("");
        }
        if (null == busiRspBO.getBankAccount()) {
            busiRspBO.setBankAccount("");
        }
        if (null == busiRspBO.getCompanyAddress()) {
            busiRspBO.setCompanyAddress("");
        }
    }

    private void printPdf(BgyPrintArrivalOrderBusiRspBO busiRspBO, BgyPrintArrivalOrderAbilityRspBO rspBO, BgyPrintArrivalOrderAbilityReqBO reqBO) {
        String imageUrl;
        String fileUrl;
        String invType;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.null2Empty(busiRspBO);
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            rspBO.setRespDesc("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\uff1a" + e);
            rspBO.setRespCode("100001");
            return;
        }
        Font bigTitleFont = new Font(baseFont, 18.0f, 1);
        Font titleFont = new Font(baseFont, 11.0f, 1);
        Font contentFont = new Font(baseFont, 11.0f, 0);
        Font litFont = new Font(baseFont, 10.0f, 0);
        int COLUMNS = 4;
        document.open();
        PdfPTable table = new PdfPTable(4);
        String titleName = null;
        titleName = busiRspBO.getSupName() + "\u5230\u8d27\u5355";
        PdfPCell cell = new PdfPCell(new Phrase(titleName, bigTitleFont));
        cell.setFixedHeight(22.8f);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setColspan(4);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u6536\u8d27\u4fe1\u606f", titleFont));
        cell.setVerticalAlignment(5);
        cell.setColspan(4);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u9001\u8d27\u5730\u5740\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getContactAllAddress(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u6536\u8d27\u4eba\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getContactName() + " " + busiRspBO.getContactMobile(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u9700\u65b9\u5355\u4f4d\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getPurName(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u6240\u5c5e\u533a\u57df\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getContactCountyName(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u9879\u76ee\u540d\u79f0\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getProjectName(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u6536\u8d27\u4ed3\u5e93\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getNeedStockName(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8ba2\u5355\u4fe1\u606f", titleFont));
        cell.setVerticalAlignment(5);
        cell.setColspan(4);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8bf7\u8d2d\u5355\u7f16\u53f7\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getRequestCode(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8bf7\u8d2d\u90e8\u95e8\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getRequestDeptName(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("NC\u8ba2\u5355\u7f16\u53f7\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getNcRequestCode(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8bf7\u8d2d\u5458\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getRequestManName(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u8ba2\u5355\u7f16\u53f7\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getSaleVoucherNo(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell();
        table.addCell(cell);
        cell = new PdfPCell();
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5230\u8d27\u5355\u7f16\u53f7\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getShipVoucherCode(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u9001\u8d27\u5355\u65e5\u671f\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        String shipTimeStr = "";
        if (null == busiRspBO.getShipTime()) {
            shipTimeStr = "";
        } else {
            Date shipTime = busiRspBO.getShipTime();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            shipTimeStr = simpleDateFormat.format(shipTime);
        }
        cell = new PdfPCell(new Phrase(shipTimeStr, contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u4f9b\u5e94\u5546\u4fe1\u606f", titleFont));
        cell.setVerticalAlignment(5);
        cell.setColspan(4);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u4f9b\u5e94\u5546\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getSupName(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getSupRelaName() + " " + busiRspBO.getSupRelaMobile(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u9700\u65b9\u53d1\u7968\u4fe1\u606f", titleFont));
        cell.setVerticalAlignment(5);
        cell.setColspan(4);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u53d1\u7968\u62ac\u5934\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getBuyerName(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getInvoiceNo(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u53d1\u7968\u7c7b\u578b\uff1a", contentFont));
        cell.setFixedHeight(43.5f);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        Integer type = busiRspBO.getInvoiceType();
        if (type == null) {
            invType = "";
        } else if (type == 0) {
            invType = "\u4e0d\u5f00\u7968";
        } else if (type == 1) {
            invType = "\u666e\u901a\u53d1\u7968";
        } else if (type == 2) {
            invType = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
        } else {
            throw new UocProBusinessException("8888", "\u589e\u503c\u7a0e\u7c7b\u578b\u9519\u8bef");
        }
        cell = new PdfPCell(new Phrase(invType, contentFont));
        cell.setFixedHeight(43.5f);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5f00\u6237\u94f6\u884c\u53ca\u8d26\u53f7\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        cell.setFixedHeight(43.5f);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getDepositBank() + busiRspBO.getBankAccount(), contentFont));
        cell.setVerticalAlignment(6);
        cell.setFixedHeight(43.5f);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase("\u5730\u5740\u7535\u8bdd\uff1a", contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(busiRspBO.getCompanyAddress(), contentFont));
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell();
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell();
        table.addCell(cell);
        PdfPTable table1 = null;
        if (busiRspBO.getGoods() != null) {
            table1 = new PdfPTable(8);
            table1.setWidthPercentage(70.0f);
            cell = new PdfPCell(new Phrase("\u5546\u54c1\u4fe1\u606f", contentFont));
            cell.setColspan(2);
            cell.setFixedHeight(22.0f);
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(1);
            table1.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7269\u6599\u5206\u7c7b", contentFont));
            cell.setFixedHeight(22.0f);
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(1);
            table1.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7269\u6599\u7f16\u7801", contentFont));
            cell.setFixedHeight(22.0f);
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(1);
            table1.addCell(cell);
            cell = new PdfPCell(new Phrase("\u7a0e\u7387", contentFont));
            cell.setFixedHeight(22.0f);
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(1);
            table1.addCell(cell);
            cell = new PdfPCell(new Phrase("\u53d1\u8d27\u6570\u91cf", contentFont));
            cell.setFixedHeight(22.0f);
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(1);
            table1.addCell(cell);
            cell = new PdfPCell(new Phrase("\u542b\u7a0e\u5355\u4ef7", contentFont));
            cell.setFixedHeight(22.0f);
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(1);
            table1.addCell(cell);
            cell = new PdfPCell(new Phrase("\u9500\u552e\u5355\u4f4d", contentFont));
            cell.setFixedHeight(22.0f);
            cell.setVerticalAlignment(5);
            cell.setHorizontalAlignment(1);
            table1.addCell(cell);
            for (BgyPrintArrivalGoodBusiRspBO good : busiRspBO.getGoods()) {
                PdfPTable tableCount = new PdfPTable(1);
                cell = new PdfPCell(new Phrase(good.getSkuName(), contentFont));
                cell.setColspan(2);
                cell.setFixedHeight(16.0f);
                cell.setBorder(0);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                tableCount.addCell(cell);
                cell = new PdfPCell(new Phrase(StrUtil.format((CharSequence)"\u5546\u54c1\u7f16\u7801\uff1a{}", (Object[])new Object[]{good.getSkuId()}), contentFont));
                cell.setColspan(2);
                cell.setFixedHeight(16.0f);
                cell.setBorder(0);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                tableCount.addCell(cell);
                cell = new PdfPCell(tableCount);
                cell.setFixedHeight(60.0f);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                cell.setColspan(2);
                table1.addCell(cell);
                cell = new PdfPCell(new Phrase(good.getL3catalogName(), contentFont));
                cell.setFixedHeight(60.0f);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                table1.addCell(cell);
                cell = new PdfPCell(new Phrase(good.getSkuMaterialId(), contentFont));
                cell.setFixedHeight(60.0f);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                table1.addCell(cell);
                cell = new PdfPCell(new Phrase(good.getTax() + "%", contentFont));
                cell.setFixedHeight(60.0f);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                table1.addCell(cell);
                cell = new PdfPCell(new Phrase(String.valueOf(good.getSendCount().intValue()), contentFont));
                cell.setFixedHeight(60.0f);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                table1.addCell(cell);
                BigDecimal salePrice = UocMoneyUtil.long2BigDecimal((Long)good.getSalePrice());
                cell = salePrice == null ? new PdfPCell(new Phrase("")) : new PdfPCell(new Phrase("\uffe5" + salePrice, contentFont));
                cell.setFixedHeight(60.0f);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                table1.addCell(cell);
                String unitStr = good.getSaleUnit();
                if (unitStr != null && !unitStr.equals(good.getUnitName())) {
                    unitStr = unitStr + "\n(\u8ba1\u91cf\u5355\u4f4d\uff1a" + good.getUnitName() + ")";
                }
                cell = new PdfPCell(new Phrase(unitStr, contentFont));
                cell.setFixedHeight(60.0f);
                cell.setVerticalAlignment(5);
                cell.setHorizontalAlignment(1);
                table1.addCell(cell);
            }
        }
        Image image = null;
        try {
            BufferedImage imageBuffered = this.createImage(busiRspBO.getNcRequestCode() + "+" + busiRspBO.getShipVoucherCode());
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)imageBuffered, "JPG", byteOut);
            image = Image.getInstance((byte[])byteOut.toByteArray());
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "pdf\u751f\u6210\u4e8c\u7ef4\u7801\u51fa\u9519");
        }
        image.scalePercent(90.0f, 90.0f);
        image.setAbsolutePosition(730.0f, 490.0f);
        try {
            table.setSpacingAfter(20.0f);
            document.add((Element)table);
            document.add((Element)image);
            if (table1 != null) {
                document.add((Element)table1);
            }
        }
        catch (DocumentException e) {
            throw new UocProBusinessException("100001", "pdf\u8ffd\u52a0table\u51fa\u9519");
        }
        finally {
            document.close();
        }
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byteOutImage = new ByteArrayOutputStream();
        try {
            PDDocument pdDocument = PDDocument.load((byte[])pdfBytes);
            PDFRenderer renderer = new PDFRenderer(pdDocument);
            BufferedImage bufImage = renderer.renderImageWithDPI(0, 150.0f);
            ImageIO.write((RenderedImage)bufImage, "png", byteOutImage);
        }
        catch (IOException e) {
            throw new UocProBusinessException("100001", "\u751f\u6210pdf\u56fe\u7247\u5931\u8d25\uff01");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replace("-", "") + "\u5230\u8d27\u5355.pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        ByteArrayInputStream inputStreamImage = new ByteArrayInputStream(byteOutImage.toByteArray());
        String imageName = UUID.randomUUID().toString().replace("-", "") + "\u5230\u8d27\u5355.png";
        String imagePath = this.fileClient.uploadFileByInputStream(PATH, imageName, (InputStream)inputStreamImage);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            fileUrl = this.ossFileUrl + path;
            imageUrl = this.ossFileUrl + imagePath;
            rspBO.setFilename(fileName);
            rspBO.setImageName(imageName);
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            FastdfsFileInfo fastdfsImageInfo = FastdfsFileInfo.toFastdfsFileInfo((String)imagePath);
            imageUrl = this.fastdfsDownloadUrl + "/" + fastdfsImageInfo.getGroupName() + "/" + fastdfsImageInfo.getFileName();
            rspBO.setFilename(fastdfsFileInfo.getFileName());
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        rspBO.setArrivalDetailsUrl(fileUrl);
        rspBO.setArrivalImageUrl(imageUrl);
    }

    private void validateParam(BgyPrintArrivalOrderAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u5355\u6253\u5370API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u5355\u6253\u5370API\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u5355\u6253\u5370API\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6\uff01");
        }
        if (reqBO.getShipVoucherId() == null) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u5355\u6253\u5370API\u5165\u53c2\u53d1\u8d27\u5355ID\u3010shipVoucherId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getShipVoucherId() == 0L) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u5355\u6253\u5370API\u5165\u53c2\u53d1\u8d27\u5355ID\u3010shipVoucherId\u3011\u4e0d\u80fd\u4e3a\u96f6\uff01");
        }
    }
}

