/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.BgyReceiveK2ApprovedMsgAbilityService;
import com.tydic.uoc.common.ability.bo.BgyReceiveK2ApprovedMsgAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyReceiveK2ApprovedMsgAbilityRspBo;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.BgyCatalogOutReceiveK2ApprovedMsgUpdateBusiService;
import com.tydic.uoc.common.busi.api.BgyReceiveK2ApprovedMsgUpdateBusiService;
import com.tydic.uoc.common.busi.bo.BgyReceiveK2ApprovedMsgUpdateBusiReqBo;
import com.tydic.uoc.common.busi.bo.BgyReceiveK2ApprovedMsgUpdateBusiRspBo;
import com.tydic.uoc.common.busi.bo.BgyReceiveK2ApprovedMsgUpdateBusiRspOrderBo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyReceiveK2ApprovedMsgAbilityService"})
public class BgyReceiveK2ApprovedMsgAbilityServiceImpl
implements BgyReceiveK2ApprovedMsgAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyReceiveK2ApprovedMsgAbilityServiceImpl.class);
    @Autowired
    private BgyReceiveK2ApprovedMsgUpdateBusiService bgyReceiveK2ApprovedMsgUpdateBusiService;
    @Autowired
    private BgyCatalogOutReceiveK2ApprovedMsgUpdateBusiService catalogOutReceiveK2ApprovedMsgUpdateBusiService;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String reqquestOrderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String requestOrderSyncTag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Value(value="${catalog_out_k2_process:CGP120714}")
    private String catalogOutKtProcess;

    @PostMapping(value={"receiveMsg"})
    public BgyReceiveK2ApprovedMsgAbilityRspBo receiveMsg(@RequestBody BgyReceiveK2ApprovedMsgAbilityReqBo reqBo) {
        BgyReceiveK2ApprovedMsgAbilityRspBo rspBo = (BgyReceiveK2ApprovedMsgAbilityRspBo)UocProRspBoUtil.success(BgyReceiveK2ApprovedMsgAbilityRspBo.class);
        log.info("K2\u56de\u8c03\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        this.validateArg(reqBo);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        BgyReceiveK2ApprovedMsgUpdateBusiReqBo updateBusiReqBo = new BgyReceiveK2ApprovedMsgUpdateBusiReqBo();
        try {
            updateBusiReqBo.setKtApproveTime(sdf.parse(reqBo.getRequestInfo().getApproveDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        BgyReceiveK2ApprovedMsgUpdateBusiRspBo bgyReceiveK2ApprovedMsgUpdateBusiRspBo = new BgyReceiveK2ApprovedMsgUpdateBusiRspBo();
        if (this.catalogOutKtProcess.equals(reqBo.getRequestInfo().getProcessCode())) {
            updateBusiReqBo.setK2Id(reqBo.getRequestInfo().getK2Id());
            updateBusiReqBo.setKtApproveOperId(reqBo.getRequestInfo().getApproverUserCode());
            updateBusiReqBo.setActionName(reqBo.getRequestInfo().getActionName());
            updateBusiReqBo.setStatus(reqBo.getRequestInfo().getStatus());
            updateBusiReqBo.setActivityName(reqBo.getRequestInfo().getActivityName());
            bgyReceiveK2ApprovedMsgUpdateBusiRspBo = this.catalogOutReceiveK2ApprovedMsgUpdateBusiService.updateData(updateBusiReqBo);
        } else {
            updateBusiReqBo.setK2Id(reqBo.getRequestInfo().getK2Id());
            updateBusiReqBo.setKtApproveOperId(reqBo.getRequestInfo().getApproverUserCode());
            updateBusiReqBo.setActionName(reqBo.getRequestInfo().getActionName());
            updateBusiReqBo.setStatus(reqBo.getRequestInfo().getStatus());
            bgyReceiveK2ApprovedMsgUpdateBusiRspBo = this.bgyReceiveK2ApprovedMsgUpdateBusiService.updateData(updateBusiReqBo);
            if (!"0000".equals(bgyReceiveK2ApprovedMsgUpdateBusiRspBo.getRespCode())) {
                throw new UocProBusinessException(bgyReceiveK2ApprovedMsgUpdateBusiRspBo.getRespCode(), bgyReceiveK2ApprovedMsgUpdateBusiRspBo.getRespDesc());
            }
        }
        Long requestId = bgyReceiveK2ApprovedMsgUpdateBusiRspBo.getRequestId();
        if (ObjectUtil.isNotEmpty((Object)requestId)) {
            UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
            combReqBO.setOrderId(requestId);
            combReqBO.setObjId(requestId);
            combReqBO.setObjType(UocConstant.OBJ_TYPE.REQUEST);
            combReqBO.setIsStatistics(Boolean.valueOf(false));
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.reqquestOrderSyncTopic, this.requestOrderSyncTag, JSON.toJSONString((Object)combReqBO)));
        }
        List<BgyReceiveK2ApprovedMsgUpdateBusiRspOrderBo> orderIdList = bgyReceiveK2ApprovedMsgUpdateBusiRspBo.getOrderIdList();
        for (BgyReceiveK2ApprovedMsgUpdateBusiRspOrderBo orderBo : orderIdList) {
            UocPebOrdIdxSyncReqBO orderSyncReqBO = new UocPebOrdIdxSyncReqBO();
            orderSyncReqBO.setOrderId(orderBo.getOrderId());
            orderSyncReqBO.setObjId(orderBo.getSaleOrderId());
            orderSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            orderSyncReqBO.setIsStatistics(Boolean.valueOf(false));
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)orderSyncReqBO)));
        }
        return rspBo;
    }

    private void validateArg(BgyReceiveK2ApprovedMsgAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104053", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestInfo())) {
            throw new UocProBusinessException("104053", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027requestInfo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestInfo().getK2Id())) {
            throw new UocProBusinessException("104053", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027requestInfo\u7684\u5c5e\u6027k2Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

