/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.BipConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.BgyRemindSupConfirmAbilityService;
import com.tydic.uoc.common.ability.bo.BgyRemindSupConfirmAbilityReqBO;
import com.tydic.uoc.common.ability.bo.BgyRemindSupConfirmAbilityRspBO;
import com.tydic.uoc.common.atom.api.UocQrySupIdAtomService;
import com.tydic.uoc.common.atom.bo.BgySetTodoAsDoneAtomArgReqBo;
import com.tydic.uoc.common.atom.bo.BgySetTodoAsDoneAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocQrySupIdAtomRspBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSendMessageAtomReqDataBo;
import com.tydic.uoc.common.busi.api.BgyRemindSupConfirmBusiService;
import com.tydic.uoc.common.busi.bo.BgyRemindSupConfirmBusiReqBO;
import com.tydic.uoc.common.busi.bo.BgyRemindSupConfirmBusiRspBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdSalePO;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyRemindSupConfirmAbilityService"})
public class BgyRemindSupAbilityServiceImpl
implements BgyRemindSupConfirmAbilityService {
    @Autowired
    private BgyRemindSupConfirmBusiService bgyRemindSupConfirmBusiService;
    @Autowired
    private UocQrySupIdAtomService uocQrySupUserIdAtomService;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TOPIC}")
    private String noticeTopic;
    @Value(value="${UOC_PRO_NOTICE_ORDER_TAG}")
    private String noticeTag;
    @Resource(name="uocProNoticeMsgProvider")
    private ProxyMessageProducer uocProNoticeMsgProvider;
    @Value(value="${UOC_PRO_BIP_DONE_NOTICE_ORDER_TOPIC:UOC_PRO_BIP_DONE_NOTICE_ORDER_TOPIC}")
    private String noticeBipDoneTopic;
    @Value(value="${UOC_PRO_BIP_DONE_NOTICE_ORDER_TAG:UOC_PRO_BIP_DONE_NOTICE_ORDER_TOPIC}")
    private String noticeBipDoneTag;
    @Resource(name="uocProBipDoneNoticeMsgProvider")
    private ProxyMessageProducer uocProBipDoneNoticeMsgProvider;
    @Value(value="${BIP_APP_NAME:BU00149}")
    private String appName;

    @PostMapping(value={"sendMessage"})
    public BgyRemindSupConfirmAbilityRspBO sendMessage(@RequestBody BgyRemindSupConfirmAbilityReqBO reqBO) {
        this.validate(reqBO);
        BgyRemindSupConfirmBusiReqBO busiReqBO = (BgyRemindSupConfirmBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), BgyRemindSupConfirmBusiReqBO.class);
        BgyRemindSupConfirmBusiRspBO busiRspBO = this.bgyRemindSupConfirmBusiService.getInfo(busiReqBO);
        UocQrySupIdAtomReqBo uocQrySupUserIdAtomReqBo = new UocQrySupIdAtomReqBo();
        uocQrySupUserIdAtomReqBo.setSupNo(busiRspBO.getSupNo());
        UocQrySupIdAtomRspBo uocQrySupUserIdAtomRspBo = this.uocQrySupUserIdAtomService.getSupIds(uocQrySupUserIdAtomReqBo);
        List<Long> supUserIds = uocQrySupUserIdAtomRspBo.getSupUserIds();
        for (Long supUserId : supUserIds) {
            UocSendMessageAtomReqBo sendMessageBo = new UocSendMessageAtomReqBo();
            sendMessageBo.setSendId(reqBO.getUserId());
            sendMessageBo.setRecId(supUserId);
            sendMessageBo.setNoticeNodeCode("20007");
            sendMessageBo.getReplaceDataList().add(new UocSendMessageAtomReqDataBo("{#\u9500\u552e\u8ba2\u5355\u7f16\u53f7#}", busiRspBO.getSaleCode()));
            this.uocProNoticeMsgProvider.send(new ProxyMessage(this.noticeTopic, this.noticeTag, JSONObject.toJSONString((Object)sendMessageBo)));
        }
        this.sendBipDoneMessage(reqBO);
        BgyRemindSupConfirmAbilityRspBO rspBO = (BgyRemindSupConfirmAbilityRspBO)UocProRspBoUtil.success(BgyRemindSupConfirmAbilityRspBO.class);
        return rspBO;
    }

    private void sendBipDoneMessage(BgyRemindSupConfirmAbilityReqBO reqBO) {
        OrdSalePO salePO = new OrdSalePO();
        salePO.setOrderId(reqBO.getOrderId());
        salePO.setSaleVoucherId(reqBO.getSaleVoucherId());
        salePO = this.ordSaleMapper.getModelBy(salePO);
        BgySetTodoAsDoneAtomReqBo sendInfoBo = new BgySetTodoAsDoneAtomReqBo();
        BgySetTodoAsDoneAtomArgReqBo arg0 = new BgySetTodoAsDoneAtomArgReqBo();
        arg0.setModelId(BipConstant.REMIND_SUP_PREFIX + salePO.getSaleVoucherNo());
        arg0.setAppName(this.appName);
        arg0.setType(BipConstant.APPROVAL_TYPE);
        arg0.setOptType(BipConstant.SET_DONE_OPT_TYPE);
        sendInfoBo.setArg0(arg0);
        this.uocProBipDoneNoticeMsgProvider.send(new ProxyMessage(this.noticeBipDoneTopic, this.noticeBipDoneTag, JSON.toJSONString((Object)sendInfoBo)));
    }

    private void validate(BgyRemindSupConfirmAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getSaleVoucherId())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u9500\u552e\u8ba2\u5355ID\u3010saleVoucherId\u3011\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getOrderId())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUserId())) {
            throw new UocProBusinessException("100001", "\u767b\u5f55\u5b58\u5728\u95ee\u9898\uff0c\u672a\u6210\u529f\u83b7\u53d6userId");
        }
    }
}

