/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgByUserStationAbilityService;
import com.tydic.uoc.busibase.busi.bo.QryOrgByUserStationReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgByUserStationRspBO;
import com.tydic.uoc.common.ability.api.BgyRequisitionListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.BgyRequisitionListBo;
import com.tydic.uoc.common.ability.bo.BgyRequisitionListQueryReqBo;
import com.tydic.uoc.common.ability.bo.BgyRequisitionListQueryRspBo;
import com.tydic.uoc.common.ability.bo.UocProSalesRemainingTimeInfoBo;
import com.tydic.uoc.common.ability.bo.UocTabsNumberQueryBO;
import com.tydic.uoc.common.busi.api.BgyEsQryRequisitionListBusiService;
import com.tydic.uoc.common.busi.bo.BgyEsQryRequisitionListBusiReqBo;
import com.tydic.uoc.common.busi.bo.BgyEsQryRequisitionListBusiRspBo;
import com.tydic.uoc.common.comb.bo.AuthorityInfoBO;
import com.tydic.uoc.dao.ConfEffectiveMapper;
import com.tydic.uoc.dao.ConfTabOrdStateMapper;
import com.tydic.uoc.po.ConfEffectivePO;
import com.tydic.uoc.po.ConfTabOrdStatePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyRequisitionListQueryAbilityService"})
public class BgyRequisitionListQueryAbilityServiceImpl
implements BgyRequisitionListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyRequisitionListQueryAbilityServiceImpl.class);
    @Autowired
    private ConfTabOrdStateMapper confTabOrdStateMapper;
    @Autowired
    private PebIntfQryOrgByUserStationAbilityService pebIntfQryOrgByUserStationAbilityService;
    @Autowired
    private BgyEsQryRequisitionListBusiService bgyEsQryRequisitionListBusiService;
    @Autowired
    private ConfEffectiveMapper confEffectiveMapper;

    @PostMapping(value={"queryRequisitionList"})
    public BgyRequisitionListQueryRspBo queryRequisitionList(@RequestBody BgyRequisitionListQueryReqBo reqBo) {
        BgyRequisitionListQueryRspBo rspBo = new BgyRequisitionListQueryRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        Boolean isPermission = this.controlPermission(reqBo);
        BgyEsQryRequisitionListBusiReqBo esQryRequisitionListBusiReqBo = (BgyEsQryRequisitionListBusiReqBo)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), BgyEsQryRequisitionListBusiReqBo.class));
        BgyEsQryRequisitionListBusiRspBo esQryRequisitionListBusiRspBo = new BgyEsQryRequisitionListBusiRspBo();
        if (null != reqBo.getTabId()) {
            esQryRequisitionListBusiReqBo.setRequestStatusList(this.getStatueList(Collections.singletonList(reqBo.getTabId())).get(reqBo.getTabId()).getStatueList());
            if (isPermission.booleanValue() && !"0000".equals((esQryRequisitionListBusiRspBo = this.bgyEsQryRequisitionListBusiService.qryEsRequisitionInfo(esQryRequisitionListBusiReqBo)).getRespCode())) {
                throw new UocProBusinessException(esQryRequisitionListBusiRspBo.getRespCode(), esQryRequisitionListBusiRspBo.getRespDesc());
            }
            this.transEsQryRequisitionListBusiRspBo(esQryRequisitionListBusiRspBo, rspBo, isPermission, reqBo);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBo.getTabIdList())) {
            esQryRequisitionListBusiReqBo.setIsQueryTab(true);
            Map<Integer, ConfTabOrdStatePO> tabInfoMap = this.getStatueList(reqBo.getTabIdList());
            esQryRequisitionListBusiReqBo.setRequestStatusList(tabInfoMap.get(0).getStatueList());
            if (isPermission.booleanValue() && !"0000".equals((esQryRequisitionListBusiRspBo = this.bgyEsQryRequisitionListBusiService.qryEsRequisitionInfo(esQryRequisitionListBusiReqBo)).getRespCode())) {
                throw new UocProBusinessException(esQryRequisitionListBusiRspBo.getRespCode(), esQryRequisitionListBusiRspBo.getRespDesc());
            }
            this.transRequisitionTabInfo(esQryRequisitionListBusiRspBo, rspBo, tabInfoMap, isPermission);
        }
        return rspBo;
    }

    private void transRequisitionTabInfo(BgyEsQryRequisitionListBusiRspBo esQryRequisitionListBusiRspBo, BgyRequisitionListQueryRspBo rspBo, Map<Integer, ConfTabOrdStatePO> tabInfoMap, Boolean isPermission) {
        ArrayList<UocTabsNumberQueryBO> saleTabCountList = new ArrayList<UocTabsNumberQueryBO>();
        Map<String, Integer> tabCountsMap = esQryRequisitionListBusiRspBo.getTabCountsMap();
        for (Map.Entry<Integer, ConfTabOrdStatePO> next : tabInfoMap.entrySet()) {
            if (next.getKey().equals(0)) continue;
            ConfTabOrdStatePO tabOrdStatePO = next.getValue();
            UocTabsNumberQueryBO tabsNumberQueryBO = new UocTabsNumberQueryBO();
            tabsNumberQueryBO.setTabId(tabOrdStatePO.getTabId() + "");
            tabsNumberQueryBO.setTabName(tabOrdStatePO.getTabName());
            int tabsCount = 0;
            if (isPermission.booleanValue()) {
                for (Integer statue : tabOrdStatePO.getStatueList()) {
                    Integer tabMapCounts = tabCountsMap.get(String.valueOf(statue));
                    if (tabMapCounts == null) continue;
                    tabsCount += tabMapCounts.intValue();
                }
            }
            tabsNumberQueryBO.setTabsCount(Integer.valueOf(tabsCount));
            saleTabCountList.add(tabsNumberQueryBO);
        }
        rspBo.setTabInfoBoList(saleTabCountList);
    }

    private void transEsQryRequisitionListBusiRspBo(BgyEsQryRequisitionListBusiRspBo esQryRequisitionListBusiRspBo, BgyRequisitionListQueryRspBo rspBo, Boolean isPermission, BgyRequisitionListQueryReqBo reqBo) {
        if (isPermission.booleanValue()) {
            rspBo.setPageNo(esQryRequisitionListBusiRspBo.getPageNo());
            rspBo.setTotal(esQryRequisitionListBusiRspBo.getTotal());
            rspBo.setRecordsTotal(esQryRequisitionListBusiRspBo.getRecordsTotal());
            rspBo.setRows(esQryRequisitionListBusiRspBo.getRows());
            if (null != esQryRequisitionListBusiRspBo.getApprovingSupplierIdSet() && esQryRequisitionListBusiRspBo.getApprovingSupplierIdSet().size() > 0) {
                esQryRequisitionListBusiRspBo.getApprovingSupplierIdSet().add("0");
                ConfEffectivePO effectivePO = new ConfEffectivePO();
                effectivePO.setEffectiveCode("1");
                effectivePO.setSupplierNoSet(esQryRequisitionListBusiRspBo.getApprovingSupplierIdSet());
                List effectivePOList = this.confEffectiveMapper.getList(effectivePO);
                if (CollectionUtils.isNotEmpty((Collection)effectivePOList)) {
                    HashMap<String, ConfEffectivePO> effectivePOMap = new HashMap<String, ConfEffectivePO>(effectivePOList.size());
                    ConfEffectivePO allEffectivePO = null;
                    for (ConfEffectivePO confEffectivePO : effectivePOList) {
                        if ("0".equals(confEffectivePO.getSupplierNo())) {
                            allEffectivePO = confEffectivePO;
                            continue;
                        }
                        effectivePOMap.put(confEffectivePO.getSupplierNo(), confEffectivePO);
                    }
                    for (BgyRequisitionListBo requisitionListBo : rspBo.getRows()) {
                        if (null == requisitionListBo.getApprovingSupplierIdSet() || requisitionListBo.getApprovingSupplierIdSet().size() <= 0) continue;
                        ConfEffectivePO leastEffectivePO = null;
                        for (String approvingSupplierId : requisitionListBo.getApprovingSupplierIdSet()) {
                            ConfEffectivePO confEffectivePO = (ConfEffectivePO)effectivePOMap.get(approvingSupplierId);
                            if (null == confEffectivePO) continue;
                            if (null == leastEffectivePO) {
                                leastEffectivePO = confEffectivePO;
                                continue;
                            }
                            if (confEffectivePO.getAging() <= 0L || leastEffectivePO.getAging() != 0L && leastEffectivePO.getAging() <= confEffectivePO.getAging()) continue;
                            leastEffectivePO = confEffectivePO;
                        }
                        if (null == leastEffectivePO && null != allEffectivePO && 0L < allEffectivePO.getAging()) {
                            leastEffectivePO = allEffectivePO;
                        }
                        if (null == leastEffectivePO || 0L >= leastEffectivePO.getAging()) continue;
                        UocProSalesRemainingTimeInfoBo remainingTimeInfoBo = new UocProSalesRemainingTimeInfoBo();
                        remainingTimeInfoBo.setSupNo(leastEffectivePO.getSupplierNo());
                        remainingTimeInfoBo.setEffectiveCode(leastEffectivePO.getEffectiveCode());
                        remainingTimeInfoBo.setBusinessTypeCode(leastEffectivePO.getBusinessTypeCode());
                        remainingTimeInfoBo.setAging(leastEffectivePO.getAging());
                        remainingTimeInfoBo.setCalculationTime(DateUtil.strToDateLong((String)requisitionListBo.getRequestTime()));
                        remainingTimeInfoBo.setTimeLeft(Long.valueOf(remainingTimeInfoBo.getCalculationTime().getTime() - leastEffectivePO.getAging()));
                        remainingTimeInfoBo.setSupplierName(leastEffectivePO.getSupplierName());
                        requisitionListBo.setRemainingTimeInfoBo(remainingTimeInfoBo);
                    }
                }
            }
        } else {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList(0));
        }
    }

    private Boolean controlPermission(BgyRequisitionListQueryReqBo reqBO) {
        AuthorityInfoBO authorityInfoBO;
        if (!(null == reqBO.getIsControlPermission() || !reqBO.getIsControlPermission().booleanValue() || (authorityInfoBO = this.getOrgInfo(reqBO)).getViewAllFlag().booleanValue() || CollectionUtils.isEmpty(authorityInfoBO.getOrgList()) && CollectionUtils.isEmpty(authorityInfoBO.getOrgListThrough()))) {
            reqBO.setOrgList(authorityInfoBO.getOrgList());
            reqBO.setOrgListThrough(authorityInfoBO.getOrgListThrough());
        }
        return true;
    }

    private AuthorityInfoBO getOrgInfo(BgyRequisitionListQueryReqBo reqBO) {
        QryOrgByUserStationReqBO qryOrgReqBO = new QryOrgByUserStationReqBO();
        if (null == reqBO.getMemIdExt() || 0L == reqBO.getMemIdExt()) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u4f1a\u5458ID[memIdExt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        qryOrgReqBO.setMemIdExt(reqBO.getMemIdExt());
        qryOrgReqBO.setStationType("ORDER_QRY_ORG_AUTH");
        QryOrgByUserStationRspBO qryOrgRspBO = this.pebIntfQryOrgByUserStationAbilityService.qryOrgTreePathByUserStation(qryOrgReqBO);
        log.debug("\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5f53\u524d\u767b\u9646\u4eba\u673a\u6784\u5217\u8868\u7ed3\u679c\u4e3a:{}", (Object)JSON.toJSONString((Object)qryOrgRspBO));
        if (!"0000".equals(qryOrgRspBO.getRespCode())) {
            throw new UocProBusinessException(qryOrgRspBO.getRespCode(), qryOrgRspBO.getRespDesc());
        }
        AuthorityInfoBO authorityInfoBO = new AuthorityInfoBO();
        if (!qryOrgRspBO.getViewAllFlag().booleanValue()) {
            authorityInfoBO.setOrgList(qryOrgRspBO.getOrgList());
            authorityInfoBO.setOrgListThrough(qryOrgRspBO.getOrgListThrough());
        }
        authorityInfoBO.setViewAllFlag(qryOrgRspBO.getViewAllFlag());
        return authorityInfoBO;
    }

    private Map<Integer, ConfTabOrdStatePO> getStatueList(List<Integer> tabIds) {
        ConfTabOrdStatePO tabOrdStatePO = new ConfTabOrdStatePO();
        LinkedHashMap<Integer, ConfTabOrdStatePO> tabInfoMap = new LinkedHashMap<Integer, ConfTabOrdStatePO>(tabIds.size());
        tabOrdStatePO.setTabIdList(tabIds);
        List confTabOrdStatePOList = this.confTabOrdStateMapper.getList(tabOrdStatePO);
        Map<Integer, ConfTabOrdStatePO> tabOrdStatePOMap = confTabOrdStatePOList.stream().collect(Collectors.toMap(ConfTabOrdStatePO::getTabId, confTabOrdStatePO -> confTabOrdStatePO));
        ArrayList<Integer> statueList = new ArrayList<Integer>();
        if (CollectionUtils.isNotEmpty((Collection)confTabOrdStatePOList)) {
            for (Integer tabId : tabIds) {
                ConfTabOrdStatePO confTabOrdStatePO2 = tabOrdStatePOMap.get(tabId);
                if (null == confTabOrdStatePO2) continue;
                String statueStr = confTabOrdStatePO2.getOrderStatusCode();
                ArrayList<Integer> statueItemList = new ArrayList<Integer>();
                if (StringUtils.hasText((String)statueStr)) {
                    if (statueStr.contains(",")) {
                        String[] statue;
                        for (String state : statue = statueStr.split(",")) {
                            statueItemList.add(Integer.valueOf(state));
                            statueList.add(Integer.valueOf(state));
                        }
                    } else {
                        statueItemList.add(Integer.valueOf(statueStr));
                        statueList.add(Integer.valueOf(statueStr));
                    }
                }
                confTabOrdStatePO2.setStatueList(statueItemList);
                tabInfoMap.put(confTabOrdStatePO2.getTabId(), confTabOrdStatePO2);
            }
        } else {
            throw new UocProBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u9875\u7b7e\uff08tabId\uff09\u914d\u7f6e\u4fe1\u606f");
        }
        ConfTabOrdStatePO confTabOrdStatePO3 = new ConfTabOrdStatePO();
        confTabOrdStatePO3.setStatueList(statueList.stream().distinct().collect(Collectors.toList()));
        tabInfoMap.put(0, confTabOrdStatePO3);
        return tabInfoMap;
    }
}

