/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocProRspBoUtil;
import com.tydic.uoc.common.ability.api.BgyResendNcOrderAbilityService;
import com.tydic.uoc.common.ability.bo.BgyResendNcOrderAbilityReqBo;
import com.tydic.uoc.common.ability.bo.BgyResendNcOrderAbilityRspBo;
import com.tydic.uoc.common.comb.bo.BgyPushRequestOrderToNcCombReqBO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.BgyResendNcOrderAbilityService"})
public class BgyResendNcOrderAbilityServiceImpl
implements BgyResendNcOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BgyResendNcOrderAbilityServiceImpl.class);
    @Resource(name="bgyUocRequestOrderToNcMsgProvider")
    private ProxyMessageProducer bgyUocRequestOrderToNcMsgProvider;
    @Value(value="${BGY_UOC_REQUEST_ORDER_NC_TOPIC}")
    private String requestOrderNcTopic;
    @Value(value="${BGY_UOC_REQUEST_ORDER_CREATE_TAG}")
    private String requestOrderNcTag;

    @PostMapping(value={"resendNcOrder"})
    public BgyResendNcOrderAbilityRspBo resendNcOrder(@RequestBody BgyResendNcOrderAbilityReqBo reqBo) {
        this.validateArg(reqBo);
        log.info("\u91cd\u65b0\u63a8\u9001nc\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        BgyResendNcOrderAbilityRspBo rspBo = (BgyResendNcOrderAbilityRspBo)UocProRspBoUtil.success(BgyResendNcOrderAbilityRspBo.class);
        BgyPushRequestOrderToNcCombReqBO ncCombReqBOreqBO = new BgyPushRequestOrderToNcCombReqBO();
        ncCombReqBOreqBO.setRequestId(reqBo.getRequestId());
        ncCombReqBOreqBO.setOrderId(reqBo.getOrderId());
        ncCombReqBOreqBO.setReSendNcOrder("1");
        this.bgyUocRequestOrderToNcMsgProvider.send(new ProxyMessage(this.requestOrderNcTopic, this.requestOrderNcTag, JSON.toJSONString((Object)ncCombReqBOreqBO)));
        return rspBo;
    }

    private void validateArg(BgyResendNcOrderAbilityReqBo reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRequestId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[requestId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

