/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.WatermarkInfoBO;
import com.tydic.uoc.common.ability.api.PebExtPrintInspectionDetailsAbilityService;
import com.tydic.uoc.common.ability.bo.OrdShipItemRspBO;
import com.tydic.uoc.common.ability.bo.OrdShipRspBO;
import com.tydic.uoc.common.ability.bo.PebExtChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderItemAbilityBO;
import com.tydic.uoc.common.ability.bo.PebExtPrintInspectionDetailsAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtPrintInspectionDetailsAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipItemRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdShipRspBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocShipDetailsQueryRspBO;
import com.tydic.uoc.common.busi.api.UocShipDetailsListQueryBusiService;
import com.tydic.uoc.common.comb.api.UocSalesSingleDetailsListQueryCombService;
import com.tydic.uoc.common.utils.PdfUtil;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtPrintInspectionDetailsAbilityService"})
public class PebExtPrintInspectionDetailsAbilityServiceImpl
implements PebExtPrintInspectionDetailsAbilityService {
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "uoc";
    @Autowired
    private UocSalesSingleDetailsListQueryCombService salesSingleDetailsListQueryCombService;
    @Autowired
    private UocShipDetailsListQueryBusiService shipDetailsListQueryBusiService;
    @Autowired
    private OrdGoodsMapper ordGoogsMapper;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"dealPrintInspectionDetails"})
    public PebExtPrintInspectionDetailsAbilityRspBO dealPrintInspectionDetails(@RequestBody PebExtPrintInspectionDetailsAbilityReqBO reqBO) {
        PebExtPrintInspectionDetailsAbilityRspBO rspBO = new PebExtPrintInspectionDetailsAbilityRspBO();
        this.validateParam(reqBO);
        UocSalesSingleDetailsListQueryRspBO salesSingleDetailsListQueryRspBO = this.salesSingleDetailsListQuery(reqBO);
        this.printInspectionDetails(salesSingleDetailsListQueryRspBO, rspBO, reqBO);
        return rspBO;
    }

    private void validateParam(PebExtPrintInspectionDetailsAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u9a8c\u6536\u5355\u6253\u5370API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOrderId() == null) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u9a8c\u6536\u5355\u6253\u5370API\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u5230\u8d27\u9a8c\u6536\u5355\u6253\u5370API\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6\uff01");
        }
    }

    private UocSalesSingleDetailsListQueryRspBO salesSingleDetailsListQuery(PebExtPrintInspectionDetailsAbilityReqBO reqBO) {
        UocSalesSingleDetailsListQueryReqBO salesSingleDetailsListQueryReqBO = new UocSalesSingleDetailsListQueryReqBO();
        salesSingleDetailsListQueryReqBO.setTabId(PebExtConstant.TabId.ALL_ORDER);
        salesSingleDetailsListQueryReqBO.setOrderId(reqBO.getOrderId());
        UocSalesSingleDetailsListQueryRspBO salesSingleDetailsListQueryRspBO = this.salesSingleDetailsListQueryCombService.getSalesSingleDetailsListQuery(salesSingleDetailsListQueryReqBO);
        if (CollectionUtils.isEmpty((Collection)salesSingleDetailsListQueryRspBO.getRows())) {
            throw new UocProBusinessException("100001", "\u8be5\u8ba2\u5355ID\u4e0b\u4e0d\u5b58\u5728\u9500\u552e\u5355");
        }
        return salesSingleDetailsListQueryRspBO;
    }

    private void printInspectionDetails(UocSalesSingleDetailsListQueryRspBO salesSingleDetailsListQueryRspBO, PebExtPrintInspectionDetailsAbilityRspBO rspBO, PebExtPrintInspectionDetailsAbilityReqBO reqBO) {
        String fileUrl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            rspBO.setRespDesc("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519\uff1a" + e);
            rspBO.setRespCode("100001");
            return;
        }
        Font titleFont = new Font(baseFont, 14.0f, 1);
        Font contentFont = new Font(baseFont, 8.0f, 0);
        Font footerFont = new Font(baseFont, 10.0f, 1);
        int COLUMNS = 10;
        document.open();
        this.doAddTextWatermark(pdfWriter, reqBO);
        PdfPTable titleTable = new PdfPTable(1);
        PdfPCell titleCell = new PdfPCell(new Phrase("\u5230\u8d27\u9a8c\u6536\u5355", titleFont));
        titleCell.setColspan(1);
        titleCell.setBorder(0);
        titleCell.setFixedHeight(30.0f);
        titleCell.setHorizontalAlignment(1);
        titleCell.setVerticalAlignment(5);
        titleTable.addCell(titleCell);
        try {
            document.add((Element)titleTable);
        }
        catch (DocumentException e) {
            rspBO.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
            rspBO.setRespCode("100001");
            return;
        }
        PebExtChildOrderAbilityBO childOrderAbilityBO = (PebExtChildOrderAbilityBO)((PebExtUpperOrderAbilityBO)salesSingleDetailsListQueryRspBO.getRows().get(0)).getChildOrderList().get(0);
        PdfPTable pdfPTable1 = new PdfPTable(10);
        PdfPCell pdfPCell1 = new PdfPCell(new Phrase("\u8ba2\u5355\u7f16\u53f7", contentFont));
        pdfPCell1.setHorizontalAlignment(2);
        pdfPCell1.setVerticalAlignment(5);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(childOrderAbilityBO.getSaleVoucherNo(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u7b2c\u4e09\u65b9\u8ba2\u5355\u7f16\u53f7", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(childOrderAbilityBO.getOutOrderId(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase("\u4e0b\u5355\u65f6\u95f4", contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(1);
        pdfPTable1.addCell(pdfPCell1);
        pdfPCell1.setPhrase(new Phrase(childOrderAbilityBO.getCreateTime(), contentFont));
        pdfPCell1.setHorizontalAlignment(1);
        pdfPCell1.setColspan(2);
        pdfPTable1.addCell(pdfPCell1);
        try {
            document.add((Element)pdfPTable1);
        }
        catch (DocumentException e) {
            rspBO.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
            rspBO.setRespCode("100001");
            return;
        }
        PdfPTable pdfPTable2 = new PdfPTable(10);
        PdfPCell pdfPCell2 = new PdfPCell(new Phrase("\u9a8c\u6536\u5355\u4f4d", contentFont));
        pdfPCell2.setHorizontalAlignment(2);
        pdfPCell2.setVerticalAlignment(5);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(childOrderAbilityBO.getPurName(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase("\u4f9b\u5e94\u5546", contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(1);
        pdfPTable2.addCell(pdfPCell2);
        pdfPCell2.setPhrase(new Phrase(((PebExtUpperOrderAbilityBO)salesSingleDetailsListQueryRspBO.getRows().get(0)).getSupName(), contentFont));
        pdfPCell2.setHorizontalAlignment(1);
        pdfPCell2.setColspan(4);
        pdfPTable2.addCell(pdfPCell2);
        try {
            document.add((Element)pdfPTable2);
        }
        catch (DocumentException e) {
            rspBO.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
            rspBO.setRespCode("100001");
            return;
        }
        PdfPTable headTable = new PdfPTable(10);
        PdfPCell headCell = new PdfPCell(new Phrase("\u5e8f\u53f7", contentFont));
        headCell.setHorizontalAlignment(1);
        headCell.setVerticalAlignment(5);
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5546\u54c1\u540d\u79f0", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u6599\u7f16\u7801", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u6599\u5206\u7c7b", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u89c4\u683c", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u578b\u53f7", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u91c7\u8d2d\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u8ba1\u91cf\u5355\u4f4d", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u5230\u8d27\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u9a8c\u6536\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u62d2\u6536\u6570\u91cf", contentFont));
        headTable.addCell(headCell);
        headCell.setPhrase(new Phrase("\u7269\u6d41\u5355\u53f7", contentFont));
        headTable.addCell(headCell);
        try {
            document.add((Element)headTable);
        }
        catch (DocumentException e) {
            rspBO.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
            rspBO.setRespCode("100001");
            return;
        }
        int count = 1;
        UocShipDetailsListQueryReqBO shipDetailsListQueryReqBO = new UocShipDetailsListQueryReqBO();
        shipDetailsListQueryReqBO.setOrderId(Long.valueOf(childOrderAbilityBO.getOrderId()));
        UocShipDetailsListQueryRspBO shipDetailsListQueryRspBO = this.shipDetailsListQueryBusiService.getShipDetailsQuery(shipDetailsListQueryReqBO);
        ArrayList<UocOrdShipRspBO> ordShipRspBOList = new ArrayList<UocOrdShipRspBO>();
        ArrayList ordShipItemRspBOList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)shipDetailsListQueryRspBO.getShipDetailsQueryRspBOList())) {
            for (UocShipDetailsQueryRspBO shipDetailsQueryRspBO : shipDetailsListQueryRspBO.getShipDetailsQueryRspBOList()) {
                ordShipRspBOList.add(shipDetailsQueryRspBO.getOrdShipRspBO());
                ordShipItemRspBOList.addAll(shipDetailsQueryRspBO.getOrdShipItemRspBOList());
            }
        }
        Map<Long, List<UocOrdShipItemRspBO>> ordShipItemRspBOMap = ordShipItemRspBOList.stream().collect(Collectors.groupingBy(OrdShipItemRspBO::getOrdItemId));
        Map ordShipRspBOMap = ordShipRspBOList.stream().collect(Collectors.toMap(OrdShipRspBO::getShipVoucherId, Function.identity(), (ordShipRspBO, ordShipRspBO1) -> ordShipRspBO));
        OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
        ordGoodsPO.setOrderId(reqBO.getOrderId());
        List ordGoodsPOS = this.ordGoogsMapper.getList(ordGoodsPO);
        Map ordGoodsPOMap = ordGoodsPOS.stream().collect(Collectors.toMap(OrdGoodsPO::getOrdItemId, Function.identity(), (ordGoodsPO1, ordGoodsPO2) -> ordGoodsPO1));
        for (PebExtOrderItemAbilityBO orderItemAbilityBO : childOrderAbilityBO.getOrderItemList()) {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getOrdItemIdList())) {
                for (Long ordItemId : reqBO.getOrdItemIdList()) {
                    if (orderItemAbilityBO.getOrderItemId().equals(ordItemId.toString())) continue;
                    break;
                }
            }
            PdfPTable detailTable = new PdfPTable(10);
            PdfPCell detailCell = new PdfPCell(new Phrase("" + count++, contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(orderItemAbilityBO.getSkuName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(orderItemAbilityBO.getSkuMaterialId(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(orderItemAbilityBO.getSkuMaterialTypeId(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            OrdGoodsPO ordGoodsPO12 = (OrdGoodsPO)ordGoodsPOMap.get(Long.valueOf(orderItemAbilityBO.getOrderItemId()));
            if (null != ordGoodsPO12) {
                detailCell.setPhrase(new Phrase(ordGoodsPO12.getSpec(), contentFont));
            } else {
                detailCell.setPhrase(new Phrase("-", contentFont));
            }
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            if (null != ordGoodsPO12) {
                detailCell.setPhrase(new Phrase(ordGoodsPO12.getModel(), contentFont));
            } else {
                detailCell.setPhrase(new Phrase("-", contentFont));
            }
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(orderItemAbilityBO.getPurchaseCount(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(orderItemAbilityBO.getUnitName(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(orderItemAbilityBO.getArriveCount(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(orderItemAbilityBO.getAcceptanceCount(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            detailCell.setPhrase(new Phrase(orderItemAbilityBO.getRefuseCount(), contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            List ordShipItemRspBOS = ordShipItemRspBOMap.get(Long.valueOf(orderItemAbilityBO.getOrderItemId()));
            String shipId = null;
            if (!CollectionUtils.isEmpty(ordShipItemRspBOS)) {
                ordShipItemRspBOS = ordShipItemRspBOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UocOrdShipItemRspBO>(Comparator.comparing(OrdShipItemRspBO::getShipVoucherId))), ArrayList::new));
                for (UocOrdShipItemRspBO shipItemRspBO : ordShipItemRspBOS) {
                    if (StringUtils.isNotBlank(shipId)) {
                        shipId = shipId + "\n" + ((UocOrdShipRspBO)ordShipRspBOMap.get(shipItemRspBO.getShipVoucherId())).getShipId();
                        continue;
                    }
                    shipId = ((UocOrdShipRspBO)ordShipRspBOMap.get(shipItemRspBO.getShipVoucherId())).getShipId();
                }
            }
            detailCell.setPhrase(new Phrase(shipId, contentFont));
            detailCell.setHorizontalAlignment(1);
            detailCell.setColspan(1);
            detailTable.addCell(detailCell);
            try {
                document.add((Element)detailTable);
            }
            catch (DocumentException e) {
                rspBO.setRespDesc("pdf\u8ffd\u52a0table\u51fa\u9519\uff1a" + (Object)((Object)e));
                rspBO.setRespCode("100001");
                return;
            }
        }
        document.close();
        byte[] pdfBytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            fileUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        rspBO.setInspectionDetailsUrl(fileUrl);
    }

    private void doAddTextWatermark(PdfWriter pdfWriter, PebExtPrintInspectionDetailsAbilityReqBO reqBO) {
        ArrayList<WatermarkInfoBO> watermarkInfoList = new ArrayList<WatermarkInfoBO>();
        WatermarkInfoBO watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u65f6\u95f4\uff1a" + DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        watermarkInfoBO.setX(300.0f);
        watermarkInfoBO.setY(310.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u6253\u5370\u4eba\uff1a" + reqBO.getName());
        watermarkInfoBO.setX(320.0f);
        watermarkInfoBO.setY(270.0f);
        watermarkInfoBO.setRotation(30.0f);
        watermarkInfoBO = new WatermarkInfoBO();
        watermarkInfoList.add(watermarkInfoBO);
        watermarkInfoBO.setWaterMarkText("\u7f51\u5740\uff1awww.dicyicai.com");
        watermarkInfoBO.setX(340.0f);
        watermarkInfoBO.setY(230.0f);
        watermarkInfoBO.setRotation(30.0f);
        PdfUtil.addTextWatermark(pdfWriter, watermarkInfoList, 0.5f, 0, BaseColor.GRAY, null, 20.0f);
    }
}

