/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebOrderDeliveryAbilityService;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebOrderDeliveryAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebProcessOrderCountBO;
import com.tydic.uoc.common.comb.api.PebOrderDeliveryCombService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebOrderDeliveryAbilityService"})
public class PebOrderDeliveryAbilityServiceImpl
implements PebOrderDeliveryAbilityService {
    @Autowired
    private PebOrderDeliveryCombService pebOrderDeliveryCombService;

    @PostMapping(value={"dealPebOrderDelivery"})
    public PebOrderDeliveryAbilityRspBO dealPebOrderDelivery(@RequestBody PebOrderDeliveryAbilityReqBO pebOrderDeliveryAbilityReqBO) {
        this.validateArg(pebOrderDeliveryAbilityReqBO);
        return this.pebOrderDeliveryCombService.dealPebOrderDelivery(pebOrderDeliveryAbilityReqBO);
    }

    private void validateArg(PebOrderDeliveryAbilityReqBO reqBo) {
        if (reqBo == null) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProcessName())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleVoucherId())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleVoucherId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTransportMode())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[transportMode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProcessPhone())) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processPhone]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List pebProcessOrderCountBOList = reqBo.getPebProcessOrderCountBOList();
        if (ObjectUtil.isEmpty((Object)pebProcessOrderCountBOList)) {
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[pebProcessOrderCountBOList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.validateProcessOrderCountBOList(reqBo.getPebProcessOrderCountBOList());
        if ("1".equals(reqBo.getTransportMode())) {
            if (ObjectUtil.isEmpty((Object)reqBo.getCarNo())) {
                throw new UocProBusinessException("104047", "\u6c7d\u8fd0\u8f66\u724c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if ("2".equals(reqBo.getTransportMode()) && ObjectUtil.isEmpty((Object)reqBo.getProcessNum())) {
            throw new UocProBusinessException("104047", "\u4e09\u65b9\u7269\u6d41\u914d\u9001\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateProcessOrderCountBOList(List<PebProcessOrderCountBO> pebProcessOrderCountBOList) {
        for (PebProcessOrderCountBO reqBo : pebProcessOrderCountBOList) {
            if (reqBo == null) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)reqBo.getOrdItemId())) {
                throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[ordItemId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)reqBo.getProcessCount())) continue;
            throw new UocProBusinessException("104047", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[processCount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

