/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.ability.bo.EsbInfoBO;
import com.tydic.uoc.common.ability.bo.PageInfo;
import com.tydic.uoc.common.atom.api.BgyCancelOrderToNcAtomService;
import com.tydic.uoc.common.atom.api.UocSaveOutInterfaceLogAtomService;
import com.tydic.uoc.common.atom.bo.BgyCancelOrderToNcAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyCancelOrderToNcAtomRspBO;
import com.tydic.uoc.common.atom.bo.CancelOrderReqBody;
import com.tydic.uoc.common.atom.bo.CancelOrderReqInfo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.SysDicDictionaryMapper;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.SysDicDictionaryPO;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyCancelOrderToNcAtomServiceImpl
implements BgyCancelOrderToNcAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyCancelOrderToNcAtomServiceImpl.class);
    @Value(value="${cancel_order_to_nc_url}")
    private String cancelOrderUrl;
    @Autowired
    private UocSaveOutInterfaceLogAtomService uocSaveOutInterfaceLogAtomServicel;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdSaleMapper saleMapper;
    @Autowired
    private UocOrdRequestMapper requestMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;

    @Override
    public BgyCancelOrderToNcAtomRspBO cancelOrder(BgyCancelOrderToNcAtomReqBO reqBO) {
        BgyCancelOrderToNcAtomRspBO rspBO = new BgyCancelOrderToNcAtomRspBO();
        try {
            Long orderId = reqBO.getOrderId();
            OrderPO orderPO = this.orderMapper.getModelById(orderId.longValue());
            if (!"T".equalsIgnoreCase(orderPO.getPushNcSuccess())) {
                rspBO.setReturnStatus("S");
                rspBO.setReturnMsg("\u6210\u529f");
                return rspBO;
            }
            Map<String, String> stringStringMap = this.qryDic();
            String cancelReason = orderPO.getCancelReason();
            cancelReason = stringStringMap.get(cancelReason);
            String cancelDesc = orderPO.getCancelDesc();
            if (ObjectUtil.isNotEmpty((Object)cancelDesc)) {
                cancelReason = cancelReason + " \uff1a" + cancelDesc;
            }
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderId);
            ordSalePO = this.saleMapper.getModelBy(ordSalePO);
            Long requestId = ordSalePO.getRequestId();
            UocOrdRequestPo requestPo = this.requestMapper.selectByPrimaryKey(requestId);
            CancelOrderReqBody requestinfo = new CancelOrderReqBody();
            CancelOrderReqInfo requestjson = new CancelOrderReqInfo();
            requestjson.setPk_order(orderPO.getNcOrderPk());
            requestjson.setVmemo(cancelReason);
            requestjson.setModifiedtime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            requestjson.setModifier(requestPo.getRequestManBip());
            requestinfo.setRequestjson(requestjson);
            reqBO.setRequestinfo(requestinfo);
            reqBO.setQueryInfo(new PageInfo());
            reqBO.setEsbInfo(new EsbInfoBO());
            reqBO.setOrderId(null);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("requestVO", (Object)reqBO);
            String reqStr = JSON.toJSONString((Object)jsonObject);
            log.info("***\u63a8\u9001\u53d6\u6d88\u8ba2\u5355\u5230NC\u5165\u53c2\uff1a{}", (Object)reqStr);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            Date start = new Date();
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.cancelOrderUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u63a8\u9001\u53d6\u6d88\u8ba2\u5355\u5230NC\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            log.info("***\u63a8\u9001\u53d6\u6d88\u8ba2\u5355\u5230NC\u51fa\u53c2\uff1a{}", (Object)returnString);
            Date end = new Date();
            UocSaveOutInterfaceLogAtomReqBo saveLogReqBo = new UocSaveOutInterfaceLogAtomReqBo(orderId, UocConstant.OBJ_TYPE.ORDER, orderId, "NC_CANCEL_ORDER", reqStr, returnString, start, end);
            this.uocSaveOutInterfaceLogAtomServicel.saveOutLog(saveLogReqBo);
            rspBO = this.dealRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u53d6\u6d88\u8ba2\u5355\u4fe1\u606f\u5230NC\u5931\u8d25\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw new UocProBusinessException("106000", "\u63a8\u9001\u53d6\u6d88\u8ba2\u5355\u4fe1\u606f\u5230NC\u5931\u8d25\u5f02\u5e38" + e.getMessage());
        }
        return rspBO;
    }

    private BgyCancelOrderToNcAtomRspBO dealRsp(String rspStr) {
        BgyCancelOrderToNcAtomRspBO rspBO = new BgyCancelOrderToNcAtomRspBO();
        rspBO.setReturnStatus(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("returnStatus"));
        rspBO.setReturnMsg(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("returnMsg"));
        return rspBO;
    }

    private Map<String, String> qryDic() {
        SysDicDictionaryPO qryPo = new SysDicDictionaryPO();
        qryPo.setPCode("ORDER_CANCEL_REASON");
        List list = this.sysDicDictionaryMapper.getList(qryPo);
        return list.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getDescrip));
    }
}

