/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyGetOrderFromNCAtomService;
import com.tydic.uoc.common.atom.bo.BgyGetOrderBodyFromNCInfoBO;
import com.tydic.uoc.common.atom.bo.BgyGetOrderFromNCAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyGetOrderHeadFromNCInfoBO;
import com.tydic.uoc.common.atom.bo.BgyGetOrderInfoFromNCRspBO;
import com.tydic.uoc.po.OrdInterLogPO;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyGetOrderFromNCAtomServiceImpl
implements BgyGetOrderFromNCAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyGetOrderFromNCAtomServiceImpl.class);
    @Value(value="${get_order_from_nc_url}")
    private String GET_ORDER_FROM_NC_URL;

    @Override
    public BgyGetOrderInfoFromNCRspBO getOrderInfo(BgyGetOrderFromNCAtomReqBO reqBO) {
        BgyGetOrderInfoFromNCRspBO rspBO = new BgyGetOrderInfoFromNCRspBO();
        OrdInterLogPO ordInterLogPO = new OrdInterLogPO();
        ordInterLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        try {
            String reqStr = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            ordInterLogPO.setOrderId(reqBO.getOrderId());
            ordInterLogPO.setObjType(UocConstant.OrderType.NC);
            ordInterLogPO.setInterCode(reqBO.getRequestInfo().getView_code());
            ordInterLogPO.setInContent(reqStr);
            log.info("\u67e5\u8be2NC\u8ba2\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)reqStr);
            ordInterLogPO.setCallTime(new Date());
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.GET_ORDER_FROM_NC_URL), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            ordInterLogPO.setRetTime(new Date());
            ordInterLogPO.setOutContent(httpRetBean.getStr());
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            log.info("\u67e5\u8be2NC\u8ba2\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)returnString);
            if (StringUtils.isEmpty((String)httpRetBean.getStr())) {
                throw new UocProBusinessException("102001", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            }
            rspBO = this.dealRsp(returnString, reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            ordInterLogPO.setErrDetail(e.getMessage());
            e.printStackTrace();
            throw new UocProBusinessException("106000", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u5f02\u5e38");
        }
        return rspBO;
    }

    private BgyGetOrderInfoFromNCRspBO dealRsp(String rspStr, BgyGetOrderFromNCAtomReqBO reqBO) {
        BgyGetOrderInfoFromNCRspBO rspBO = new BgyGetOrderInfoFromNCRspBO();
        JSONObject jsonResult = JSON.parseObject((String)rspStr).getJSONObject("resultInfo");
        JSONArray jsonArray = jsonResult.getJSONArray("responseJson");
        if ("poinfor_h_cgsc_view".equals(reqBO.getRequestInfo().getView_code())) {
            List bgyGetOrderHeadFromNCRspBOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), BgyGetOrderHeadFromNCInfoBO.class);
            rspBO.setOrderHeadInfoList(bgyGetOrderHeadFromNCRspBOS);
        } else {
            List bgyGetOrderBodyFromNCRspBOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), BgyGetOrderBodyFromNCInfoBO.class);
            rspBO.setOrderBodyInfoList(bgyGetOrderBodyFromNCRspBOS);
        }
        rspBO.setRetCode(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnCode"));
        rspBO.setRetMsg(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnMsg"));
        return rspBO;
    }
}

