/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.ability.bo.BgyGetProcessInfo;
import com.tydic.uoc.common.atom.api.BgyGetProcessAtomService;
import com.tydic.uoc.common.atom.bo.BgyGetProcessAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyGetProcessAtomRspBO;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyGetProcessAtomServiceImpl
implements BgyGetProcessAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyGetProcessAtomServiceImpl.class);
    @Value(value="${k2_get_request_order_process_url}")
    private String getRequestOrderProcessUrl;

    @Override
    public BgyGetProcessAtomRspBO getProcess(BgyGetProcessAtomReqBO reqBO) {
        BgyGetProcessAtomRspBO rspBO = new BgyGetProcessAtomRspBO();
        try {
            String reqStr = JSON.toJSONString((Object)((Object)reqBO));
            log.info("\u67e5\u770bk2\u5ba1\u6279\u60c5\u51b5\u5165\u53c2\uff1a{}", (Object)reqStr);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.getRequestOrderProcessUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u8bf7\u8d2d\u5355\u5ba1\u6279\u60c5\u51b5\u67e5\u8be2\u5931\u8d25\u63a5\u53e3\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            log.info("\u67e5\u770bk2\u5ba1\u6279\u60c5\u51b5\u51fa\u53c2\uff1a{}", (Object)returnString);
            if (StringUtils.isEmpty((String)httpRetBean.getStr())) {
                throw new UocProBusinessException("102001", "\u8bf7\u8d2d\u5355\u5ba1\u6279\u60c5\u51b5\u67e5\u8be2\u5931\u8d25\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            rspBO = this.dealRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8bf7\u8d2d\u5355\u5ba1\u6279\u60c5\u51b5\u67e5\u8be2\u5931\u8d25" + e);
            throw new UocProBusinessException("106000", "\u8bf7\u8d2d\u5355\u5ba1\u6279\u60c5\u51b5\u67e5\u8be2\u5931\u8d25");
        }
        return rspBO;
    }

    private BgyGetProcessAtomRspBO dealRsp(String rspStr) {
        BgyGetProcessAtomRspBO rspBO = new BgyGetProcessAtomRspBO();
        ArrayList<BgyGetProcessInfo> processInfoList = new ArrayList<BgyGetProcessInfo>();
        JSONObject jsonResult = JSON.parseObject((String)rspStr).getJSONObject("resultInfo");
        JSONArray jsonArray = jsonResult.getJSONArray("processLogs");
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            processInfoList.add((BgyGetProcessInfo)jsonArray.getObject(i, BgyGetProcessInfo.class));
        }
        rspBO.setReturnCode(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnCode"));
        rspBO.setReturnMsg(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnMsg"));
        rspBO.setProcessInfoList(processInfoList);
        return rspBO;
    }
}

