/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyGetRKOrderFromNCAtomService;
import com.tydic.uoc.common.atom.bo.BgyGetRKOrderFromNCAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyGetRKOrderInfoFromNCInfoBO;
import com.tydic.uoc.common.atom.bo.BgyGetRKOrderInfoFromNCRspBO;
import com.tydic.uoc.common.busi.api.BgyOrderAcceptBusiService;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyGetRKOrderFromNCAtomServiceImpl
implements BgyGetRKOrderFromNCAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyGetRKOrderFromNCAtomServiceImpl.class);
    @Value(value="${get_rk_order_from_nc_url}")
    private String getRkOrderUrl;
    @Autowired
    BgyOrderAcceptBusiService bgyOrderAcceptBusiService;

    @Override
    public BgyGetRKOrderInfoFromNCRspBO getRKOrder(BgyGetRKOrderFromNCAtomReqBO reqBO) {
        BgyGetRKOrderInfoFromNCRspBO rspBO = new BgyGetRKOrderInfoFromNCRspBO();
        try {
            String reqStr = JSON.toJSONString((Object)reqBO);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.getRkOrderUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((String)httpRetBean.getStr())) {
                throw new UocProBusinessException("102001", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            }
            rspBO = this.dealRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u5f02\u5e38" + e);
            throw new UocProBusinessException("106000", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u5f02\u5e38");
        }
        return rspBO;
    }

    private BgyGetRKOrderInfoFromNCRspBO dealRsp(String rspStr) {
        BgyGetRKOrderInfoFromNCRspBO rspBO = new BgyGetRKOrderInfoFromNCRspBO();
        ArrayList<BgyGetRKOrderInfoFromNCInfoBO> rkorderInfoList = new ArrayList<BgyGetRKOrderInfoFromNCInfoBO>();
        JSONObject jsonResult = JSON.parseObject((String)rspStr).getJSONObject("resultInfo");
        JSONArray jsonArray = jsonResult.getJSONArray("responseJson");
        for (int i = 0; i < jsonArray.size(); ++i) {
            rkorderInfoList.add((BgyGetRKOrderInfoFromNCInfoBO)jsonArray.getObject(i, BgyGetRKOrderInfoFromNCInfoBO.class));
        }
        rspBO.setRetCode(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnCode"));
        rspBO.setRetMsg(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnMsg"));
        rspBO.setRkOrderInfoList(rkorderInfoList);
        return rspBO;
    }
}

