/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyGetStorageFromNCAtomService;
import com.tydic.uoc.common.atom.bo.BgyGetStorageBodyFromNCRspBO;
import com.tydic.uoc.common.atom.bo.BgyGetStorageFromNCAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyGetStorageFromNCAtomRspBO;
import com.tydic.uoc.common.atom.bo.BgyGetStorageHeadFromNCRspBO;
import com.tydic.uoc.dao.OrdInterLogMapper;
import com.tydic.uoc.po.OrdInterLogPO;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyGetStorageFromNCAtomServiceImpl
implements BgyGetStorageFromNCAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyGetStorageFromNCAtomServiceImpl.class);
    @Value(value="${GET_STORAGE_FROM_NC_URL:http://10.10.178.49:8001/json/NcpurPublicViewQueryRestProxy/v1}")
    private String GET_STORAGE_FROM_NC_URL;
    @Autowired
    private OrdInterLogMapper ordInterLogMapper;
    private static final String NC_SUCCESS = "A0001";

    @Override
    public BgyGetStorageFromNCAtomRspBO getStorageFromNC(BgyGetStorageFromNCAtomReqBO reqBO) {
        BgyGetStorageFromNCAtomRspBO rspBO = new BgyGetStorageFromNCAtomRspBO();
        OrdInterLogPO ordInterLogPO = new OrdInterLogPO();
        ordInterLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        try {
            String reqStr = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            ordInterLogPO.setOrderId(reqBO.getRequestInfo().getOrderId());
            ordInterLogPO.setObjType(UocConstant.OrderType.NC);
            ordInterLogPO.setInterCode(reqBO.getRequestInfo().getViewCode());
            ordInterLogPO.setInContent(reqStr);
            log.info("\u67e5\u8be2NC\u5165\u5e93\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)reqStr);
            log.info("\u67e5\u8be2NC\u5165\u5e93\u5355\u4fe1\u606f\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.GET_STORAGE_FROM_NC_URL);
            ordInterLogPO.setCallTime(new Date());
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.GET_STORAGE_FROM_NC_URL), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            ordInterLogPO.setRetTime(new Date());
            ordInterLogPO.setOutContent(httpRetBean.getStr());
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            log.info("\u67e5\u8be2NC\u5165\u5e93\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)returnString);
            if (StringUtils.isEmpty((String)httpRetBean.getStr())) {
                throw new UocProBusinessException("102001", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u6570\u636e\u4e3a\u7a7a");
            }
            rspBO = this.dealRsp(returnString, reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            ordInterLogPO.setErrDetail(e.getMessage());
            e.printStackTrace();
            throw new UocProBusinessException("106000", "\u4eceNC\u83b7\u53d6\u5165\u5e93\u5355\u4fe1\u606f\u5f02\u5e38");
        }
        return rspBO;
    }

    private BgyGetStorageFromNCAtomRspBO dealRsp(String rspStr, BgyGetStorageFromNCAtomReqBO reqBO) {
        BgyGetStorageFromNCAtomRspBO rspBO = new BgyGetStorageFromNCAtomRspBO();
        JSONObject jsonResult = JSON.parseObject((String)rspStr).getJSONObject("resultInfo");
        JSONArray jsonArray = jsonResult.getJSONArray("responseJson");
        if ("crinfor_h_cgsc_view".equals(reqBO.getRequestInfo().getViewCode())) {
            List bgyGetStorageHeadFromNCRspBOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), BgyGetStorageHeadFromNCRspBO.class);
            rspBO.setBgyGetStorageHeadFromNCRspBOs(bgyGetStorageHeadFromNCRspBOS);
        } else {
            List bgyGetStorageBodyFromNCRspBOS = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), BgyGetStorageBodyFromNCRspBO.class);
            rspBO.setBgyGetStorageBodyFromNCRspBOs(bgyGetStorageBodyFromNCRspBOS);
        }
        rspBO.setRetCode(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnCode"));
        rspBO.setRetMsg(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnMsg"));
        return rspBO;
    }
}

