/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyPushArrivalNoteToISPAtomService;
import com.tydic.uoc.common.atom.api.UocSaveOutInterfaceLogAtomService;
import com.tydic.uoc.common.atom.bo.BgyPushArrivalNoteToISPAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyPushArrivalNoteToISPAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomRspBo;
import java.net.URI;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyPushArrivalNoteToISPAtomServiceImpl
implements BgyPushArrivalNoteToISPAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyPushArrivalNoteToISPAtomServiceImpl.class);
    @Value(value="${push_arrival_note_url}")
    private String pushToIspUrl;
    @Value(value="${K2_SOURCE_ID}")
    private String sourceSystem;
    @Autowired
    private UocSaveOutInterfaceLogAtomService uocSaveOutInterfaceLogAtomServicel;

    @Override
    public BgyPushArrivalNoteToISPAtomRspBO pushArrivalNote(BgyPushArrivalNoteToISPAtomReqBO reqBO) {
        BgyPushArrivalNoteToISPAtomRspBO rspBO = new BgyPushArrivalNoteToISPAtomRspBO();
        try {
            Long orderId = reqBO.getOrderId();
            reqBO.setOrderId(null);
            reqBO.setSourceSystem(this.sourceSystem);
            String reqStr = JSON.toJSONString((Object)reqBO);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            log.info("\u63a8\u9001\u5230\u8d27\u5355\u4fe1\u606f\u5165\u53c2\uff1a" + reqStr);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.pushToIspUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230NC\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            UocSaveOutInterfaceLogAtomReqBo saveLogReqBo = new UocSaveOutInterfaceLogAtomReqBo(orderId, UocConstant.OBJ_TYPE.SALE, orderId, "SHIP_ORDER_PUSH_ISP", reqStr, returnString, new Date(), new Date());
            UocSaveOutInterfaceLogAtomRspBo uocSaveOutInterfaceLogAtomRspBo = this.uocSaveOutInterfaceLogAtomServicel.saveOutLog(saveLogReqBo);
            if (!"0000".equals(uocSaveOutInterfaceLogAtomRspBo.getRespCode())) {
                throw new UocProBusinessException(uocSaveOutInterfaceLogAtomRspBo.getRespCode(), uocSaveOutInterfaceLogAtomRspBo.getRespDesc());
            }
            log.info("\u63a8\u9001\u5230\u8d27\u5355\u4fe1\u606f\u51fa\u53c2\uff1a" + returnString);
            rspBO = this.dealRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5230\u8d27\u5355\u4fe1\u606f\u5230NC\u5931\u8d25\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new UocProBusinessException("106000", "\u63a8\u9001\u5230\u8d27\u5355\u4fe1\u606f\u5230NC\u5931\u8d25\u5f02\u5e38", (Throwable)e);
        }
        return rspBO;
    }

    private BgyPushArrivalNoteToISPAtomRspBO dealRsp(String rspStr) {
        BgyPushArrivalNoteToISPAtomRspBO rspBO = new BgyPushArrivalNoteToISPAtomRspBO();
        JSONObject jsonObject = JSON.parseObject((String)rspStr);
        Boolean success = jsonObject.getBoolean("success");
        if (success != null && !success.booleanValue()) {
            rspBO.setReturnCode(jsonObject.getString("resultCode"));
            rspBO.setReturnMsg(jsonObject.getString("resultMessage"));
        } else {
            rspBO.setReturnCode("200");
            rspBO.setReturnMsg("\u6210\u529f");
        }
        return rspBO;
    }
}

