/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyPushOrderToNcAtomService;
import com.tydic.uoc.common.atom.api.UocSaveOutInterfaceLogAtomService;
import com.tydic.uoc.common.atom.bo.BgyPushOrderToNcAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyPushOrderToNcAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomRspBo;
import java.net.URI;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyPushOrderToNcAtomServiceImpl
implements BgyPushOrderToNcAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyPushOrderToNcAtomServiceImpl.class);
    @Value(value="${push_order_to_nc_url}")
    private String pushOrderUrl;
    @Autowired
    private UocSaveOutInterfaceLogAtomService uocSaveOutInterfaceLogAtomServicel;

    @Override
    public BgyPushOrderToNcAtomRspBO pushOrdertoNc(BgyPushOrderToNcAtomReqBO reqBO) {
        BgyPushOrderToNcAtomRspBO rspBO = new BgyPushOrderToNcAtomRspBO();
        try {
            Long orderId = reqBO.getOrderId();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("requestVO", (Object)reqBO);
            String reqStr = JSON.toJSONString((Object)jsonObject);
            log.info("***\u63a8\u9001\u8ba2\u5355\u5230NC\u5165\u53c2\uff1a{}", (Object)reqStr);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            Date start = new Date();
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.pushOrderUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230NC\u5931\u8d25");
            }
            Date end = new Date();
            String returnString = httpRetBean.getStr();
            UocSaveOutInterfaceLogAtomReqBo saveLogReqBo = new UocSaveOutInterfaceLogAtomReqBo(orderId, UocConstant.OBJ_TYPE.ORDER, orderId, "PUSH_NC_ORDER", reqStr, returnString, start, end);
            UocSaveOutInterfaceLogAtomRspBo uocSaveOutInterfaceLogAtomRspBo = this.uocSaveOutInterfaceLogAtomServicel.saveOutLog(saveLogReqBo);
            log.info("***\u63a8\u9001\u8ba2\u5355\u5230NC\u51fa\u53c2\uff1a{}", (Object)returnString);
            rspBO = this.dealRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230NC\u5931\u8d25\u5f02\u5e38" + e);
            throw new UocProBusinessException("106000", "\u63a8\u9001\u8ba2\u5355\u4fe1\u606f\u5230NC\u5931\u8d25\u5f02\u5e38");
        }
        return rspBO;
    }

    private BgyPushOrderToNcAtomRspBO dealRsp(String rspStr) {
        BgyPushOrderToNcAtomRspBO rspBO = new BgyPushOrderToNcAtomRspBO();
        rspBO.setReturnCode(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("returnCode"));
        rspBO.setReturnMsg(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("returnMsg"));
        rspBO.setReturnStatus(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("returnStatus"));
        rspBO.setNcOrderPk(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("attr1"));
        rspBO.setNcOrderCode(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("attr2"));
        return rspBO;
    }
}

