/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyPushRequestOrderToNcAtomService;
import com.tydic.uoc.common.atom.api.UocSaveOutInterfaceLogAtomService;
import com.tydic.uoc.common.atom.bo.BgyPushRequestOrderToNcAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyPushRequestOrderToNcAtomRspBO;
import com.tydic.uoc.common.atom.bo.BgyPushRequestOrderToNcAtomRspInfo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomRspBo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyPushRequestOrderToNcAtomServiceImpl
implements BgyPushRequestOrderToNcAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyPushRequestOrderToNcAtomServiceImpl.class);
    @Value(value="${push_request_order_to_nc_url}")
    private String pushRequestOrderUrl;
    @Autowired
    private UocSaveOutInterfaceLogAtomService uocSaveOutInterfaceLogAtomServicel;

    @Override
    public BgyPushRequestOrderToNcAtomRspBO pushOrdertoNc(BgyPushRequestOrderToNcAtomReqBO reqBO) {
        BgyPushRequestOrderToNcAtomRspBO rspBO = new BgyPushRequestOrderToNcAtomRspBO();
        try {
            Long requestId = reqBO.getRequestId();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("requestVO", (Object)reqBO);
            String reqStr = JSON.toJSONString((Object)jsonObject);
            log.info("***\u63a8\u9001\u8bf7\u8d2d\u5355\u5230NC\u5165\u53c2\uff1a{}", (Object)reqStr);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            Date start = new Date();
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.pushRequestOrderUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u63a8\u9001\u8bf7\u8d2d\u5355\u4fe1\u606f\u5230NC\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            Date end = new Date();
            UocSaveOutInterfaceLogAtomReqBo saveLogReqBo = new UocSaveOutInterfaceLogAtomReqBo(requestId, UocConstant.OBJ_TYPE.REQUEST, requestId, "PUSH_NC_REQUEST_ORDER", reqStr, returnString, start, end);
            UocSaveOutInterfaceLogAtomRspBo uocSaveOutInterfaceLogAtomRspBo = this.uocSaveOutInterfaceLogAtomServicel.saveOutLog(saveLogReqBo);
            log.info("***\u63a8\u9001\u8bf7\u8d2d\u5355\u5230NC\u51fa\u53c2\uff1a{}", (Object)returnString);
            rspBO = this.dealRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u8bf7\u8d2d\u5355\u4fe1\u606f\u5230NC\u5931\u8d25\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw new UocProBusinessException("106000", "\u63a8\u9001\u8bf7\u8d2d\u5355\u4fe1\u606f\u5230NC\u5931\u8d25\u5f02\u5e38" + e.getMessage());
        }
        return rspBO;
    }

    private BgyPushRequestOrderToNcAtomRspBO dealRsp(String rspStr) {
        BgyPushRequestOrderToNcAtomRspBO rspBO = new BgyPushRequestOrderToNcAtomRspBO();
        ArrayList<BgyPushRequestOrderToNcAtomRspInfo> infoList = new ArrayList<BgyPushRequestOrderToNcAtomRspInfo>();
        rspBO.setReturnStatus(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("returnStatus"));
        rspBO.setReturnMsg(JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("esbInfo").getString("returnMsg"));
        JSONArray jsonArray = JSON.parseObject((String)rspStr).getJSONObject("return").getJSONObject("resultInfo").getJSONArray("responseJson");
        for (int i = 0; i < jsonArray.size(); ++i) {
            infoList.add((BgyPushRequestOrderToNcAtomRspInfo)jsonArray.getObject(i, BgyPushRequestOrderToNcAtomRspInfo.class));
        }
        rspBO.setInfoList(infoList);
        return rspBO;
    }
}

