/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyRequestOrderApproveFirstAtomService;
import com.tydic.uoc.common.atom.api.UocSaveOutInterfaceLogAtomService;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveFirstReqBO;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveFirstRspBO;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomRspBo;
import com.tydic.uoc.dao.UocOrdRequestMapper;
import com.tydic.uoc.po.UocOrdRequestPo;
import java.net.URI;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyRequestOrderApproveFirstAtomServiceImpl
implements BgyRequestOrderApproveFirstAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyRequestOrderApproveFirstAtomServiceImpl.class);
    @Value(value="${k2_request_order_step1_url}")
    private String requestOrderStepOneUrl;
    @Value(value="${k2_request_order_source_id}")
    private String sourceId;
    @Value(value="${k2_request_order_process_code}")
    private String processCode;
    @Value(value="${k2_request_order_process_code_out:CGP120714}")
    private String outProcessCode;
    @Value(value="${k2_request_order_url:https://bgy-malluat.countrygarden.com.cn/#/index/agrOrderDetailK2?requestId=}")
    private String bizFormUrl;
    @Autowired
    private UocOrdRequestMapper uocOrdRequestMapper;
    @Autowired
    private UocSaveOutInterfaceLogAtomService uocSaveOutInterfaceLogAtomServicel;
    @Value(value="${BudgetDept:F19K101}")
    private String budgetDept;

    @Override
    public BgyRequestOrderApproveFirstRspBO progress(BgyRequestOrderApproveFirstReqBO reqBO) {
        BgyRequestOrderApproveFirstRspBO rspBO;
        block10: {
            rspBO = new BgyRequestOrderApproveFirstRspBO();
            Long requestId = reqBO.getRequestId();
            try {
                log.info("*******\u53d1\u8d77k2\u7b2c\u4e00\u6b65\u5ba1\u6279******");
                reqBO.getRequestInfo().setSourceId(this.sourceId);
                reqBO.getRequestInfo().setBizFormUrl(this.bizFormUrl + requestId);
                UocOrdRequestPo requestPo = this.uocOrdRequestMapper.selectByPrimaryKey(requestId);
                if (UocConstant.RequestType.CATALOG_IN.equals(requestPo.getRequestType())) {
                    reqBO.getRequestInfo().setProcessCode(this.processCode);
                    reqBO.getRequestInfo().setFolio("\u3010\u76ee\u5f55\u5185\u8bf7\u8d2d\u5355\u5ba1\u6279\u3011\u5173\u4e8e " + requestPo.getRequestManName() + " \u63d0\u4ea4\u7684\u78a7\u6842\u56ed\u91c7\u8d2d\u5546\u57ce\u76ee\u5f55\u5185\u91c7\u8d2d\u8ba2\u5355\u7684\u5ba1\u6279" + DateUtil.dateToStr((Date)requestPo.getRequestTime(), (String)"yyyyMMddHHmmss"));
                } else if (UocConstant.RequestType.CATALOG_OUT.equals(requestPo.getRequestType())) {
                    reqBO.getRequestInfo().setFolio("\u3010\u76ee\u5f55\u5916\u8bf7\u8d2d\u5355\u5ba1\u6279\u3011\u5173\u4e8e" + requestPo.getRequestManName() + "\u63d0\u4ea4\u7684\u78a7\u6842\u56ed\u91c7\u8d2d\u5546\u57ce\u76ee\u5f55\u5185\u91c7\u8d2d\u8ba2\u5355\u7684\u5ba1\u6279" + DateUtil.dateToStr((Date)requestPo.getRequestTime(), (String)"yyyyMMddHHmmss"));
                    reqBO.getRequestInfo().setProcessCode(this.outProcessCode);
                }
                reqBO.getRequestInfo().setBizId(requestId.toString());
                reqBO.getRequestInfo().setVerifyData(0);
                String reqStr = JSON.toJSONString((Object)reqBO);
                Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
                Date start = new Date();
                log.info("K2\u7b2c\u4e00\u6b21\u5ba1\u6279\u5165\u53c2\uff1a" + reqStr);
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.requestOrderStepOneUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
                if (httpRetBean.getStatus() != 200) {
                    throw new UocProBusinessException("102001", "\u8c03\u7528k2\u5ba1\u6279\u63a5\u53e3\u5931\u8d25");
                }
                Date end = new Date();
                String returnString = httpRetBean.getStr();
                log.info("K2\u7b2c\u4e00\u6b21\u5ba1\u6279\u51fa\u53c2\uff1a" + returnString);
                UocSaveOutInterfaceLogAtomReqBo saveLogReqBo = new UocSaveOutInterfaceLogAtomReqBo(requestId, UocConstant.OBJ_TYPE.REQUEST, requestId, "REQUEST_ORDER_CREATE_FIRST_APPROVE", reqStr, returnString, start, end);
                UocSaveOutInterfaceLogAtomRspBo uocSaveOutInterfaceLogAtomRspBo = this.uocSaveOutInterfaceLogAtomServicel.saveOutLog(saveLogReqBo);
                if (!"0000".equals(uocSaveOutInterfaceLogAtomRspBo.getRespCode())) {
                    throw new UocProBusinessException(uocSaveOutInterfaceLogAtomRspBo.getRespCode(), uocSaveOutInterfaceLogAtomRspBo.getRespDesc());
                }
                if (StringUtils.isEmpty((String)returnString)) {
                    throw new UocProBusinessException("102001", "k2\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                }
                rspBO = (BgyRequestOrderApproveFirstRspBO)JSONObject.parseObject((String)JSON.parseObject((String)returnString).getString("esbInfo"), BgyRequestOrderApproveFirstRspBO.class);
                rspBO.setK2Id(JSON.parseObject((String)returnString).getJSONObject("resultInfo").getString("k2Id"));
                rspBO.setFormUrl(JSON.parseObject((String)returnString).getJSONObject("resultInfo").getString("formUrl"));
                if (!ObjectUtil.isNotEmpty((Object)rspBO.getK2Id())) break block10;
                try {
                    UocOrdRequestPo uocOrdRequestPo = new UocOrdRequestPo();
                    uocOrdRequestPo.setRequestId(requestId);
                    uocOrdRequestPo.setKtId(rspBO.getK2Id());
                    uocOrdRequestPo.setKtFormUrl(rspBO.getFormUrl());
                    this.uocOrdRequestMapper.updateByPrimaryKeySelective(uocOrdRequestPo);
                }
                catch (Exception e) {
                    throw new UocProBusinessException("8888", "\u66f4\u65b0\u8bf7\u8d2d\u5355\u5931\u8d25");
                }
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u8bf7\u8d2d\u5355\u4fe1\u606f\u5230k2\u7cfb\u7edf\u8fdb\u884c\u5ba1\u6279\u5f02\u5e38" + e);
                throw new UocProBusinessException("106000", "\u540c\u6b65\u8bf7\u8d2d\u5355\u4fe1\u606f\u5230k2\u7cfb\u7edf\u8fdb\u884c\u5ba1\u6279\u5f02\u5e38", (Throwable)e);
            }
        }
        return rspBO;
    }
}

