/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyRequestOrderApproveSecondAtomService;
import com.tydic.uoc.common.atom.api.UocSaveOutInterfaceLogAtomService;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveSecondReqBO;
import com.tydic.uoc.common.atom.bo.BgyRequestOrderApproveSecondRspBO;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomRspBo;
import java.net.URI;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgyRequestOrderApproveSecondAtomServiceImpl
implements BgyRequestOrderApproveSecondAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyRequestOrderApproveSecondAtomServiceImpl.class);
    @Value(value="${k2_request_order_source_id}")
    private String sourceId;
    @Value(value="${k2_request_order_activity_name:010_\u5ba1\u6279}")
    private String activityName;
    @Value(value="${k2_request_order_step2_url}")
    private String requestOrderStepTwoUrl;
    @Autowired
    private UocSaveOutInterfaceLogAtomService uocSaveOutInterfaceLogAtomServicel;

    @Override
    public BgyRequestOrderApproveSecondRspBO progress(BgyRequestOrderApproveSecondReqBO reqBO) {
        BgyRequestOrderApproveSecondRspBO rspBO = new BgyRequestOrderApproveSecondRspBO();
        try {
            log.info("*******k2\u7b2c\u4e8c\u6b65\u5ba1\u6279\u53d1\u8d77*********");
            reqBO.getRequestInfo().setSourceId(this.sourceId);
            reqBO.getRequestInfo().setActivityName(this.activityName);
            String reqStr = JSON.toJSONString((Object)reqBO);
            Date start = new Date();
            log.info("\u8c03\u7528K2\u7b2c\u4e8c\u6b21\u5ba1\u6279\u5165\u53c2\uff1a" + reqStr);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.requestOrderStepTwoUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u8c03\u7528k2\u5ba1\u6279\u7b2c\u4e8c\u6b65\u63a5\u53e3\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            Date end = new Date();
            log.info("\u8c03\u7528K2\u7b2c\u4e8c\u6b21\u5ba1\u6279\u51fa\u53c2\uff1a" + returnString);
            UocSaveOutInterfaceLogAtomReqBo saveLogReqBo = new UocSaveOutInterfaceLogAtomReqBo(reqBO.getRequestId(), UocConstant.OBJ_TYPE.REQUEST, reqBO.getRequestId(), "REQUEST_ORDER_CREATE_SECOND_APPROVE", reqStr, returnString, start, end);
            UocSaveOutInterfaceLogAtomRspBo uocSaveOutInterfaceLogAtomRspBo = this.uocSaveOutInterfaceLogAtomServicel.saveOutLog(saveLogReqBo);
            if (!"0000".equals(uocSaveOutInterfaceLogAtomRspBo.getRespCode())) {
                throw new UocProBusinessException(uocSaveOutInterfaceLogAtomRspBo.getRespCode(), uocSaveOutInterfaceLogAtomRspBo.getRespDesc());
            }
            if (StringUtils.isEmpty((String)returnString)) {
                throw new UocProBusinessException("102001", "k2\u5ba1\u6279\u63a5\u53e3\u7b2c\u4e8c\u6b65\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            rspBO = this.dealRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528k2\u5ba1\u6279\u7b2c\u4e8c\u6b65\u63a5\u53e3\u5931\u8d25\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new UocProBusinessException("106000", "\u8c03\u7528k2\u5ba1\u6279\u7b2c\u4e8c\u6b65\u63a5\u53e3\u5931\u8d25\u5f02\u5e38", (Throwable)e);
        }
        return rspBO;
    }

    private BgyRequestOrderApproveSecondRspBO dealRsp(String str) {
        BgyRequestOrderApproveSecondRspBO rspBO = new BgyRequestOrderApproveSecondRspBO();
        rspBO = (BgyRequestOrderApproveSecondRspBO)JSONObject.parseObject((String)JSONObject.parseObject((String)str).getString("esbInfo"), BgyRequestOrderApproveSecondRspBO.class);
        return rspBO;
    }
}

