/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgySAPBudgetOccupyAtomService;
import com.tydic.uoc.common.atom.api.UocSaveOutInterfaceLogAtomService;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyInfo;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyReqBO;
import com.tydic.uoc.common.atom.bo.BgySAPBudgetOccupyRsp;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomRspBo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BgySAPBudgetOccupyAtomServiceImpl
implements BgySAPBudgetOccupyAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgySAPBudgetOccupyAtomServiceImpl.class);
    @Value(value="${sap_buddget_url}")
    private String sapBuddgetUrl;
    @Autowired
    private UocSaveOutInterfaceLogAtomService uocSaveOutInterfaceLogAtomServicel;

    @Override
    public BgySAPBudgetOccupyRsp bgySAPBudgetOccupy(BgySAPBudgetOccupyReqBO reqBO) {
        BgySAPBudgetOccupyRsp rspBO = new BgySAPBudgetOccupyRsp();
        try {
            String reqStr = JSON.toJSONString((Object)reqBO);
            Date start = new Date();
            log.info("sap\u9884\u7b97\u5360\u7528\u8bf7\u6c42\u5165\u53c2\uff1a{}", (Object)reqStr);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.sapBuddgetUrl), (Header[])header, (byte[])reqStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102000", "SAP\u9884\u7b97\u989d\u5ea6\u5360\u7528\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            log.info("SAP\u9884\u7b97\u5360\u7528\u51fa\u53c2: {}", (Object)returnString);
            Date end = new Date();
            UocSaveOutInterfaceLogAtomReqBo saveLogReqBo = new UocSaveOutInterfaceLogAtomReqBo(reqBO.getRequestId(), UocConstant.OBJ_TYPE.REQUEST, reqBO.getRequestId(), "PUSH_SAP", reqStr, returnString, start, end);
            UocSaveOutInterfaceLogAtomRspBo uocSaveOutInterfaceLogAtomRspBo = this.uocSaveOutInterfaceLogAtomServicel.saveOutLog(saveLogReqBo);
            if (!"0000".equals(uocSaveOutInterfaceLogAtomRspBo.getRespCode())) {
                throw new UocProBusinessException(uocSaveOutInterfaceLogAtomRspBo.getRespCode(), uocSaveOutInterfaceLogAtomRspBo.getRespDesc());
            }
            rspBO = this.dealRsp(returnString);
            if (StringUtils.isEmpty((String)returnString)) {
                throw new UocProBusinessException("102001", "SAP\u9884\u7b97\u989d\u5ea6\u5360\u7528\u63a5\u53e3\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a");
            }
        }
        catch (Exception e) {
            throw new UocProBusinessException("102000", "SAP\u9884\u7b97\u989d\u5ea6\u5360\u7528\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        return rspBO;
    }

    private BgySAPBudgetOccupyRsp dealRsp(String rspStr) {
        BgySAPBudgetOccupyRsp rsp = new BgySAPBudgetOccupyRsp();
        ArrayList<BgySAPBudgetOccupyInfo> sapBudgetOccupyInfoList = new ArrayList<BgySAPBudgetOccupyInfo>();
        JSONObject jsonResult = JSON.parseObject((String)rspStr).getJSONObject("resultInfo");
        JSONArray jsonArray = jsonResult.getJSONArray("Item");
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            sapBudgetOccupyInfoList.add((BgySAPBudgetOccupyInfo)jsonArray.getObject(i, BgySAPBudgetOccupyInfo.class));
        }
        rsp.setSapBudgetOccupyInfoList(sapBudgetOccupyInfoList);
        rsp.setReturnCode(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnCode"));
        rsp.setReturnMsg(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnMsg"));
        rsp.setReturnStatus(JSON.parseObject((String)rspStr).getJSONObject("esbInfo").getString("returnStatus"));
        return rsp;
    }
}

