/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.http.HSHttpHelper;
import com.tydic.uoc.base.utils.http.HttpRetBean;
import com.tydic.uoc.common.atom.api.BgyStorageSyncEcomAtomService;
import com.tydic.uoc.common.atom.api.UocSaveOutInterfaceLogAtomService;
import com.tydic.uoc.common.atom.bo.BgyStorageSyncEcomAtomReqBO;
import com.tydic.uoc.common.atom.bo.BgyStorageSyncEcomAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomReqBo;
import com.tydic.uoc.common.atom.bo.UocSaveOutInterfaceLogAtomRspBo;
import java.net.URI;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BgyStorageSyncEcomAtomServiceImpl
implements BgyStorageSyncEcomAtomService {
    private static final Logger log = LoggerFactory.getLogger(BgyStorageSyncEcomAtomServiceImpl.class);
    @Autowired
    private Environment environment;
    @Value(value="${esb.syncStorageEcom.url:http://10.10.178.49:8001/json/syncInStock/v1}")
    private String ESB_STORAGE_SYNC_ECOM_URL;
    private static final String SUCCESS = "true";
    @Autowired
    private UocSaveOutInterfaceLogAtomService uocSaveOutInterfaceLogAtomService;

    @Override
    public BgyStorageSyncEcomAtomRspBO dealStorageSyncEcom(BgyStorageSyncEcomAtomReqBO reqBO) {
        this.val(reqBO);
        BgyStorageSyncEcomAtomRspBO bgyStorageSyncEcomAtomRspBO = null;
        try {
            String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            jsonObject.put("hsn", (Object)hsn);
            String reqEsbStr = JSON.toJSONString((Object)jsonObject);
            log.debug("\u540c\u6b65\u7535\u5546\u5165\u5e93\u5355\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.ESB_STORAGE_SYNC_ECOM_URL);
            log.debug("\u540c\u6b65\u7535\u5546\u5165\u5e93\u5355\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)reqEsbStr);
            Header[] header = new Header[]{new BasicHeader("Content-Type", "application/json;charset=UTF-8")};
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest((URI)new URI(this.ESB_STORAGE_SYNC_ECOM_URL), (Header[])header, (byte[])reqEsbStr.getBytes("UTF-8"), (String)"UTF-8", (Boolean)false);
            UocSaveOutInterfaceLogAtomReqBo saveLogReqBo = new UocSaveOutInterfaceLogAtomReqBo(reqBO.getOurOrderId(), UocConstant.OBJ_TYPE.ORDER, reqBO.getOurOrderId(), "SYNC_ECOM_STORAGE_ORDER", reqEsbStr, httpRetBean.getStr(), new Date(), new Date());
            UocSaveOutInterfaceLogAtomRspBo uocSaveOutInterfaceLogAtomRspBo = this.uocSaveOutInterfaceLogAtomService.saveOutLog(saveLogReqBo);
            if (!"0000".equals(uocSaveOutInterfaceLogAtomRspBo.getRespCode())) {
                throw new UocProBusinessException(uocSaveOutInterfaceLogAtomRspBo.getRespCode(), uocSaveOutInterfaceLogAtomRspBo.getRespDesc());
            }
            if (httpRetBean.getStatus() != 200) {
                throw new UocProBusinessException("102001", "\u540c\u6b65\u7535\u5546\u5165\u5e93\u5355\u5931\u8d25");
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((String)httpRetBean.getStr())) {
                throw new UocProBusinessException("102001", "\u540c\u6b65\u7535\u5546\u5165\u5e93\u5355\u5931\u8d25");
            }
            log.debug("\u540c\u6b65\u7535\u5546\u5165\u5e93\u5355\u636e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)returnString);
            bgyStorageSyncEcomAtomRspBO = (BgyStorageSyncEcomAtomRspBO)((Object)JSON.parseObject((String)returnString, BgyStorageSyncEcomAtomRspBO.class));
            if (!SUCCESS.equals(bgyStorageSyncEcomAtomRspBO.getSuccess())) {
                throw new UocProBusinessException("102001", StrUtil.format((CharSequence)"\u540c\u6b65\u7535\u5546\u5165\u5e93\u5355\u5931\u8d25:{}", (Object[])new Object[]{bgyStorageSyncEcomAtomRspBO.getResultMessage()}));
            }
            bgyStorageSyncEcomAtomRspBO.setRespCode("0000");
            bgyStorageSyncEcomAtomRspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bgyStorageSyncEcomAtomRspBO;
    }

    private void val(BgyStorageSyncEcomAtomReqBO reqBO) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)reqBO.getSupplierId())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang.StringUtils.isBlank((String)reqBO.getOrderId())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getStockInfo())) {
            throw new UocProBusinessException("8888", "\u5165\u53c2[stockInfo]\u4e3a\u7a7a");
        }
    }
}

